/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SoftwaresStateBuilder.class)
public final class SoftwaresState
implements ComponentState {
    public static final String TYPE = "softwares";
    private final String type = "softwares";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final @NotNull List<@Valid Software> softwares;

    public SoftwaresState(String pluginId, List<@Valid Software> softwares) {
        this.pluginId = pluginId;
        this.softwares = ListUtils.createUnmodifiableList(softwares);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SoftwaresStateBuilder builder() {
        return new SoftwaresStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwaresStateBuilder toBuilder() {
        return new SoftwaresStateBuilder().pluginId(this.pluginId).softwares(this.softwares);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid Software> getSoftwares() {
        return this.softwares;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoftwaresState)) {
            return false;
        }
        SoftwaresState other = (SoftwaresState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        List<Software> this$softwares = this.getSoftwares();
        List<Software> other$softwares = other.getSoftwares();
        return !(this$softwares == null ? other$softwares != null : !((Object)this$softwares).equals(other$softwares));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        List<Software> $softwares = this.getSoftwares();
        result = result * 59 + ($softwares == null ? 43 : ((Object)$softwares).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SoftwaresState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", softwares=" + this.getSoftwares() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwaresState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new SoftwaresState(pluginId, this.softwares);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SoftwaresState withSoftwares(@NotNull List<@Valid Software> softwares) {
        return this.softwares == softwares ? this : new SoftwaresState(this.pluginId, softwares);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SoftwaresStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Software> softwares;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SoftwaresStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwaresStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwaresStateBuilder softwares(@NotNull List<@Valid Software> softwares) {
            this.softwares = softwares;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SoftwaresState build() {
            return new SoftwaresState(this.pluginId, this.softwares);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SoftwaresState.SoftwaresStateBuilder(pluginId=" + this.pluginId + ", softwares=" + this.softwares + ")";
        }
    }
}

