/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import lombok.Generated;
import tech.kronicle.sdk.models.SummaryCallGraph;
import tech.kronicle.sdk.models.SummaryComponentDependencies;
import tech.kronicle.sdk.models.SummaryMissingComponent;
import tech.kronicle.sdk.models.SummarySubComponentDependencies;
import tech.kronicle.sdk.models.sonarqube.SummarySonarQubeMetric;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SummaryBuilder.class)
public final class Summary {
    public static final Summary EMPTY = Summary.builder().build();
    private final List<SummaryMissingComponent> missingComponents;
    private final SummaryComponentDependencies componentDependencies;
    private final SummarySubComponentDependencies subComponentDependencies;
    private final List<SummaryCallGraph> callGraphs;
    private final List<SummarySonarQubeMetric> sonarQubeMetrics;

    public Summary(List<SummaryMissingComponent> missingComponents, SummaryComponentDependencies componentDependencies, SummarySubComponentDependencies subComponentDependencies, List<SummaryCallGraph> callGraphs, List<SummarySonarQubeMetric> sonarQubeMetrics) {
        this.missingComponents = ListUtils.createUnmodifiableList(missingComponents);
        this.componentDependencies = componentDependencies;
        this.subComponentDependencies = subComponentDependencies;
        this.callGraphs = ListUtils.createUnmodifiableList(callGraphs);
        this.sonarQubeMetrics = ListUtils.createUnmodifiableList(sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SummaryBuilder builder() {
        return new SummaryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryBuilder toBuilder() {
        return new SummaryBuilder().missingComponents(this.missingComponents).componentDependencies(this.componentDependencies).subComponentDependencies(this.subComponentDependencies).callGraphs(this.callGraphs).sonarQubeMetrics(this.sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SummaryMissingComponent> getMissingComponents() {
        return this.missingComponents;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependencies getComponentDependencies() {
        return this.componentDependencies;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummarySubComponentDependencies getSubComponentDependencies() {
        return this.subComponentDependencies;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SummaryCallGraph> getCallGraphs() {
        return this.callGraphs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SummarySonarQubeMetric> getSonarQubeMetrics() {
        return this.sonarQubeMetrics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)o;
        List<SummaryMissingComponent> this$missingComponents = this.getMissingComponents();
        List<SummaryMissingComponent> other$missingComponents = other.getMissingComponents();
        if (this$missingComponents == null ? other$missingComponents != null : !((Object)this$missingComponents).equals(other$missingComponents)) {
            return false;
        }
        SummaryComponentDependencies this$componentDependencies = this.getComponentDependencies();
        SummaryComponentDependencies other$componentDependencies = other.getComponentDependencies();
        if (this$componentDependencies == null ? other$componentDependencies != null : !((Object)this$componentDependencies).equals(other$componentDependencies)) {
            return false;
        }
        SummarySubComponentDependencies this$subComponentDependencies = this.getSubComponentDependencies();
        SummarySubComponentDependencies other$subComponentDependencies = other.getSubComponentDependencies();
        if (this$subComponentDependencies == null ? other$subComponentDependencies != null : !((Object)this$subComponentDependencies).equals(other$subComponentDependencies)) {
            return false;
        }
        List<SummaryCallGraph> this$callGraphs = this.getCallGraphs();
        List<SummaryCallGraph> other$callGraphs = other.getCallGraphs();
        if (this$callGraphs == null ? other$callGraphs != null : !((Object)this$callGraphs).equals(other$callGraphs)) {
            return false;
        }
        List<SummarySonarQubeMetric> this$sonarQubeMetrics = this.getSonarQubeMetrics();
        List<SummarySonarQubeMetric> other$sonarQubeMetrics = other.getSonarQubeMetrics();
        return !(this$sonarQubeMetrics == null ? other$sonarQubeMetrics != null : !((Object)this$sonarQubeMetrics).equals(other$sonarQubeMetrics));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SummaryMissingComponent> $missingComponents = this.getMissingComponents();
        result = result * 59 + ($missingComponents == null ? 43 : ((Object)$missingComponents).hashCode());
        SummaryComponentDependencies $componentDependencies = this.getComponentDependencies();
        result = result * 59 + ($componentDependencies == null ? 43 : ((Object)$componentDependencies).hashCode());
        SummarySubComponentDependencies $subComponentDependencies = this.getSubComponentDependencies();
        result = result * 59 + ($subComponentDependencies == null ? 43 : ((Object)$subComponentDependencies).hashCode());
        List<SummaryCallGraph> $callGraphs = this.getCallGraphs();
        result = result * 59 + ($callGraphs == null ? 43 : ((Object)$callGraphs).hashCode());
        List<SummarySonarQubeMetric> $sonarQubeMetrics = this.getSonarQubeMetrics();
        result = result * 59 + ($sonarQubeMetrics == null ? 43 : ((Object)$sonarQubeMetrics).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Summary(missingComponents=" + this.getMissingComponents() + ", componentDependencies=" + this.getComponentDependencies() + ", subComponentDependencies=" + this.getSubComponentDependencies() + ", callGraphs=" + this.getCallGraphs() + ", sonarQubeMetrics=" + this.getSonarQubeMetrics() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Summary withMissingComponents(List<SummaryMissingComponent> missingComponents) {
        return this.missingComponents == missingComponents ? this : new Summary(missingComponents, this.componentDependencies, this.subComponentDependencies, this.callGraphs, this.sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Summary withComponentDependencies(SummaryComponentDependencies componentDependencies) {
        return this.componentDependencies == componentDependencies ? this : new Summary(this.missingComponents, componentDependencies, this.subComponentDependencies, this.callGraphs, this.sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Summary withSubComponentDependencies(SummarySubComponentDependencies subComponentDependencies) {
        return this.subComponentDependencies == subComponentDependencies ? this : new Summary(this.missingComponents, this.componentDependencies, subComponentDependencies, this.callGraphs, this.sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Summary withCallGraphs(List<SummaryCallGraph> callGraphs) {
        return this.callGraphs == callGraphs ? this : new Summary(this.missingComponents, this.componentDependencies, this.subComponentDependencies, callGraphs, this.sonarQubeMetrics);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Summary withSonarQubeMetrics(List<SummarySonarQubeMetric> sonarQubeMetrics) {
        return this.sonarQubeMetrics == sonarQubeMetrics ? this : new Summary(this.missingComponents, this.componentDependencies, this.subComponentDependencies, this.callGraphs, sonarQubeMetrics);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SummaryBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<SummaryMissingComponent> missingComponents;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SummaryComponentDependencies componentDependencies;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SummarySubComponentDependencies subComponentDependencies;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<SummaryCallGraph> callGraphs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<SummarySonarQubeMetric> sonarQubeMetrics;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SummaryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryBuilder missingComponents(List<SummaryMissingComponent> missingComponents) {
            this.missingComponents = missingComponents;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryBuilder componentDependencies(SummaryComponentDependencies componentDependencies) {
            this.componentDependencies = componentDependencies;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryBuilder subComponentDependencies(SummarySubComponentDependencies subComponentDependencies) {
            this.subComponentDependencies = subComponentDependencies;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryBuilder callGraphs(List<SummaryCallGraph> callGraphs) {
            this.callGraphs = callGraphs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryBuilder sonarQubeMetrics(List<SummarySonarQubeMetric> sonarQubeMetrics) {
            this.sonarQubeMetrics = sonarQubeMetrics;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Summary build() {
            return new Summary(this.missingComponents, this.componentDependencies, this.subComponentDependencies, this.callGraphs, this.sonarQubeMetrics);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Summary.SummaryBuilder(missingComponents=" + this.missingComponents + ", componentDependencies=" + this.componentDependencies + ", subComponentDependencies=" + this.subComponentDependencies + ", callGraphs=" + this.callGraphs + ", sonarQubeMetrics=" + this.sonarQubeMetrics + ")";
        }
    }
}

