/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.EnvironmentPluginState;
import tech.kronicle.sdk.models.ObjectWithIdAndMerge;
import tech.kronicle.sdk.utils.ListUtils;
import tech.kronicle.sdk.utils.ObjectWithIdListUtils;

@JsonDeserialize(builder=EnvironmentStateBuilder.class)
public final class EnvironmentState
implements ObjectWithIdAndMerge<EnvironmentState> {
    @NotEmpty
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotEmpty @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    private final List<@NotNull @Valid EnvironmentPluginState> plugins;

    public EnvironmentState(String id, List<EnvironmentPluginState> plugins) {
        this.id = id;
        this.plugins = ListUtils.createUnmodifiableList(plugins);
    }

    public EnvironmentState withUpdatedPlugin(String pluginId, UnaryOperator<EnvironmentPluginState> action) {
        ArrayList<EnvironmentPluginState> newPlugins = new ArrayList<EnvironmentPluginState>(this.plugins);
        OptionalInt pluginIndex = IntStream.range(0, newPlugins.size()).filter(it -> Objects.equals(((EnvironmentPluginState)newPlugins.get(it)).getId(), pluginId)).findFirst();
        EnvironmentPluginState plugin = pluginIndex.isPresent() ? (EnvironmentPluginState)newPlugins.get(pluginIndex.getAsInt()) : EnvironmentPluginState.builder().id(pluginId).build();
        plugin = (EnvironmentPluginState)action.apply(plugin);
        if (pluginIndex.isPresent()) {
            newPlugins.set(pluginIndex.getAsInt(), plugin);
        } else {
            newPlugins.add(plugin);
        }
        return this.withPlugins(newPlugins);
    }

    @Override
    public EnvironmentState merge(EnvironmentState state) {
        return this.withPlugins(ObjectWithIdListUtils.mergeObjectWithIdLists(this.plugins, state.plugins));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EnvironmentStateBuilder builder() {
        return new EnvironmentStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentStateBuilder toBuilder() {
        return new EnvironmentStateBuilder().id(this.id).plugins(this.plugins);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid EnvironmentPluginState> getPlugins() {
        return this.plugins;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentState)) {
            return false;
        }
        EnvironmentState other = (EnvironmentState)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<EnvironmentPluginState> this$plugins = this.getPlugins();
        List<EnvironmentPluginState> other$plugins = other.getPlugins();
        return !(this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<EnvironmentPluginState> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EnvironmentState(id=" + this.getId() + ", plugins=" + this.getPlugins() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentState withId(String id) {
        return this.id == id ? this : new EnvironmentState(id, this.plugins);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentState withPlugins(List<@NotNull @Valid EnvironmentPluginState> plugins) {
        return this.plugins == plugins ? this : new EnvironmentState(this.id, plugins);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class EnvironmentStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid EnvironmentPluginState> plugins;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EnvironmentStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentStateBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentStateBuilder plugins(List<@NotNull @Valid EnvironmentPluginState> plugins) {
            this.plugins = plugins;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentState build() {
            return new EnvironmentState(this.id, this.plugins);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EnvironmentState.EnvironmentStateBuilder(id=" + this.id + ", plugins=" + this.plugins + ")";
        }
    }
}

