/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithIdAndMerge;

public final class ObjectWithIdListUtils {
    public static <T extends ObjectWithIdAndMerge<T>> List<T> mergeObjectWithIdLists(List<T> listA, List<T> listB) {
        Map mapA = ObjectWithIdListUtils.createObjectWithIdMap(listA);
        Map mapB = ObjectWithIdListUtils.createObjectWithIdMap(listB);
        ArrayList newList = new ArrayList();
        ObjectWithIdListUtils.getIds(listA).forEach(id -> {
            ObjectWithIdAndMerge a = (ObjectWithIdAndMerge)mapA.get(id);
            ObjectWithIdAndMerge b = (ObjectWithIdAndMerge)mapB.get(id);
            if (Objects.nonNull(b)) {
                newList.add(a.merge(b));
            } else {
                newList.add(a);
            }
        });
        ObjectWithIdListUtils.getIds(listB).forEach(id -> {
            ObjectWithIdAndMerge a = (ObjectWithIdAndMerge)mapA.get(id);
            ObjectWithIdAndMerge b = (ObjectWithIdAndMerge)mapB.get(id);
            if (Objects.isNull(a)) {
                newList.add(b);
            }
        });
        return List.copyOf(newList);
    }

    private static <T extends ObjectWithId> Map<String, T> createObjectWithIdMap(List<T> list) {
        return list.stream().collect(Collectors.toUnmodifiableMap(ObjectWithId::getId, Function.identity()));
    }

    private static <T extends ObjectWithIdAndMerge<T>> List<String> getIds(List<T> list) {
        return list.stream().map(ObjectWithId::getId).collect(Collectors.toUnmodifiableList());
    }

    private ObjectWithIdListUtils() {
    }
}

