/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.LogMessageState;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=LogLevelStateBuilder.class)
public final class LogLevelState {
    @Pattern(regexp="[a-zA-Z][a-zA-Z0-9]*(_[a-zA-Z0-9]+)*|[a-zA-Z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*")
    private final @Pattern(regexp="[a-zA-Z][a-zA-Z0-9]*(_[a-zA-Z0-9]+)*|[a-zA-Z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*") String level;
    @NotNull
    @Min(value=0L)
    private final @NotNull @Min(value=0L) Long count;
    private final List<LogMessageState> topMessages;

    public LogLevelState(String level, Long count, List<LogMessageState> topMessages) {
        this.level = level;
        this.count = count;
        this.topMessages = ListUtils.createUnmodifiableList(topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LogLevelStateBuilder builder() {
        return new LogLevelStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelStateBuilder toBuilder() {
        return new LogLevelStateBuilder().level(this.level).count(this.count).topMessages(this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLevel() {
        return this.level;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getCount() {
        return this.count;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LogMessageState> getTopMessages() {
        return this.topMessages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogLevelState)) {
            return false;
        }
        LogLevelState other = (LogLevelState)o;
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        List<LogMessageState> this$topMessages = this.getTopMessages();
        List<LogMessageState> other$topMessages = other.getTopMessages();
        return !(this$topMessages == null ? other$topMessages != null : !((Object)this$topMessages).equals(other$topMessages));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        List<LogMessageState> $topMessages = this.getTopMessages();
        result = result * 59 + ($topMessages == null ? 43 : ((Object)$topMessages).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LogLevelState(level=" + this.getLevel() + ", count=" + this.getCount() + ", topMessages=" + this.getTopMessages() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelState withLevel(String level) {
        return this.level == level ? this : new LogLevelState(level, this.count, this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelState withCount(Long count) {
        return this.count == count ? this : new LogLevelState(this.level, count, this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelState withTopMessages(List<LogMessageState> topMessages) {
        return this.topMessages == topMessages ? this : new LogLevelState(this.level, this.count, topMessages);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LogLevelStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String level;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long count;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<LogMessageState> topMessages;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LogLevelStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelStateBuilder level(String level) {
            this.level = level;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelStateBuilder count(Long count) {
            this.count = count;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelStateBuilder topMessages(List<LogMessageState> topMessages) {
            this.topMessages = topMessages;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelState build() {
            return new LogLevelState(this.level, this.count, this.topMessages);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LogLevelState.LogLevelStateBuilder(level=" + this.level + ", count=" + this.count + ", topMessages=" + this.topMessages + ")";
        }
    }
}

