/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.CheckState;
import tech.kronicle.sdk.models.LogSummaryState;
import tech.kronicle.sdk.models.ObjectWithIdAndMerge;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=EnvironmentPluginStateBuilder.class)
public final class EnvironmentPluginState
implements ObjectWithIdAndMerge<EnvironmentPluginState> {
    @NotEmpty
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotEmpty @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    private final List<@NotNull @Valid CheckState> checks;
    private final List<@NotNull @Valid LogSummaryState> logSummaries;

    public EnvironmentPluginState(String id, List<CheckState> checks, List<LogSummaryState> logSummaries) {
        this.id = id;
        this.checks = ListUtils.createUnmodifiableList(checks);
        this.logSummaries = ListUtils.createUnmodifiableList(logSummaries);
    }

    @Override
    public EnvironmentPluginState merge(EnvironmentPluginState state) {
        return this.withChecks(ListUtils.unmodifiableUnionOfLists(List.of(this.checks, state.checks))).withLogSummaries(ListUtils.unmodifiableUnionOfLists(List.of(this.logSummaries, state.logSummaries)));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EnvironmentPluginStateBuilder builder() {
        return new EnvironmentPluginStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentPluginStateBuilder toBuilder() {
        return new EnvironmentPluginStateBuilder().id(this.id).checks(this.checks).logSummaries(this.logSummaries);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid CheckState> getChecks() {
        return this.checks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid LogSummaryState> getLogSummaries() {
        return this.logSummaries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentPluginState)) {
            return false;
        }
        EnvironmentPluginState other = (EnvironmentPluginState)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<CheckState> this$checks = this.getChecks();
        List<CheckState> other$checks = other.getChecks();
        if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
            return false;
        }
        List<LogSummaryState> this$logSummaries = this.getLogSummaries();
        List<LogSummaryState> other$logSummaries = other.getLogSummaries();
        return !(this$logSummaries == null ? other$logSummaries != null : !((Object)this$logSummaries).equals(other$logSummaries));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<CheckState> $checks = this.getChecks();
        result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
        List<LogSummaryState> $logSummaries = this.getLogSummaries();
        result = result * 59 + ($logSummaries == null ? 43 : ((Object)$logSummaries).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EnvironmentPluginState(id=" + this.getId() + ", checks=" + this.getChecks() + ", logSummaries=" + this.getLogSummaries() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentPluginState withId(String id) {
        return this.id == id ? this : new EnvironmentPluginState(id, this.checks, this.logSummaries);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentPluginState withChecks(List<@NotNull @Valid CheckState> checks) {
        return this.checks == checks ? this : new EnvironmentPluginState(this.id, checks, this.logSummaries);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnvironmentPluginState withLogSummaries(List<@NotNull @Valid LogSummaryState> logSummaries) {
        return this.logSummaries == logSummaries ? this : new EnvironmentPluginState(this.id, this.checks, logSummaries);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class EnvironmentPluginStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid CheckState> checks;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid LogSummaryState> logSummaries;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EnvironmentPluginStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentPluginStateBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentPluginStateBuilder checks(List<@NotNull @Valid CheckState> checks) {
            this.checks = checks;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentPluginStateBuilder logSummaries(List<@NotNull @Valid LogSummaryState> logSummaries) {
            this.logSummaries = logSummaries;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EnvironmentPluginState build() {
            return new EnvironmentPluginState(this.id, this.checks, this.logSummaries);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EnvironmentPluginState.EnvironmentPluginStateBuilder(id=" + this.id + ", checks=" + this.checks + ", logSummaries=" + this.logSummaries + ")";
        }
    }
}

