/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.git;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import tech.kronicle.sdk.models.git.Identity;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=GitRepoBuilder.class)
public final class GitRepo {
    private final LocalDateTime firstCommitTimestamp;
    private final LocalDateTime lastCommitTimestamp;
    private final Integer commitCount;
    private final List<Identity> authors;
    private final List<Identity> committers;
    private final Integer authorCount;
    private final Integer committerCount;

    public GitRepo(LocalDateTime firstCommitTimestamp, LocalDateTime lastCommitTimestamp, Integer commitCount, List<Identity> authors, List<Identity> committers, Integer authorCount, Integer committerCount) {
        this.firstCommitTimestamp = firstCommitTimestamp;
        this.lastCommitTimestamp = lastCommitTimestamp;
        this.commitCount = commitCount;
        this.authors = ListUtils.createUnmodifiableList(authors);
        this.committers = ListUtils.createUnmodifiableList(committers);
        this.authorCount = authorCount;
        this.committerCount = committerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GitRepoBuilder builder() {
        return new GitRepoBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepoBuilder toBuilder() {
        return new GitRepoBuilder().firstCommitTimestamp(this.firstCommitTimestamp).lastCommitTimestamp(this.lastCommitTimestamp).commitCount(this.commitCount).authors(this.authors).committers(this.committers).authorCount(this.authorCount).committerCount(this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getFirstCommitTimestamp() {
        return this.firstCommitTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getLastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCommitCount() {
        return this.commitCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Identity> getAuthors() {
        return this.authors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Identity> getCommitters() {
        return this.committers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getAuthorCount() {
        return this.authorCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCommitterCount() {
        return this.committerCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRepo)) {
            return false;
        }
        GitRepo other = (GitRepo)o;
        Integer this$commitCount = this.getCommitCount();
        Integer other$commitCount = other.getCommitCount();
        if (this$commitCount == null ? other$commitCount != null : !((Object)this$commitCount).equals(other$commitCount)) {
            return false;
        }
        Integer this$authorCount = this.getAuthorCount();
        Integer other$authorCount = other.getAuthorCount();
        if (this$authorCount == null ? other$authorCount != null : !((Object)this$authorCount).equals(other$authorCount)) {
            return false;
        }
        Integer this$committerCount = this.getCommitterCount();
        Integer other$committerCount = other.getCommitterCount();
        if (this$committerCount == null ? other$committerCount != null : !((Object)this$committerCount).equals(other$committerCount)) {
            return false;
        }
        LocalDateTime this$firstCommitTimestamp = this.getFirstCommitTimestamp();
        LocalDateTime other$firstCommitTimestamp = other.getFirstCommitTimestamp();
        if (this$firstCommitTimestamp == null ? other$firstCommitTimestamp != null : !((Object)this$firstCommitTimestamp).equals(other$firstCommitTimestamp)) {
            return false;
        }
        LocalDateTime this$lastCommitTimestamp = this.getLastCommitTimestamp();
        LocalDateTime other$lastCommitTimestamp = other.getLastCommitTimestamp();
        if (this$lastCommitTimestamp == null ? other$lastCommitTimestamp != null : !((Object)this$lastCommitTimestamp).equals(other$lastCommitTimestamp)) {
            return false;
        }
        List<Identity> this$authors = this.getAuthors();
        List<Identity> other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        List<Identity> this$committers = this.getCommitters();
        List<Identity> other$committers = other.getCommitters();
        return !(this$committers == null ? other$committers != null : !((Object)this$committers).equals(other$committers));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $commitCount = this.getCommitCount();
        result = result * 59 + ($commitCount == null ? 43 : ((Object)$commitCount).hashCode());
        Integer $authorCount = this.getAuthorCount();
        result = result * 59 + ($authorCount == null ? 43 : ((Object)$authorCount).hashCode());
        Integer $committerCount = this.getCommitterCount();
        result = result * 59 + ($committerCount == null ? 43 : ((Object)$committerCount).hashCode());
        LocalDateTime $firstCommitTimestamp = this.getFirstCommitTimestamp();
        result = result * 59 + ($firstCommitTimestamp == null ? 43 : ((Object)$firstCommitTimestamp).hashCode());
        LocalDateTime $lastCommitTimestamp = this.getLastCommitTimestamp();
        result = result * 59 + ($lastCommitTimestamp == null ? 43 : ((Object)$lastCommitTimestamp).hashCode());
        List<Identity> $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        List<Identity> $committers = this.getCommitters();
        result = result * 59 + ($committers == null ? 43 : ((Object)$committers).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GitRepo(firstCommitTimestamp=" + this.getFirstCommitTimestamp() + ", lastCommitTimestamp=" + this.getLastCommitTimestamp() + ", commitCount=" + this.getCommitCount() + ", authors=" + this.getAuthors() + ", committers=" + this.getCommitters() + ", authorCount=" + this.getAuthorCount() + ", committerCount=" + this.getCommitterCount() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withFirstCommitTimestamp(LocalDateTime firstCommitTimestamp) {
        return this.firstCommitTimestamp == firstCommitTimestamp ? this : new GitRepo(firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withLastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
        return this.lastCommitTimestamp == lastCommitTimestamp ? this : new GitRepo(this.firstCommitTimestamp, lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withCommitCount(Integer commitCount) {
        return this.commitCount == commitCount ? this : new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withAuthors(List<Identity> authors) {
        return this.authors == authors ? this : new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, authors, this.committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withCommitters(List<Identity> committers) {
        return this.committers == committers ? this : new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, committers, this.authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withAuthorCount(Integer authorCount) {
        return this.authorCount == authorCount ? this : new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, authorCount, this.committerCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo withCommitterCount(Integer committerCount) {
        return this.committerCount == committerCount ? this : new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, committerCount);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GitRepoBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime firstCommitTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime lastCommitTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer commitCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Identity> authors;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Identity> committers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer authorCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer committerCount;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GitRepoBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder firstCommitTimestamp(LocalDateTime firstCommitTimestamp) {
            this.firstCommitTimestamp = firstCommitTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder lastCommitTimestamp(LocalDateTime lastCommitTimestamp) {
            this.lastCommitTimestamp = lastCommitTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder commitCount(Integer commitCount) {
            this.commitCount = commitCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder authors(List<Identity> authors) {
            this.authors = authors;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder committers(List<Identity> committers) {
            this.committers = committers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder authorCount(Integer authorCount) {
            this.authorCount = authorCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepoBuilder committerCount(Integer committerCount) {
            this.committerCount = committerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GitRepo build() {
            return new GitRepo(this.firstCommitTimestamp, this.lastCommitTimestamp, this.commitCount, this.authors, this.committers, this.authorCount, this.committerCount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GitRepo.GitRepoBuilder(firstCommitTimestamp=" + this.firstCommitTimestamp + ", lastCommitTimestamp=" + this.lastCommitTimestamp + ", commitCount=" + this.commitCount + ", authors=" + this.authors + ", committers=" + this.committers + ", authorCount=" + this.authorCount + ", committerCount=" + this.committerCount + ")";
        }
    }
}

