/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.UniqueElements;
import tech.kronicle.sdk.models.Alias;
import tech.kronicle.sdk.models.ComponentDependency;
import tech.kronicle.sdk.models.ComponentTeam;
import tech.kronicle.sdk.models.CrossFunctionalRequirement;
import tech.kronicle.sdk.models.Import;
import tech.kronicle.sdk.models.KeySoftware;
import tech.kronicle.sdk.models.Link;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Repo;
import tech.kronicle.sdk.models.Responsibility;
import tech.kronicle.sdk.models.ScannerError;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.models.TechDebt;
import tech.kronicle.sdk.models.TestResult;
import tech.kronicle.sdk.models.git.GitRepo;
import tech.kronicle.sdk.models.gradle.Gradle;
import tech.kronicle.sdk.models.linesofcode.LinesOfCode;
import tech.kronicle.sdk.models.nodejs.NodeJs;
import tech.kronicle.sdk.models.openapi.OpenApiSpec;
import tech.kronicle.sdk.models.readme.Readme;
import tech.kronicle.sdk.models.sonarqube.SonarQubeProject;
import tech.kronicle.sdk.models.todos.ToDo;
import tech.kronicle.sdk.models.zipkin.Zipkin;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ComponentBuilder.class)
public final class Component
implements ObjectWithId,
ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    @UniqueElements
    private final List<Alias> aliases;
    @NotBlank
    private final String name;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    @JsonAlias(value={"type"})
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String typeId;
    private final List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags;
    @Valid
    @NotNull
    private final Repo repo;
    private final String description;
    private final List<@Valid Responsibility> responsibilities;
    private final String notes;
    private final List<@Valid Link> links;
    private final List<@Valid ComponentTeam> teams;
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    @JsonAlias(value={"platform"})
    private final @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String platformId;
    private final List<@Valid ComponentDependency> dependencies;
    private final List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements;
    private final List<@Valid TechDebt> techDebts;
    @Valid
    private final GitRepo gitRepo;
    @Valid
    private final Gradle gradle;
    @Valid
    private final NodeJs nodeJs;
    private final List<@Valid SoftwareRepository> softwareRepositories;
    private final List<@Valid Software> software;
    private final List<@Valid Import> imports;
    private final List<@Valid KeySoftware> keySoftware;
    @Valid
    private final LinesOfCode linesOfCode;
    @Valid
    private final List<ToDo> toDos;
    @Valid
    private final Readme readme;
    @Valid
    private final Zipkin zipkin;
    private final List<@Valid OpenApiSpec> openApiSpecs;
    private final List<@Valid SonarQubeProject> sonarQubeProjects;
    private final List<@Valid ScannerError> scannerErrors;
    private final List<@Valid TestResult> testResults;

    public Component(String id, List<Alias> aliases, String name, String typeId, List<String> tags, Repo repo, String description, List<Responsibility> responsibilities, String notes, List<Link> links, List<ComponentTeam> teams, String platformId, List<ComponentDependency> dependencies, List<CrossFunctionalRequirement> crossFunctionalRequirements, List<TechDebt> techDebts, GitRepo gitRepo, Gradle gradle, NodeJs nodeJs, List<SoftwareRepository> softwareRepositories, List<Software> software, List<Import> imports, List<KeySoftware> keySoftware, LinesOfCode linesOfCode, List<ToDo> toDos, Readme readme, Zipkin zipkin, List<OpenApiSpec> openApiSpecs, List<SonarQubeProject> sonarQubeProjects, List<ScannerError> scannerErrors, List<TestResult> testResults) {
        this.id = id;
        this.aliases = ListUtils.createUnmodifiableList(aliases);
        this.name = name;
        this.typeId = typeId;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.repo = repo;
        this.description = description;
        this.responsibilities = ListUtils.createUnmodifiableList(responsibilities);
        this.notes = notes;
        this.links = links;
        this.teams = ListUtils.createUnmodifiableList(teams);
        this.platformId = platformId;
        this.dependencies = ListUtils.createUnmodifiableList(dependencies);
        this.crossFunctionalRequirements = ListUtils.createUnmodifiableList(crossFunctionalRequirements);
        this.techDebts = ListUtils.createUnmodifiableList(techDebts);
        this.gitRepo = gitRepo;
        this.gradle = gradle;
        this.nodeJs = nodeJs;
        this.softwareRepositories = ListUtils.createUnmodifiableList(softwareRepositories);
        this.software = ListUtils.createUnmodifiableList(software);
        this.imports = ListUtils.createUnmodifiableList(imports);
        this.keySoftware = ListUtils.createUnmodifiableList(keySoftware);
        this.linesOfCode = linesOfCode;
        this.toDos = ListUtils.createUnmodifiableList(toDos);
        this.readme = readme;
        this.zipkin = zipkin;
        this.openApiSpecs = ListUtils.createUnmodifiableList(openApiSpecs);
        this.sonarQubeProjects = ListUtils.createUnmodifiableList(sonarQubeProjects);
        this.scannerErrors = ListUtils.createUnmodifiableList(scannerErrors);
        this.testResults = ListUtils.createUnmodifiableList(testResults);
    }

    @Override
    public String reference() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentBuilder builder() {
        return new ComponentBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentBuilder toBuilder() {
        return new ComponentBuilder().id(this.id).aliases(this.aliases).name(this.name).typeId(this.typeId).tags(this.tags).repo(this.repo).description(this.description).responsibilities(this.responsibilities).notes(this.notes).links(this.links).teams(this.teams).platformId(this.platformId).dependencies(this.dependencies).crossFunctionalRequirements(this.crossFunctionalRequirements).techDebts(this.techDebts).gitRepo(this.gitRepo).gradle(this.gradle).nodeJs(this.nodeJs).softwareRepositories(this.softwareRepositories).software(this.software).imports(this.imports).keySoftware(this.keySoftware).linesOfCode(this.linesOfCode).toDos(this.toDos).readme(this.readme).zipkin(this.zipkin).openApiSpecs(this.openApiSpecs).sonarQubeProjects(this.sonarQubeProjects).scannerErrors(this.scannerErrors).testResults(this.testResults);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Alias> getAliases() {
        return this.aliases;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTypeId() {
        return this.typeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Repo getRepo() {
        return this.repo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Responsibility> getResponsibilities() {
        return this.responsibilities;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Link> getLinks() {
        return this.links;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentTeam> getTeams() {
        return this.teams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPlatformId() {
        return this.platformId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentDependency> getDependencies() {
        return this.dependencies;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid CrossFunctionalRequirement> getCrossFunctionalRequirements() {
        return this.crossFunctionalRequirements;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid TechDebt> getTechDebts() {
        return this.techDebts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GitRepo getGitRepo() {
        return this.gitRepo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Gradle getGradle() {
        return this.gradle;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public NodeJs getNodeJs() {
        return this.nodeJs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid SoftwareRepository> getSoftwareRepositories() {
        return this.softwareRepositories;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Software> getSoftware() {
        return this.software;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Import> getImports() {
        return this.imports;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid KeySoftware> getKeySoftware() {
        return this.keySoftware;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LinesOfCode getLinesOfCode() {
        return this.linesOfCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ToDo> getToDos() {
        return this.toDos;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Readme getReadme() {
        return this.readme;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Zipkin getZipkin() {
        return this.zipkin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid OpenApiSpec> getOpenApiSpecs() {
        return this.openApiSpecs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid SonarQubeProject> getSonarQubeProjects() {
        return this.sonarQubeProjects;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ScannerError> getScannerErrors() {
        return this.scannerErrors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid TestResult> getTestResults() {
        return this.testResults;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component other = (Component)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Alias> this$aliases = this.getAliases();
        List<Alias> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$typeId = this.getTypeId();
        String other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !this$typeId.equals(other$typeId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Repo this$repo = this.getRepo();
        Repo other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Responsibility> this$responsibilities = this.getResponsibilities();
        List<Responsibility> other$responsibilities = other.getResponsibilities();
        if (this$responsibilities == null ? other$responsibilities != null : !((Object)this$responsibilities).equals(other$responsibilities)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<ComponentTeam> this$teams = this.getTeams();
        List<ComponentTeam> other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        String this$platformId = this.getPlatformId();
        String other$platformId = other.getPlatformId();
        if (this$platformId == null ? other$platformId != null : !this$platformId.equals(other$platformId)) {
            return false;
        }
        List<ComponentDependency> this$dependencies = this.getDependencies();
        List<ComponentDependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<CrossFunctionalRequirement> this$crossFunctionalRequirements = this.getCrossFunctionalRequirements();
        List<CrossFunctionalRequirement> other$crossFunctionalRequirements = other.getCrossFunctionalRequirements();
        if (this$crossFunctionalRequirements == null ? other$crossFunctionalRequirements != null : !((Object)this$crossFunctionalRequirements).equals(other$crossFunctionalRequirements)) {
            return false;
        }
        List<TechDebt> this$techDebts = this.getTechDebts();
        List<TechDebt> other$techDebts = other.getTechDebts();
        if (this$techDebts == null ? other$techDebts != null : !((Object)this$techDebts).equals(other$techDebts)) {
            return false;
        }
        GitRepo this$gitRepo = this.getGitRepo();
        GitRepo other$gitRepo = other.getGitRepo();
        if (this$gitRepo == null ? other$gitRepo != null : !((Object)this$gitRepo).equals(other$gitRepo)) {
            return false;
        }
        Gradle this$gradle = this.getGradle();
        Gradle other$gradle = other.getGradle();
        if (this$gradle == null ? other$gradle != null : !((Object)this$gradle).equals(other$gradle)) {
            return false;
        }
        NodeJs this$nodeJs = this.getNodeJs();
        NodeJs other$nodeJs = other.getNodeJs();
        if (this$nodeJs == null ? other$nodeJs != null : !((Object)this$nodeJs).equals(other$nodeJs)) {
            return false;
        }
        List<SoftwareRepository> this$softwareRepositories = this.getSoftwareRepositories();
        List<SoftwareRepository> other$softwareRepositories = other.getSoftwareRepositories();
        if (this$softwareRepositories == null ? other$softwareRepositories != null : !((Object)this$softwareRepositories).equals(other$softwareRepositories)) {
            return false;
        }
        List<Software> this$software = this.getSoftware();
        List<Software> other$software = other.getSoftware();
        if (this$software == null ? other$software != null : !((Object)this$software).equals(other$software)) {
            return false;
        }
        List<Import> this$imports = this.getImports();
        List<Import> other$imports = other.getImports();
        if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
            return false;
        }
        List<KeySoftware> this$keySoftware = this.getKeySoftware();
        List<KeySoftware> other$keySoftware = other.getKeySoftware();
        if (this$keySoftware == null ? other$keySoftware != null : !((Object)this$keySoftware).equals(other$keySoftware)) {
            return false;
        }
        LinesOfCode this$linesOfCode = this.getLinesOfCode();
        LinesOfCode other$linesOfCode = other.getLinesOfCode();
        if (this$linesOfCode == null ? other$linesOfCode != null : !((Object)this$linesOfCode).equals(other$linesOfCode)) {
            return false;
        }
        List<ToDo> this$toDos = this.getToDos();
        List<ToDo> other$toDos = other.getToDos();
        if (this$toDos == null ? other$toDos != null : !((Object)this$toDos).equals(other$toDos)) {
            return false;
        }
        Readme this$readme = this.getReadme();
        Readme other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !((Object)this$readme).equals(other$readme)) {
            return false;
        }
        Zipkin this$zipkin = this.getZipkin();
        Zipkin other$zipkin = other.getZipkin();
        if (this$zipkin == null ? other$zipkin != null : !((Object)this$zipkin).equals(other$zipkin)) {
            return false;
        }
        List<OpenApiSpec> this$openApiSpecs = this.getOpenApiSpecs();
        List<OpenApiSpec> other$openApiSpecs = other.getOpenApiSpecs();
        if (this$openApiSpecs == null ? other$openApiSpecs != null : !((Object)this$openApiSpecs).equals(other$openApiSpecs)) {
            return false;
        }
        List<SonarQubeProject> this$sonarQubeProjects = this.getSonarQubeProjects();
        List<SonarQubeProject> other$sonarQubeProjects = other.getSonarQubeProjects();
        if (this$sonarQubeProjects == null ? other$sonarQubeProjects != null : !((Object)this$sonarQubeProjects).equals(other$sonarQubeProjects)) {
            return false;
        }
        List<ScannerError> this$scannerErrors = this.getScannerErrors();
        List<ScannerError> other$scannerErrors = other.getScannerErrors();
        if (this$scannerErrors == null ? other$scannerErrors != null : !((Object)this$scannerErrors).equals(other$scannerErrors)) {
            return false;
        }
        List<TestResult> this$testResults = this.getTestResults();
        List<TestResult> other$testResults = other.getTestResults();
        return !(this$testResults == null ? other$testResults != null : !((Object)this$testResults).equals(other$testResults));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Alias> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 43 : $typeId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Repo $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Responsibility> $responsibilities = this.getResponsibilities();
        result = result * 59 + ($responsibilities == null ? 43 : ((Object)$responsibilities).hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<ComponentTeam> $teams = this.getTeams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        String $platformId = this.getPlatformId();
        result = result * 59 + ($platformId == null ? 43 : $platformId.hashCode());
        List<ComponentDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<CrossFunctionalRequirement> $crossFunctionalRequirements = this.getCrossFunctionalRequirements();
        result = result * 59 + ($crossFunctionalRequirements == null ? 43 : ((Object)$crossFunctionalRequirements).hashCode());
        List<TechDebt> $techDebts = this.getTechDebts();
        result = result * 59 + ($techDebts == null ? 43 : ((Object)$techDebts).hashCode());
        GitRepo $gitRepo = this.getGitRepo();
        result = result * 59 + ($gitRepo == null ? 43 : ((Object)$gitRepo).hashCode());
        Gradle $gradle = this.getGradle();
        result = result * 59 + ($gradle == null ? 43 : ((Object)$gradle).hashCode());
        NodeJs $nodeJs = this.getNodeJs();
        result = result * 59 + ($nodeJs == null ? 43 : ((Object)$nodeJs).hashCode());
        List<SoftwareRepository> $softwareRepositories = this.getSoftwareRepositories();
        result = result * 59 + ($softwareRepositories == null ? 43 : ((Object)$softwareRepositories).hashCode());
        List<Software> $software = this.getSoftware();
        result = result * 59 + ($software == null ? 43 : ((Object)$software).hashCode());
        List<Import> $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        List<KeySoftware> $keySoftware = this.getKeySoftware();
        result = result * 59 + ($keySoftware == null ? 43 : ((Object)$keySoftware).hashCode());
        LinesOfCode $linesOfCode = this.getLinesOfCode();
        result = result * 59 + ($linesOfCode == null ? 43 : ((Object)$linesOfCode).hashCode());
        List<ToDo> $toDos = this.getToDos();
        result = result * 59 + ($toDos == null ? 43 : ((Object)$toDos).hashCode());
        Readme $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : ((Object)$readme).hashCode());
        Zipkin $zipkin = this.getZipkin();
        result = result * 59 + ($zipkin == null ? 43 : ((Object)$zipkin).hashCode());
        List<OpenApiSpec> $openApiSpecs = this.getOpenApiSpecs();
        result = result * 59 + ($openApiSpecs == null ? 43 : ((Object)$openApiSpecs).hashCode());
        List<SonarQubeProject> $sonarQubeProjects = this.getSonarQubeProjects();
        result = result * 59 + ($sonarQubeProjects == null ? 43 : ((Object)$sonarQubeProjects).hashCode());
        List<ScannerError> $scannerErrors = this.getScannerErrors();
        result = result * 59 + ($scannerErrors == null ? 43 : ((Object)$scannerErrors).hashCode());
        List<TestResult> $testResults = this.getTestResults();
        result = result * 59 + ($testResults == null ? 43 : ((Object)$testResults).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Component(id=" + this.getId() + ", aliases=" + this.getAliases() + ", name=" + this.getName() + ", typeId=" + this.getTypeId() + ", tags=" + this.getTags() + ", repo=" + this.getRepo() + ", description=" + this.getDescription() + ", responsibilities=" + this.getResponsibilities() + ", notes=" + this.getNotes() + ", links=" + this.getLinks() + ", teams=" + this.getTeams() + ", platformId=" + this.getPlatformId() + ", dependencies=" + this.getDependencies() + ", crossFunctionalRequirements=" + this.getCrossFunctionalRequirements() + ", techDebts=" + this.getTechDebts() + ", gitRepo=" + this.getGitRepo() + ", gradle=" + this.getGradle() + ", nodeJs=" + this.getNodeJs() + ", softwareRepositories=" + this.getSoftwareRepositories() + ", software=" + this.getSoftware() + ", imports=" + this.getImports() + ", keySoftware=" + this.getKeySoftware() + ", linesOfCode=" + this.getLinesOfCode() + ", toDos=" + this.getToDos() + ", readme=" + this.getReadme() + ", zipkin=" + this.getZipkin() + ", openApiSpecs=" + this.getOpenApiSpecs() + ", sonarQubeProjects=" + this.getSonarQubeProjects() + ", scannerErrors=" + this.getScannerErrors() + ", testResults=" + this.getTestResults() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withId(String id) {
        return this.id == id ? this : new Component(id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withAliases(List<Alias> aliases) {
        return this.aliases == aliases ? this : new Component(this.id, aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withName(String name) {
        return this.name == name ? this : new Component(this.id, this.aliases, name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTypeId(String typeId) {
        return this.typeId == typeId ? this : new Component(this.id, this.aliases, this.name, typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags) {
        return this.tags == tags ? this : new Component(this.id, this.aliases, this.name, this.typeId, tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withRepo(Repo repo) {
        return this.repo == repo ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDescription(String description) {
        return this.description == description ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withResponsibilities(List<@Valid Responsibility> responsibilities) {
        return this.responsibilities == responsibilities ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withNotes(String notes) {
        return this.notes == notes ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withLinks(List<@Valid Link> links) {
        return this.links == links ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTeams(List<@Valid ComponentTeam> teams) {
        return this.teams == teams ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withPlatformId(String platformId) {
        return this.platformId == platformId ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withDependencies(List<@Valid ComponentDependency> dependencies) {
        return this.dependencies == dependencies ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withCrossFunctionalRequirements(List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements) {
        return this.crossFunctionalRequirements == crossFunctionalRequirements ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTechDebts(List<@Valid TechDebt> techDebts) {
        return this.techDebts == techDebts ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withGitRepo(GitRepo gitRepo) {
        return this.gitRepo == gitRepo ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withGradle(Gradle gradle) {
        return this.gradle == gradle ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withNodeJs(NodeJs nodeJs) {
        return this.nodeJs == nodeJs ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withSoftwareRepositories(List<@Valid SoftwareRepository> softwareRepositories) {
        return this.softwareRepositories == softwareRepositories ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withSoftware(List<@Valid Software> software) {
        return this.software == software ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withImports(List<@Valid Import> imports) {
        return this.imports == imports ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withKeySoftware(List<@Valid KeySoftware> keySoftware) {
        return this.keySoftware == keySoftware ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withLinesOfCode(LinesOfCode linesOfCode) {
        return this.linesOfCode == linesOfCode ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withToDos(List<ToDo> toDos) {
        return this.toDos == toDos ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withReadme(Readme readme) {
        return this.readme == readme ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withZipkin(Zipkin zipkin) {
        return this.zipkin == zipkin ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withOpenApiSpecs(List<@Valid OpenApiSpec> openApiSpecs) {
        return this.openApiSpecs == openApiSpecs ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withSonarQubeProjects(List<@Valid SonarQubeProject> sonarQubeProjects) {
        return this.sonarQubeProjects == sonarQubeProjects ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, sonarQubeProjects, this.scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withScannerErrors(List<@Valid ScannerError> scannerErrors) {
        return this.scannerErrors == scannerErrors ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, scannerErrors, this.testResults);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Component withTestResults(List<@Valid TestResult> testResults) {
        return this.testResults == testResults ? this : new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, testResults);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Alias> aliases;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String typeId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Repo repo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Responsibility> responsibilities;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Link> links;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentTeam> teams;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String platformId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentDependency> dependencies;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid TechDebt> techDebts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private GitRepo gitRepo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Gradle gradle;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private NodeJs nodeJs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid SoftwareRepository> softwareRepositories;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Software> software;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Import> imports;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid KeySoftware> keySoftware;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LinesOfCode linesOfCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<ToDo> toDos;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Readme readme;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Zipkin zipkin;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid OpenApiSpec> openApiSpecs;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid SonarQubeProject> sonarQubeProjects;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ScannerError> scannerErrors;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid TestResult> testResults;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder aliases(List<Alias> aliases) {
            this.aliases = aliases;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonAlias(value={"type"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder tags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder repo(Repo repo) {
            this.repo = repo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder responsibilities(List<@Valid Responsibility> responsibilities) {
            this.responsibilities = responsibilities;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder links(List<@Valid Link> links) {
            this.links = links;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder teams(List<@Valid ComponentTeam> teams) {
            this.teams = teams;
            return this;
        }

        @JsonAlias(value={"platform"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder dependencies(List<@Valid ComponentDependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder crossFunctionalRequirements(List<@Valid CrossFunctionalRequirement> crossFunctionalRequirements) {
            this.crossFunctionalRequirements = crossFunctionalRequirements;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder techDebts(List<@Valid TechDebt> techDebts) {
            this.techDebts = techDebts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder gitRepo(GitRepo gitRepo) {
            this.gitRepo = gitRepo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder gradle(Gradle gradle) {
            this.gradle = gradle;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder nodeJs(NodeJs nodeJs) {
            this.nodeJs = nodeJs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder softwareRepositories(List<@Valid SoftwareRepository> softwareRepositories) {
            this.softwareRepositories = softwareRepositories;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder software(List<@Valid Software> software) {
            this.software = software;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder imports(List<@Valid Import> imports) {
            this.imports = imports;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder keySoftware(List<@Valid KeySoftware> keySoftware) {
            this.keySoftware = keySoftware;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder linesOfCode(LinesOfCode linesOfCode) {
            this.linesOfCode = linesOfCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder toDos(List<ToDo> toDos) {
            this.toDos = toDos;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder readme(Readme readme) {
            this.readme = readme;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder zipkin(Zipkin zipkin) {
            this.zipkin = zipkin;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder openApiSpecs(List<@Valid OpenApiSpec> openApiSpecs) {
            this.openApiSpecs = openApiSpecs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder sonarQubeProjects(List<@Valid SonarQubeProject> sonarQubeProjects) {
            this.sonarQubeProjects = sonarQubeProjects;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder scannerErrors(List<@Valid ScannerError> scannerErrors) {
            this.scannerErrors = scannerErrors;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentBuilder testResults(List<@Valid TestResult> testResults) {
            this.testResults = testResults;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Component build() {
            return new Component(this.id, this.aliases, this.name, this.typeId, this.tags, this.repo, this.description, this.responsibilities, this.notes, this.links, this.teams, this.platformId, this.dependencies, this.crossFunctionalRequirements, this.techDebts, this.gitRepo, this.gradle, this.nodeJs, this.softwareRepositories, this.software, this.imports, this.keySoftware, this.linesOfCode, this.toDos, this.readme, this.zipkin, this.openApiSpecs, this.sonarQubeProjects, this.scannerErrors, this.testResults);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Component.ComponentBuilder(id=" + this.id + ", aliases=" + this.aliases + ", name=" + this.name + ", typeId=" + this.typeId + ", tags=" + this.tags + ", repo=" + this.repo + ", description=" + this.description + ", responsibilities=" + this.responsibilities + ", notes=" + this.notes + ", links=" + this.links + ", teams=" + this.teams + ", platformId=" + this.platformId + ", dependencies=" + this.dependencies + ", crossFunctionalRequirements=" + this.crossFunctionalRequirements + ", techDebts=" + this.techDebts + ", gitRepo=" + this.gitRepo + ", gradle=" + this.gradle + ", nodeJs=" + this.nodeJs + ", softwareRepositories=" + this.softwareRepositories + ", software=" + this.software + ", imports=" + this.imports + ", keySoftware=" + this.keySoftware + ", linesOfCode=" + this.linesOfCode + ", toDos=" + this.toDos + ", readme=" + this.readme + ", zipkin=" + this.zipkin + ", openApiSpecs=" + this.openApiSpecs + ", sonarQubeProjects=" + this.sonarQubeProjects + ", scannerErrors=" + this.scannerErrors + ", testResults=" + this.testResults + ")";
        }
    }
}

