/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.services;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.kronicle.gradlestaticanalyzer.config.GradleCustomRepository;
import tech.kronicle.gradlestaticanalyzer.config.GradleStaticAnalyzerConfig;

public class CustomRepositoryRegistry {
    private final Map<String, String> customRepositoryUrls;

    public CustomRepositoryRegistry(GradleStaticAnalyzerConfig config) {
        this.customRepositoryUrls = Optional.ofNullable(config.getCustomRepositories()).map(items -> items.stream().collect(Collectors.toMap(GradleCustomRepository::getName, GradleCustomRepository::getUrl))).orElse(Map.of());
    }

    public String getCustomRepositoryUrl(String name) {
        return this.customRepositoryUrls.get(name);
    }
}

