/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor;

import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.BaseVisitorDependencies;
import tech.kronicle.gradlestaticanalyzer.internal.services.PropertyExpander;

public class ExtVisitor
extends BaseVisitor {
    private static final Logger log = LoggerFactory.getLogger(ExtVisitor.class);
    private final PropertyExpander propertyExpander;

    public ExtVisitor(BaseVisitorDependencies dependencies, PropertyExpander propertyExpander) {
        super(dependencies);
        this.propertyExpander = propertyExpander;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("set")) {
            ArgumentListExpression arguments;
            log.debug("Found ext.set");
            if (call.getArguments() instanceof ArgumentListExpression && (arguments = (ArgumentListExpression)call.getArguments()).getExpressions().size() == 2) {
                this.visitorState().getProperties().put(arguments.getExpression(0).getText(), arguments.getExpression(1).getText());
            }
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }

    @Override
    protected ExpressionVisitOutcome processBinaryExpression(BinaryExpression expression) {
        String rightExpressionText = expression.getRightExpression().getText();
        if (!rightExpressionText.isEmpty()) {
            rightExpressionText = this.propertyExpander.expandProperties(rightExpressionText, "expression", this.visitorState().getProperties(), false);
        }
        this.visitorState().getProperties().put(expression.getLeftExpression().getText(), rightExpressionText);
        return ExpressionVisitOutcome.PROCESSED;
    }
}

