/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.mincer.Mincer;
import ru.justagod.model.ClassModel;
import ru.justagod.model.ClassParent;
import ru.justagod.model.ClassTypeReference;
import ru.justagod.plugin.processing.model.InvokeClass;
import ru.justagod.plugin.processing.model.ProjectModel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lru/justagod/plugin/util/CutterUtils;", "", "()V", "findInvokeClass", "Lru/justagod/plugin/processing/model/InvokeClass;", "ref", "Lru/justagod/model/ClassTypeReference;", "mincer", "Lru/justagod/mincer/Mincer;", "model", "Lru/justagod/plugin/processing/model/ProjectModel;", "cutter"})
public final class CutterUtils {
    public static final CutterUtils INSTANCE;

    @Nullable
    public final InvokeClass findInvokeClass(@NotNull ClassTypeReference ref, @NotNull Mincer mincer, @NotNull ProjectModel model2) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)mincer, (String)"mincer");
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        InvokeClass result = null;
        for (InvokeClass invokeClass : model2.getInvokeClasses()) {
            if (!mincer.getInheritance().isChild(ref, invokeClass.getName(), true)) continue;
            if (result != null) {
                String string = ref + " inherits more than one invoke class";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            result = invokeClass;
        }
        if (result != null && Intrinsics.areEqual((Object)ref, (Object)result.getName()) ^ true) {
            boolean bl;
            ClassModel refModel;
            block9: {
                refModel = mincer.getFactory().makeModel(ref, null);
                Iterable $receiver$iv = refModel.getInterfaces();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ClassParent it = (ClassParent)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getRawType(), (Object)result.getName())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                ClassParent classParent = refModel.getSuperClass();
                if (classParent == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)classParent.getRawType(), (Object)result.getName()) ^ true) {
                    String string = ref + " implements " + result.getName() + " but not like direct child. It's not allowed behavior.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        return result;
    }

    private CutterUtils() {
    }

    static {
        CutterUtils cutterUtils;
        INSTANCE = cutterUtils = new CutterUtils();
    }
}

