/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.processing.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.pipeline.Pipeline;
import ru.justagod.mincer.processor.ClassInfo;
import ru.justagod.mincer.processor.SubMincer;
import ru.justagod.mincer.processor.WorkerContext;
import ru.justagod.model.ClassTypeReference;
import ru.justagod.model.InheritanceHelper;
import ru.justagod.plugin.data.SideName;
import ru.justagod.plugin.processing.model.InvokeClass;
import ru.justagod.plugin.processing.model.MethodDesc;
import ru.justagod.plugin.processing.model.ProjectModel;
import ru.justagod.plugin.processing.model.SidesTree;
import ru.justagod.plugin.processing.pipeline.FourthAnalyzerMincer;
import ru.justagod.plugin.util.CutterUtils;
import ru.justagod.plugin.util.MiscellaneousKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J6\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lru/justagod/plugin/processing/pipeline/FourthAnalyzerMincer;", "Lru/justagod/mincer/processor/SubMincer;", "Lru/justagod/plugin/processing/model/ProjectModel;", "primalSides", "", "Lru/justagod/plugin/data/SideName;", "(Ljava/util/Set;)V", "analyzeInvokeDynamic", "", "instruction", "Lorg/objectweb/asm/tree/InvokeDynamicInsnNode;", "context", "Lru/justagod/mincer/processor/WorkerContext;", "method", "Lorg/objectweb/asm/tree/MethodNode;", "analyzeTypeInsn", "Lorg/objectweb/asm/tree/TypeInsnNode;", "endProcessing", "input", "cache", "Lru/justagod/mincer/control/MincerArchive;", "inheritance", "Lru/justagod/model/InheritanceHelper;", "pipeline", "Lru/justagod/mincer/pipeline/Pipeline;", "process", "Lru/justagod/mincer/control/MincerResultType;", "cutter"})
public final class FourthAnalyzerMincer
implements SubMincer<ProjectModel, ProjectModel> {
    private final Set<SideName> primalSides;

    @Override
    @NotNull
    public MincerResultType process(@NotNull WorkerContext<ProjectModel, ProjectModel> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        ClassInfo classInfo = context.getInfo();
        if (classInfo == null) {
            Intrinsics.throwNpe();
        }
        ClassNode node = classInfo.getNode();
        List list = node.methods;
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                MethodNode it = (MethodNode)element$iv;
                for (AbstractInsnNode instruction : it.instructions) {
                    if (instruction instanceof InvokeDynamicInsnNode) {
                        InvokeDynamicInsnNode invokeDynamicInsnNode = (InvokeDynamicInsnNode)instruction;
                        MethodNode methodNode = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"it");
                        this.analyzeInvokeDynamic(invokeDynamicInsnNode, context, methodNode);
                        continue;
                    }
                    if (!(instruction instanceof TypeInsnNode)) continue;
                    TypeInsnNode typeInsnNode = (TypeInsnNode)instruction;
                    MethodNode methodNode = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"it");
                    this.analyzeTypeInsn(typeInsnNode, context, methodNode);
                }
            }
        }
        return MincerResultType.SKIPPED;
    }

    private final void analyzeTypeInsn(TypeInsnNode instruction, WorkerContext<ProjectModel, ProjectModel> context, MethodNode method) {
        Type type = Type.getObjectType((String)instruction.desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getObjectType(instruction.desc)");
        String string = type.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getObjectType(instruction.desc).internalName");
        ClassTypeReference type2 = new ClassTypeReference(StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null));
        try {
            context.getMincer().getNodes().makeNode(type2);
        }
        catch (Exception e) {
            return;
        }
        if (StringsKt.startsWith$default((String)type2.getName(), (String)context.getName().getName(), (boolean)false, (int)2, null)) {
            boolean bl;
            block7: {
                Iterable $receiver$iv = CollectionsKt.drop((Iterable)type2.getPath(), (int)context.getName().getPath().size());
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!(StringsKt.toIntOrNull((String)it) != null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getInput().getSidesTree().set(type2.getPath(), context.getInput().getSidesTree().get(CollectionsKt.plus((Collection)context.getName().getPath(), (Object)(method.name + method.desc)), this.primalSides));
            }
        }
    }

    private final void analyzeInvokeDynamic(InvokeDynamicInsnNode instruction, WorkerContext<ProjectModel, ProjectModel> context, MethodNode method) {
        Handle handle = instruction.bsm;
        Intrinsics.checkExpressionValueIsNotNull((Object)handle, (String)"instruction.bsm");
        if (Intrinsics.areEqual((Object)handle.getOwner(), (Object)"java/lang/invoke/LambdaMetafactory")) {
            Handle handle2 = instruction.bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle2, (String)"instruction.bsm");
            if (Intrinsics.areEqual((Object)handle2.getName(), (Object)"metafactory") ^ true) {
                Handle handle3 = instruction.bsm;
                Intrinsics.checkExpressionValueIsNotNull((Object)handle3, (String)"instruction.bsm");
                if (Intrinsics.areEqual((Object)handle3.getName(), (Object)"altMetafactory")) {
                    String string = "WTF";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            Handle handle4 = instruction.bsm;
            Intrinsics.checkExpressionValueIsNotNull((Object)handle4, (String)"instruction.bsm");
            if (Intrinsics.areEqual((Object)handle4.getName(), (Object)"altMetafactory")) {
                boolean serializable;
                Object object = instruction.bsmArgs[3];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                boolean bl = serializable = ((Integer)object & 1) != 0;
                if (serializable) {
                    String string = "\u041e\u0421\u0423\u0416\u0414\u0410\u042e";
                    System.out.println((Object)string);
                }
            }
            Type type = Type.getReturnType((String)instruction.desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getReturnType(instruction.desc)");
            ClassTypeReference targetInterface = ClassTypeReference.Companion.fromDesc(type);
            InvokeClass invokeClass = CutterUtils.INSTANCE.findInvokeClass(targetInterface, context.getMincer(), context.getInput());
            Object object = instruction.bsmArgs[1];
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.Handle");
            }
            Handle implMethod = (Handle)object;
            if (Intrinsics.areEqual((Object)implMethod.getOwner(), (Object)StringsKt.replace$default((String)context.getName().getName(), (char)'.', (char)'/', (boolean)false, (int)4, null))) {
                Object v10;
                Set set;
                block13: {
                    ClassInfo classInfo = context.getInfo();
                    if (classInfo == null) {
                        Intrinsics.throwNpe();
                    }
                    List list = classInfo.getNode().methods;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"context.info!!.node.methods");
                    Set set2 = set = (Set)((Object)list);
                    for (Object t : set2) {
                        MethodNode it = (MethodNode)t;
                        if (!(Intrinsics.areEqual((Object)it.name, (Object)implMethod.getName()) && Intrinsics.areEqual((Object)it.desc, (Object)implMethod.getDesc()))) continue;
                        v10 = t;
                        break block13;
                    }
                    v10 = null;
                }
                if (v10 == null) {
                    Intrinsics.throwNpe();
                }
                MethodNode lambdaMethod = v10;
                if ((lambdaMethod.access & 0x1000) != 0 || invokeClass != null) {
                    if (invokeClass != null) {
                        String string = implMethod.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"implMethod.name");
                        String string2 = implMethod.getDesc();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"implMethod.desc");
                        context.getInput().getLambdaMethods().computeIfAbsent(context.getName(), analyzeInvokeDynamic.1.INSTANCE).add(new MethodDesc(string, string2));
                    }
                    set = context.getInput().getSidesTree().get(CollectionsKt.plus((Collection)context.getName().getPath(), (Object)(method.name + method.desc)), this.primalSides);
                    List list = CollectionsKt.plus((Collection)context.getName().getPath(), (Object)(implMethod.getName() + implMethod.getDesc()));
                    SidesTree sidesTree = context.getInput().getSidesTree();
                    Set it = set;
                    Set set3 = invokeClass != null ? CollectionsKt.toSet((Iterable)MiscellaneousKt.intersection(it, (Collection)invokeClass.getSides())) : it;
                    sidesTree.set(list, set3);
                }
            }
        }
    }

    @Override
    public void endProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        input.getSidesTree().identify(null);
        pipeline.setValue(input);
        if (Intrinsics.areEqual((Object)System.getProperty("print-sides"), (Object)"true")) {
            ProjectModel projectModel = pipeline.getValue();
            if (projectModel == null) {
                Intrinsics.throwNpe();
            }
            String string = SidesTree.toString$default(projectModel.getSidesTree(), CollectionsKt.toSet((Iterable)this.primalSides), null, 2, null);
            System.out.println((Object)string);
        }
    }

    public FourthAnalyzerMincer(@NotNull Set<SideName> primalSides) {
        Intrinsics.checkParameterIsNotNull(primalSides, (String)"primalSides");
        this.primalSides = primalSides;
    }

    @Override
    public void startProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        SubMincer.DefaultImpls.startProcessing(this, input, cache, inheritance, pipeline);
    }
}

