/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.processing.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.pipeline.Pipeline;
import ru.justagod.mincer.processor.ClassInfo;
import ru.justagod.mincer.processor.SubMincer;
import ru.justagod.mincer.processor.WorkerContext;
import ru.justagod.model.InheritanceHelper;
import ru.justagod.plugin.data.SideName;
import ru.justagod.plugin.processing.model.ProjectModel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ;\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u0002J.\u0010\u0017\u001a\u00020\u00022\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/justagod/plugin/processing/pipeline/FirstAnalyzerMincer;", "Lru/justagod/mincer/processor/SubMincer;", "", "Lru/justagod/plugin/processing/model/ProjectModel;", "annotationName", "", "primalSides", "", "Lru/justagod/plugin/data/SideName;", "(Ljava/lang/String;Ljava/util/List;)V", "annotationDescriptor", "endProcessing", "input", "cache", "Lru/justagod/mincer/control/MincerArchive;", "inheritance", "Lru/justagod/model/InheritanceHelper;", "pipeline", "Lru/justagod/mincer/pipeline/Pipeline;", "(Lkotlin/Unit;Lru/justagod/mincer/control/MincerArchive;Lru/justagod/model/InheritanceHelper;Lru/justagod/mincer/pipeline/Pipeline;)V", "extractSides", "entries", "", "inscribeSides", "annotations", "Lorg/objectweb/asm/tree/AnnotationNode;", "name", "model", "process", "Lru/justagod/mincer/control/MincerResultType;", "context", "Lru/justagod/mincer/processor/WorkerContext;", "cutter"})
public final class FirstAnalyzerMincer
implements SubMincer<Unit, ProjectModel> {
    private final String annotationDescriptor;
    private final List<SideName> primalSides;

    @Override
    @NotNull
    public MincerResultType process(@NotNull WorkerContext<Unit, ProjectModel> context) {
        List name;
        MethodNode it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        ClassInfo classInfo = context.getInfo();
        if (classInfo == null) {
            Intrinsics.throwNpe();
        }
        ClassNode node = classInfo.getNode();
        ProjectModel projectModel = context.getPipeline().getValue();
        if (projectModel == null) {
            Intrinsics.throwNpe();
        }
        ProjectModel project = projectModel;
        List path2 = Intrinsics.areEqual((Object)context.getName().getSimpleName(), (Object)"package-info") ^ true ? context.getName().getPath() : CollectionsKt.dropLast(context.getName().getPath(), (int)1);
        this.inscribeSides(node.invisibleAnnotations, path2, project);
        this.inscribeSides(node.visibleAnnotations, path2, project);
        List list = node.methods;
        if (list != null) {
            $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                it = (MethodNode)element$iv;
                name = CollectionsKt.plus((Collection)path2, (Object)(it.name + it.desc));
                this.inscribeSides(it.invisibleAnnotations, name, project);
                this.inscribeSides(it.visibleAnnotations, name, project);
            }
        }
        List list2 = node.fields;
        if (list2 != null) {
            $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                it = (FieldNode)element$iv;
                name = CollectionsKt.plus((Collection)path2, (Object)(it.name + it.desc));
                this.inscribeSides(it.invisibleAnnotations, name, project);
                this.inscribeSides(it.visibleAnnotations, name, project);
            }
        }
        return MincerResultType.SKIPPED;
    }

    private final void inscribeSides(List<? extends AnnotationNode> annotations, List<String> name, ProjectModel model2) {
        if (annotations == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotations) {
            if (Intrinsics.areEqual((Object)annotationNode.desc, (Object)this.annotationDescriptor) ^ true) continue;
            List list = annotationNode.values;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"node.values");
            Collection<SideName> collection = this.extractSides(list);
            if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                continue;
            }
            Collection<SideName> sides = collection;
            model2.getSidesTree().set(name, (Set<SideName>)sides);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SideName> extractSides(List<? extends Object> entries) {
        Iterator<? extends Object> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String name = (String)object;
            Object value = iterator.next();
            if (!Intrinsics.areEqual((Object)name, (Object)"value")) continue;
            if (value instanceof Object[]) {
                Object object2 = ((Object[])value)[1];
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                return CollectionsKt.listOf((Object)SideName.Companion.make$cutter((String)object2));
            }
            if (value instanceof List) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                if (!(((List)value).get(0) instanceof Object[])) {
                    return null;
                }
                Iterable iterable = $receiver$iv = (Iterable)value;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    void v2 = it;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    }
                    SideName sideName = SideName.Companion.make$cutter(((String[])v2)[1]);
                    collection.add(sideName);
                }
                return (List)destination$iv$iv;
            }
            return null;
        }
        return null;
    }

    @Override
    public void endProcessing(@NotNull Unit input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super Unit, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        ProjectModel projectModel = pipeline.getValue();
        if (projectModel == null) {
            Intrinsics.throwNpe();
        }
        projectModel.getSidesTree().identify(null);
    }

    public FirstAnalyzerMincer(@NotNull String annotationName, @NotNull List<SideName> primalSides) {
        Intrinsics.checkParameterIsNotNull((Object)annotationName, (String)"annotationName");
        Intrinsics.checkParameterIsNotNull(primalSides, (String)"primalSides");
        this.primalSides = primalSides;
        char c = 'L';
        String string = StringsKt.replace$default((String)annotationName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        FirstAnalyzerMincer firstAnalyzerMincer = this;
        String string2 = String.valueOf(c) + string;
        firstAnalyzerMincer.annotationDescriptor = stringBuilder.append(string2).append(';').toString();
    }

    @Override
    public void startProcessing(@NotNull Unit input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super Unit, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        SubMincer.DefaultImpls.startProcessing(this, input, cache, inheritance, pipeline);
    }
}

