/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.plugin.processing.pipeline;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.pipeline.Pipeline;
import ru.justagod.mincer.processor.ClassInfo;
import ru.justagod.mincer.processor.SubMincer;
import ru.justagod.mincer.processor.WorkerContext;
import ru.justagod.model.InheritanceHelper;
import ru.justagod.plugin.processing.model.ProjectModel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/justagod/plugin/processing/pipeline/AnnotationsRemoverMincer;", "Lru/justagod/mincer/processor/SubMincer;", "Lru/justagod/plugin/processing/model/ProjectModel;", "annotationName", "", "(Ljava/lang/String;)V", "annotationDescriptor", "considerAndProcess", "", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "endProcessing", "", "input", "cache", "Lru/justagod/mincer/control/MincerArchive;", "inheritance", "Lru/justagod/model/InheritanceHelper;", "pipeline", "Lru/justagod/mincer/pipeline/Pipeline;", "process", "Lru/justagod/mincer/control/MincerResultType;", "context", "Lru/justagod/mincer/processor/WorkerContext;", "cutter"})
public final class AnnotationsRemoverMincer
implements SubMincer<ProjectModel, ProjectModel> {
    private final String annotationDescriptor;

    @Override
    @NotNull
    public MincerResultType process(@NotNull WorkerContext<ProjectModel, ProjectModel> context) {
        FieldNode it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        ClassInfo classInfo = context.getInfo();
        if (classInfo == null) {
            Intrinsics.throwNpe();
        }
        ClassNode node = classInfo.getNode();
        boolean modified = false;
        modified |= this.considerAndProcess(node.invisibleAnnotations);
        modified |= this.considerAndProcess(node.visibleAnnotations);
        List list = node.fields;
        if (list != null) {
            $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                it = (FieldNode)element$iv;
                modified |= this.considerAndProcess(it.invisibleAnnotations);
                modified |= this.considerAndProcess(it.visibleAnnotations);
            }
        }
        List list2 = node.methods;
        if (list2 != null) {
            $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                it = (MethodNode)element$iv;
                modified |= this.considerAndProcess(it.invisibleAnnotations);
                modified |= this.considerAndProcess(it.visibleAnnotations);
            }
        }
        return modified ? MincerResultType.MODIFIED : MincerResultType.SKIPPED;
    }

    private final boolean considerAndProcess(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return false;
        }
        boolean result = false;
        Iterator<AnnotationNode> iter = annotations.iterator();
        while (iter.hasNext()) {
            AnnotationNode v = iter.next();
            if (!Intrinsics.areEqual((Object)v.desc, (Object)this.annotationDescriptor)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public void endProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        pipeline.setValue(input);
    }

    public AnnotationsRemoverMincer(@NotNull String annotationName) {
        Intrinsics.checkParameterIsNotNull((Object)annotationName, (String)"annotationName");
        char c = 'L';
        String string = StringsKt.replace$default((String)annotationName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        AnnotationsRemoverMincer annotationsRemoverMincer = this;
        String string2 = String.valueOf(c) + string;
        annotationsRemoverMincer.annotationDescriptor = stringBuilder.append(string2).append(';').toString();
    }

    @Override
    public void startProcessing(@NotNull ProjectModel input, @Nullable MincerArchive cache, @NotNull InheritanceHelper inheritance, @NotNull Pipeline<? super ProjectModel, ProjectModel> pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        SubMincer.DefaultImpls.startProcessing(this, input, cache, inheritance, pipeline);
    }
}

