/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.mincer.util.recursiveness;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerFS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/justagod/mincer/util/recursiveness/MincerTreeFS;", "Lru/justagod/mincer/control/MincerFS;", "root", "Ljava/io/File;", "leafs", "", "(Ljava/io/File;Ljava/util/List;)V", "pullArchive", "Lru/justagod/mincer/control/MincerArchive;", "id", "", "pullClass", "", "path", "pushArchive", "", "processedClasses", "", "pushGeneratedClass", "bytecode", "cutter"})
public final class MincerTreeFS
implements MincerFS {
    private final File root;
    private final List<MincerFS> leafs;

    @Override
    public void pushGeneratedClass(@NotNull String path2, @NotNull byte[] bytecode) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
        FilesKt.writeBytes((File)FilesKt.resolve((File)this.root, (String)path2), (byte[])bytecode);
    }

    @Override
    public void pushArchive(@NotNull String id, @NotNull Set<String> processedClasses) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(processedClasses, (String)"processedClasses");
    }

    @Override
    @Nullable
    public MincerArchive pullArchive(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return null;
    }

    @Override
    @Nullable
    public byte[] pullClass(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        File f = FilesKt.resolve((File)this.root, (String)path2);
        if (f.exists()) {
            return FilesKt.readBytes((File)f);
        }
        for (MincerFS leaf : this.leafs) {
            byte[] bytecode = leaf.pullClass(path2);
            if (bytecode == null) continue;
            return bytecode;
        }
        return null;
    }

    public MincerTreeFS(@NotNull File root, @NotNull List<? extends MincerFS> leafs) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(leafs, (String)"leafs");
        this.root = root;
        this.leafs = leafs;
    }
}

