/*
 * Decompiled with CFR 0.152.
 */
package ru.justagod.mincer.pipeline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import ru.justagod.mincer.Mincer;
import ru.justagod.mincer.control.MincerArchive;
import ru.justagod.mincer.control.MincerFS;
import ru.justagod.mincer.control.MincerResult;
import ru.justagod.mincer.control.MincerResultType;
import ru.justagod.mincer.pipeline.Pipeline;
import ru.justagod.mincer.pipeline.RawChainSegment;
import ru.justagod.mincer.processor.ClassInfo;
import ru.justagod.mincer.processor.SubMincer;
import ru.justagod.mincer.processor.WorkerContext;
import ru.justagod.model.ClassModel;
import ru.justagod.model.ClassTypeReference;
import ru.justagod.model.InheritanceHelper;
import ru.justagod.model.factory.BytecodeModelFactory;
import ru.justagod.model.factory.InternalClassModel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B1\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0012\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010&\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lru/justagod/mincer/pipeline/ChainHeadQueue;", "", "pipeline", "Lru/justagod/mincer/pipeline/Pipeline;", "input", "archive", "Lru/justagod/mincer/control/MincerArchive;", "next", "Lru/justagod/mincer/pipeline/RawChainSegment;", "(Lru/justagod/mincer/pipeline/Pipeline;Ljava/lang/Object;Lru/justagod/mincer/control/MincerArchive;Lru/justagod/mincer/pipeline/RawChainSegment;)V", "getArchive", "()Lru/justagod/mincer/control/MincerArchive;", "getInput", "()Ljava/lang/Object;", "getNext", "()Lru/justagod/mincer/pipeline/RawChainSegment;", "getPipeline", "()Lru/justagod/mincer/pipeline/Pipeline;", "advance", "fs", "Lru/justagod/mincer/control/MincerFS;", "inheritance", "Lru/justagod/model/InheritanceHelper;", "checkValidity", "", "mincer", "Lru/justagod/mincer/Mincer;", "name", "", "lastModificationTime", "", "doProcess", "Lru/justagod/mincer/control/MincerResult;", "bytecode", "", "skipped", "parseName", "Lru/justagod/model/ClassTypeReference;", "process", "GentleClassWriter", "cutter"})
public final class ChainHeadQueue {
    @NotNull
    private final Pipeline<?, ?> pipeline;
    @NotNull
    private final Object input;
    @Nullable
    private final MincerArchive archive;
    @Nullable
    private final RawChainSegment next;

    @Nullable
    public final ChainHeadQueue advance(@NotNull Object input, @NotNull MincerFS fs, @NotNull InheritanceHelper inheritance) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)inheritance, (String)"inheritance");
        if (this.next == null) {
            return null;
        }
        MincerArchive archive = fs.pullArchive(this.next.getPipeline().getId());
        SubMincer<?, ?> subMincer = this.next.getPipeline().getWorker();
        if (subMincer == null) {
            throw new TypeCastException("null cannot be cast to non-null type ru.justagod.mincer.processor.SubMincer<kotlin.Any, kotlin.Any>");
        }
        Pipeline<?, ?> pipeline = this.next.getPipeline();
        if (pipeline == null) {
            throw new TypeCastException("null cannot be cast to non-null type ru.justagod.mincer.pipeline.Pipeline<kotlin.Any, kotlin.Any>");
        }
        subMincer.startProcessing(input, archive, inheritance, pipeline);
        return new ChainHeadQueue(this.next.getPipeline(), input, archive, this.next.getNext());
    }

    @NotNull
    public final MincerResult process(@NotNull Mincer mincer, @NotNull byte[] bytecode, long lastModificationTime, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)mincer, (String)"mincer");
        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            if (this.archive != null && mincer.getCanSkip() && this.pipeline.getSkippable$cutter() && lastModificationTime < this.archive.getCreationTime() && this.archive.getMembers().contains(this.parseName(name))) {
                return this.doProcess(mincer, bytecode, name, true);
            }
            if (this.checkValidity(mincer, name, lastModificationTime)) {
                return this.doProcess(mincer, bytecode, name, false);
            }
            return new MincerResult(bytecode, MincerResultType.SKIPPED);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Exception while processing " + name, e);
        }
    }

    private final boolean checkValidity(Mincer mincer, String name, long lastModificationTime) {
        ClassTypeReference reference = this.parseName(name);
        if (this.archive != null && this.archive.getCreationTime() > lastModificationTime && this.archive.getMembers().contains(reference)) {
            return true;
        }
        try {
            Function0 model2 = (Function0)new Function0<ClassModel>(mincer, reference){
                final /* synthetic */ Mincer $mincer;
                final /* synthetic */ ClassTypeReference $reference;

                @NotNull
                public final ClassModel invoke() {
                    return this.$mincer.getFactory().makeModel(this.$reference, null);
                }
                {
                    this.$mincer = mincer;
                    this.$reference = classTypeReference;
                    super(0);
                }
            };
            return this.pipeline.getFilter$cutter().isValid(reference, (Function0<? extends ClassModel>)model2, mincer.getInheritance(), mincer.getFactory());
        }
        catch (Exception e) {
            return false;
        }
    }

    private final MincerResult doProcess(Mincer mincer, byte[] bytecode, String name, boolean skipped) {
        ClassInfo classInfo;
        ClassTypeReference reference = this.parseName(name);
        if (!skipped) {
            ClassNode node = mincer.getNodes().makeNode(reference);
            InternalClassModel model2 = BytecodeModelFactory.Companion.makeModel(node, null);
            classInfo = new ClassInfo(model2, node);
        } else {
            classInfo = null;
        }
        ClassInfo info = classInfo;
        mincer.submitArchiveEntry(this.pipeline.getId(), reference.getName());
        SubMincer<?, ?> subMincer = this.pipeline.getWorker();
        if (subMincer == null) {
            throw new TypeCastException("null cannot be cast to non-null type ru.justagod.mincer.processor.SubMincer<kotlin.Any, kotlin.Any>");
        }
        Pipeline<?, ?> pipeline = this.pipeline;
        if (pipeline == null) {
            throw new TypeCastException("null cannot be cast to non-null type ru.justagod.mincer.pipeline.Pipeline<kotlin.Any, kotlin.Any>");
        }
        MincerResultType result = subMincer.process(new WorkerContext(reference, info, pipeline, this.input, mincer));
        if (result == MincerResultType.MODIFIED) {
            GentleClassWriter writer = new GentleClassWriter(mincer);
            try {
                ClassInfo classInfo2 = info;
                if (classInfo2 != null && (classInfo2 = classInfo2.getNode()) != null) {
                    classInfo2.accept((ClassVisitor)writer);
                }
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("Exception while rewriting node " + reference.getName() + " after " + this.pipeline.getId(), e);
            }
            byte[] byArray = writer.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"writer.toByteArray()");
            return new MincerResult(byArray, MincerResultType.MODIFIED);
        }
        return new MincerResult(bytecode, result);
    }

    private final ClassTypeReference parseName(String name) {
        return StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) ? new ClassTypeReference(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.dropLast((String)name, (int)6), (char)'/', (char)'.', (boolean)false, (int)4, null), (char)'\\', (char)'.', (boolean)false, (int)4, null)) : new ClassTypeReference(StringsKt.replace$default((String)StringsKt.replace$default((String)name, (char)'/', (char)'.', (boolean)false, (int)4, null), (char)'\\', (char)'.', (boolean)false, (int)4, null));
    }

    @NotNull
    public final Pipeline<?, ?> getPipeline() {
        return this.pipeline;
    }

    @NotNull
    public final Object getInput() {
        return this.input;
    }

    @Nullable
    public final MincerArchive getArchive() {
        return this.archive;
    }

    @Nullable
    public final RawChainSegment getNext() {
        return this.next;
    }

    public ChainHeadQueue(@NotNull Pipeline<?, ?> pipeline, @NotNull Object input, @Nullable MincerArchive archive, @Nullable RawChainSegment next) {
        Intrinsics.checkParameterIsNotNull(pipeline, (String)"pipeline");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.pipeline = pipeline;
        this.input = input;
        this.archive = archive;
        this.next = next;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/justagod/mincer/pipeline/ChainHeadQueue$GentleClassWriter;", "Lorg/objectweb/asm/ClassWriter;", "mincer", "Lru/justagod/mincer/Mincer;", "(Lru/justagod/mincer/pipeline/ChainHeadQueue;Lru/justagod/mincer/Mincer;)V", "getCommonSuperClass", "", "type1", "type2", "cutter"})
    private final class GentleClassWriter
    extends ClassWriter {
        private final Mincer mincer;

        @NotNull
        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            Intrinsics.checkParameterIsNotNull((Object)type1, (String)"type1");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type2");
            try {
                CharSequence charSequence = type1;
                CharSequence charSequence2 = "[/\\\\]";
                Object object = new Regex(charSequence2);
                charSequence2 = object;
                String string = ".";
                Object object2 = object = charSequence2.replace(charSequence, string);
                ClassTypeReference reference1 = new ClassTypeReference((String)object2);
                charSequence2 = type2;
                string = "[/\\\\]";
                object = new Regex(string);
                string = object;
                String string2 = ".";
                Object object3 = object = string.replace(charSequence2, string2);
                ClassTypeReference reference2 = new ClassTypeReference((String)object3);
                ClassModel model1 = this.mincer.getFactory().makeModel(reference1, null);
                ClassModel model2 = this.mincer.getFactory().makeModel(reference2, null);
                if (model1.getAccess().isInterface() || model2.getAccess().isInterface()) {
                    return "java/lang/Object";
                }
                List supers1 = InheritanceHelper.getSuperClasses$default(this.mincer.getInheritance(), reference1, null, 2, null);
                List supers2 = InheritanceHelper.getSuperClasses$default(this.mincer.getInheritance(), reference2, null, 2, null);
                for (ClassModel model3 : supers1) {
                    boolean bl;
                    block7: {
                        Iterable $receiver$iv = supers2;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                ClassModel it = (ClassModel)element$iv;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)model3.getName())) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    String string3 = model3.getName().toASMType().getInternalName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"model.name.toASMType().internalName");
                    return string3;
                }
                return "java/lang/Object";
            }
            catch (Exception e) {
                return "java/lang/Object";
            }
        }

        public GentleClassWriter(Mincer mincer) {
            Intrinsics.checkParameterIsNotNull((Object)mincer, (String)"mincer");
            super(3);
            this.mincer = mincer;
        }
    }
}

