/*
 * Decompiled with CFR 0.152.
 */
package tech.ixirsii.klash.serialize;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/ixirsii/klash/serialize/ZonedDateTimeSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/time/ZonedDateTime;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserializeFormatter", "Ljava/time/format/DateTimeFormatter;", "serializeFormatter", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "klash-api"})
public final class ZonedDateTimeSerializer
implements KSerializer<ZonedDateTime> {
    @NotNull
    private final DateTimeFormatter deserializeFormatter;
    @NotNull
    private final DateTimeFormatter serializeFormatter;
    @NotNull
    private final SerialDescriptor descriptor;

    public ZonedDateTimeSerializer() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSS'Z'");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.deserializeFormatter = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"toFormatter(...)");
        this.serializeFormatter = dateTimeFormatter2;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"ZonedDateTime", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public ZonedDateTime deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        ZonedDateTime zonedDateTime = LocalDateTime.parse(decoder.decodeString(), this.deserializeFormatter).atZone(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return zonedDateTime;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull ZonedDateTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.format(this.serializeFormatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        encoder.encodeString(string);
    }
}

