/*
 * Decompiled with CFR 0.152.
 */
package tech.ixirsii.klash.client.internal;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalOrThrowKt;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ixirsii.klash.client.internal.CreateAPIKeyBody;
import tech.ixirsii.klash.client.internal.CreateAPIKeyResponse;
import tech.ixirsii.klash.client.internal.Key;
import tech.ixirsii.klash.client.internal.KeyList;
import tech.ixirsii.klash.client.internal.MediaTypeKt;
import tech.ixirsii.klash.error.ClashTokenError;
import tech.ixirsii.klash.logging.Logging;
import tech.ixirsii.klash.logging.LoggingImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J%\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00170\u000f\"\u0006\b\u0000\u0010\u0017\u0018\u00012\u0006\u0010\u0018\u001a\u00020\u0003H\u0082\bJ\b\u0010\u0019\u001a\u00020\u0003H\u0002J\u001a\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001b0\u000fH\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001d0\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ltech/ixirsii/klash/client/internal/TokenManager;", "Ltech/ixirsii/klash/logging/Logging;", "email", "", "password", "client", "Lokhttp3/OkHttpClient;", "json", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/OkHttpClient;Lkotlinx/serialization/json/Json;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "token", "Larrow/core/Either;", "Ltech/ixirsii/klash/error/ClashTokenError;", "getToken", "()Larrow/core/Either;", "createKey", "Ltech/ixirsii/klash/client/internal/Key;", "ip", "deserialize", "T", "body", "getIP", "getKeys", "", "login", "", "Companion", "klash-api"})
@SourceDebugExtension(value={"SMAP\nTokenManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenManager.kt\ntech/ixirsii/klash/client/internal/TokenManager\n+ 2 LoggingImpl.kt\ntech/ixirsii/klash/logging/LoggingImpl$Companion\n+ 3 Either.kt\narrow/core/EitherKt\n+ 4 Either.kt\narrow/core/Either\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 7 Either.kt\narrow/core/Either$Companion\n+ 8 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n+ 9 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,195:1\n122#1:224\n123#1:228\n124#1:233\n125#1,3:245\n122#1:274\n123#1:278\n124#1:283\n125#1,3:295\n48#2:196\n1715#3,4:197\n1715#3,3:205\n1718#3:210\n1715#3,4:211\n1715#3,4:219\n1715#3,4:252\n1715#3,4:302\n675#4,4:201\n675#4,4:215\n698#4,4:234\n603#4,7:238\n675#4,4:248\n698#4,4:263\n603#4,7:267\n698#4,4:284\n603#4,7:288\n675#4,4:298\n288#5,2:208\n113#6:223\n1128#7:225\n1128#7:256\n1128#7:275\n491#8,2:226\n493#8,3:230\n491#8,2:257\n493#8,3:260\n491#8,2:276\n493#8,3:280\n96#9:229\n96#9:259\n96#9:279\n*S KotlinDebug\n*F\n+ 1 TokenManager.kt\ntech/ixirsii/klash/client/internal/TokenManager\n*L\n106#1:224\n106#1:228\n106#1:233\n106#1:245,3\n155#1:274\n155#1:278\n155#1:283\n155#1:295,3\n65#1:196\n76#1:197,4\n78#1:205,3\n78#1:210\n80#1:211,4\n82#1:219,4\n106#1:252,4\n155#1:302,4\n78#1:201,4\n82#1:215,4\n106#1:234,4\n106#1:238,7\n106#1:248,4\n124#1:263,4\n124#1:267,7\n155#1:284,4\n155#1:288,7\n155#1:298,4\n79#1:208,2\n98#1:223\n106#1:225\n122#1:256\n155#1:275\n106#1:226,2\n106#1:230,3\n122#1:257,2\n122#1:260,3\n155#1:276,2\n155#1:280,3\n106#1:229\n123#1:259\n155#1:279\n*E\n"})
public final class TokenManager
implements Logging {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String email;
    @NotNull
    private final String password;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Json json;
    private final /* synthetic */ LoggingImpl $$delegate_0;
    @NotNull
    private static final String DEVELOPER_URL = "https://developer.clashofclans.com/api";

    public TokenManager(@NotNull String email, @NotNull String password, @NotNull OkHttpClient client, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.email = email;
        this.password = password;
        this.client = client;
        this.json = json;
        LoggingImpl.Companion this_$iv = LoggingImpl.Companion;
        boolean $i$f$invoke = false;
        Logger logger = LoggerFactory.getLogger(TokenManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.$$delegate_0 = new LoggingImpl(logger);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.$$delegate_0.getLog();
    }

    @NotNull
    public final Either<ClashTokenError, String> getToken() {
        Either either;
        Either<ClashTokenError, Key> either2;
        Either either3;
        boolean bl;
        Object it$iv;
        Object object;
        this.getLog().trace("Getting token");
        String ip = this.getIP();
        Either $this$flatMap$iv = this.login(this.email, this.password);
        boolean $i$f$flatMap = false;
        Either either4 = $this$flatMap$iv;
        if (either4 instanceof Either.Right) {
            Unit it = (Unit)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl2 = false;
            object = this.getKeys();
        } else if (either4 instanceof Either.Left) {
            object = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either this_$iv = object;
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap2 = false;
        Either bl2 = $this$flatMap$iv$iv;
        if (bl2 instanceof Either.Right) {
            Object v1;
            block18: {
                it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                bl = false;
                List keys = (List)it$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = keys;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Key it = (Key)element$iv;
                    boolean bl4 = false;
                    if (!it.getCidrRanges().contains(ip)) continue;
                    v1 = element$iv;
                    break block18;
                }
                v1 = null;
            }
            Key key = v1;
            either3 = (Either)new Either.Right((Object)key);
        } else if (bl2 instanceof Either.Left) {
            either3 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$flatMap$iv = either3;
        $i$f$flatMap = false;
        $this$flatMap$iv$iv = $this$flatMap$iv;
        if ($this$flatMap$iv$iv instanceof Either.Right) {
            Either<ClashTokenError, Key> it = (Either<ClashTokenError, Key>)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl5 = false;
            either2 = it;
            if (either2 == null || (either2 = EitherKt.right(either2)) == null) {
                either2 = this.createKey(ip);
            }
        } else if ($this$flatMap$iv$iv instanceof Either.Left) {
            either2 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this_$iv = either2;
        $i$f$map = false;
        $this$flatMap$iv$iv = this_$iv;
        $i$f$flatMap = false;
        Either either5 = $this$flatMap$iv$iv;
        if (either5 instanceof Either.Right) {
            it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            bl = false;
            Key it = (Key)it$iv;
            boolean bl6 = false;
            String string = it.getKey();
            either = (Either)new Either.Right((Object)string);
        } else if (either5 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either<ClashTokenError, Key> createKey(String ip) {
        void $this$encodeToString$iv;
        StringFormat stringFormat = (StringFormat)this.json;
        CreateAPIKeyBody value$iv = new CreateAPIKeyBody(CollectionsKt.listOf((Object)ip), null, null, null, 14, null);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        RequestBody body = RequestBody.Companion.create($this$encodeToString$iv.encodeToString((SerializationStrategy)CreateAPIKeyBody.Companion.serializer(), (Object)value$iv), MediaTypeKt.getMEDIA_TYPE());
        Request request = new Request.Builder().url("https://developer.clashofclans.com/api/apikey/create").post(body).build();
        Call call = this.client.newCall(request);
        this.getLog().debug("Creating new key");
        Closeable closeable = (Closeable)call.execute();
        Throwable throwable = null;
        try {
            Either either;
            Response response = (Response)closeable;
            boolean bl = false;
            if (response.isSuccessful()) {
                Either either2;
                Either either3;
                Either this_$iv;
                TokenManager tokenManager = this;
                String body$iv = response.body().string();
                boolean $i$f$deserialize = false;
                Either.Companion this_$iv$iv = Either.Companion;
                boolean $i$f$tryCatch = false;
                boolean $i$f$catch = false;
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Json this_$iv$iv2 = this_$iv.json;
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv2.getSerializersModule();
                    either3 = EitherKt.right((Object)this_$iv$iv2.decodeFromString((DeserializationStrategy)CreateAPIKeyResponse.Companion.serializer(), body$iv));
                }
                catch (Throwable t$iv$iv$iv) {
                    Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)t$iv$iv$iv);
                    boolean bl4 = false;
                    either3 = EitherKt.left((Object)it$iv$iv);
                }
                this_$iv$iv = either3;
                boolean $i$f$mapLeft = false;
                Either.Companion this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$fold = false;
                Either.Companion bl3 = this_$iv$iv$iv;
                if (bl3 instanceof Either.Right) {
                    it$iv$iv = ((Either.Right)this_$iv$iv$iv).getValue();
                    boolean bl5 = false;
                    either2 = (Either)new Either.Right(it$iv$iv);
                } else {
                    if (!(bl3 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                    it$iv$iv = ((Either.Left)this_$iv$iv$iv).getValue();
                    boolean bl6 = false;
                    Throwable it$iv = (Throwable)it$iv$iv;
                    boolean bl7 = false;
                    this_$iv.getLog().error("Caught exception deserializing response", it$iv);
                    String string = it$iv.getMessage();
                    if (string == null) {
                        string = "Caught exception deserializing response";
                    }
                    ClashTokenError.DeserializationError deserializationError = new ClashTokenError.DeserializationError(string);
                    either2 = (Either)new Either.Left((Object)deserializationError);
                }
                this_$iv = either2;
                boolean $i$f$map = false;
                Either $this$flatMap$iv$iv = this_$iv;
                boolean $i$f$flatMap = false;
                Either either4 = $this$flatMap$iv$iv;
                if (either4 instanceof Either.Right) {
                    Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl8 = false;
                    CreateAPIKeyResponse it = (CreateAPIKeyResponse)it$iv;
                    boolean bl9 = false;
                    Key key = it.getKey();
                    either = (Either)new Either.Right((Object)key);
                } else {
                    if (!(either4 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                    either = $this$flatMap$iv$iv;
                }
            } else {
                this.getLog().error("Failed to create new key: {}", (Object)response.body().string());
                either = EitherKt.left((Object)new ClashTokenError.CreateAPIKeyError(response.message()));
            }
            Either either5 = either;
            return either5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final /* synthetic */ <T> Either<ClashTokenError, T> deserialize(String body) {
        Either either;
        Either either2;
        boolean $i$f$deserialize = false;
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        boolean $i$f$catch = false;
        try {
            boolean bl = false;
            boolean bl2 = false;
            Json this_$iv2 = this.json;
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv2.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            either2 = EitherKt.right((Object)this_$iv2.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), body));
        }
        catch (Throwable t$iv$iv) {
            Throwable it$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)t$iv$iv);
            boolean bl = false;
            either2 = EitherKt.left((Object)it$iv);
        }
        this_$iv = either2;
        boolean $i$f$mapLeft = false;
        Either.Companion this_$iv$iv = this_$iv;
        boolean $i$f$fold = false;
        Either.Companion companion = this_$iv$iv;
        if (companion instanceof Either.Right) {
            it$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            either = (Either)new Either.Right(it$iv);
        } else if (companion instanceof Either.Left) {
            it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            Throwable it = (Throwable)it$iv;
            boolean bl3 = false;
            this.getLog().error("Caught exception deserializing response", it);
            String string = it.getMessage();
            if (string == null) {
                string = "Caught exception deserializing response";
            }
            ClashTokenError.DeserializationError deserializationError = new ClashTokenError.DeserializationError(string);
            either = (Either)new Either.Left((Object)deserializationError);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    private final String getIP() {
        URL uRL = new URI("https://checkip.amazonaws.com").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String ip = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset))).toString();
        this.getLog().debug("Current IP address: {}", (Object)ip);
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either<ClashTokenError, List<Key>> getKeys() {
        Request request = new Request.Builder().url("https://developer.clashofclans.com/api/apikey/list").post(RequestBody.Companion.create("", null)).build();
        Call call = this.client.newCall(request);
        this.getLog().debug("Fetching keys");
        Closeable closeable = (Closeable)call.execute();
        Throwable throwable = null;
        try {
            Either either;
            Response response = (Response)closeable;
            boolean bl = false;
            if (response.isSuccessful()) {
                Either either2;
                Either either3;
                Either this_$iv;
                TokenManager tokenManager = this;
                String body$iv = response.body().string();
                boolean $i$f$deserialize = false;
                Either.Companion this_$iv$iv = Either.Companion;
                boolean $i$f$tryCatch = false;
                boolean $i$f$catch = false;
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Json this_$iv$iv2 = this_$iv.json;
                    boolean $i$f$decodeFromString = false;
                    this_$iv$iv2.getSerializersModule();
                    either3 = EitherKt.right((Object)this_$iv$iv2.decodeFromString((DeserializationStrategy)KeyList.Companion.serializer(), body$iv));
                }
                catch (Throwable t$iv$iv$iv) {
                    Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)t$iv$iv$iv);
                    boolean bl4 = false;
                    either3 = EitherKt.left((Object)it$iv$iv);
                }
                this_$iv$iv = either3;
                boolean $i$f$mapLeft = false;
                Either.Companion this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$fold = false;
                Either.Companion bl3 = this_$iv$iv$iv;
                if (bl3 instanceof Either.Right) {
                    it$iv$iv = ((Either.Right)this_$iv$iv$iv).getValue();
                    boolean bl5 = false;
                    either2 = (Either)new Either.Right(it$iv$iv);
                } else {
                    if (!(bl3 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                    it$iv$iv = ((Either.Left)this_$iv$iv$iv).getValue();
                    boolean bl6 = false;
                    Throwable it$iv = (Throwable)it$iv$iv;
                    boolean bl7 = false;
                    this_$iv.getLog().error("Caught exception deserializing response", it$iv);
                    String string = it$iv.getMessage();
                    if (string == null) {
                        string = "Caught exception deserializing response";
                    }
                    ClashTokenError.DeserializationError deserializationError = new ClashTokenError.DeserializationError(string);
                    either2 = (Either)new Either.Left((Object)deserializationError);
                }
                this_$iv = either2;
                boolean $i$f$map = false;
                Either $this$flatMap$iv$iv = this_$iv;
                boolean $i$f$flatMap = false;
                Either either4 = $this$flatMap$iv$iv;
                if (either4 instanceof Either.Right) {
                    Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl8 = false;
                    KeyList it = (KeyList)it$iv;
                    boolean bl9 = false;
                    List<Key> list = it.getKeys();
                    either = (Either)new Either.Right(list);
                } else {
                    if (!(either4 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                    either = $this$flatMap$iv$iv;
                }
            } else {
                either = EitherKt.left((Object)new ClashTokenError.KeyRetrievalError(response.message()));
            }
            Either either5 = either;
            return either5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Either<ClashTokenError, Unit> login(String email, String password) {
        Either either;
        this.getLog().trace("Logging in with email \"{}\"", (Object)email);
        Request request = new Request.Builder().url("https://developer.clashofclans.com/api/login").post(RequestBody.Companion.create("{\"email\":\"" + email + "\",\"password\":\"" + password + "\"}", MediaTypeKt.getMEDIA_TYPE())).build();
        Call call = this.client.newCall(request);
        this.getLog().debug("Logging in to developer portal");
        Closeable closeable = (Closeable)call.execute();
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            either = it.code() == 403 ? EitherKt.left((Object)new ClashTokenError.LoginError(it.message())) : EitherKt.right((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return either;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/ixirsii/klash/client/internal/TokenManager$Companion;", "", "()V", "DEVELOPER_URL", "", "klash-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

