/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.endpoint;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.health.Health;
import tech.iooo.boot.spring.configuration.IoooVerticleServicesHolder;

@Endpoint(id="verticlesUndeploy")
public class IoooUndeployVerticleEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IoooUndeployVerticleEndpoint.class);
    @Autowired
    private Vertx vertx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteOperation
    public Health undeploy(@Selector String id) {
        if (this.vertx.deploymentIDs().contains(id)) {
            this.vertx.undeploy(id);
            String name = (String)((Map)IoooVerticleServicesHolder.activeVerticleServices().columnMap().get(id)).keySet().iterator().next();
            logger.info("undeploy verticle [{}],id [{}].", (Object)name, (Object)id);
            ArrayList active = Lists.newArrayList();
            ArrayList inactive = Lists.newArrayList();
            Class<IoooVerticleServicesHolder> clazz = IoooVerticleServicesHolder.class;
            synchronized (IoooVerticleServicesHolder.class) {
                IoooVerticleServicesHolder.inactiveVerticleServices().put((Object)name, (Object)id, IoooVerticleServicesHolder.activeVerticleServices().get((Object)name, (Object)id));
                IoooVerticleServicesHolder.activeVerticleServices().columnKeySet().remove(id);
                IoooVerticleServicesHolder.activeVerticleServices().cellSet().forEach(cell -> {
                    HashMap detail = Maps.newHashMap();
                    detail.put("name", cell.getRowKey());
                    detail.put("id", cell.getColumnKey());
                    active.add(detail);
                });
                IoooVerticleServicesHolder.inactiveVerticleServices().cellSet().forEach(cell -> {
                    HashMap detail = Maps.newHashMap();
                    detail.put("name", cell.getRowKey());
                    detail.put("id", cell.getColumnKey());
                    inactive.add(detail);
                });
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return Health.up().withDetail("verticles", (Object)active).withDetail("inactive verticles", (Object)inactive).withDetail("timestamp", (Object)LocalDateTime.now()).build();
            }
        }
        return Health.unknown().withDetail("message", (Object)"unknown verticle").withDetail("timestamp", (Object)LocalDateTime.now()).build();
    }
}

