/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.endpoint;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import tech.iooo.boot.spring.configuration.IoooVerticleServicesHolder;

@Endpoint(id="verticlesDeploy")
public class IoooDeployVerticleEndpoint
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(IoooDeployVerticleEndpoint.class);
    @Autowired
    private Vertx vertx;
    private ApplicationContext applicationContext;

    @WriteOperation
    public Health deploy(@Selector String clazz, @Selector String config) {
        String deploymentConfig = Strings.isNullOrEmpty((String)config) ? "defaultDeploymentOptions" : config;
        if (!this.applicationContext.containsBean(deploymentConfig)) {
            return Health.unknown().withDetail("message", (Object)("unknown deploymentOptions " + deploymentConfig)).withDetail("timestamp", (Object)LocalDateTime.now()).build();
        }
        if (IoooVerticleServicesHolder.activeVerticleServices().rowKeySet().contains(clazz)) {
            AbstractVerticle verticle = (AbstractVerticle)((Map)IoooVerticleServicesHolder.activeVerticleServices().rowMap().get(clazz)).values().iterator().next();
            return Health.up().withDetail("message", (Object)"already deployed").withDetail("config", (Object)verticle.config()).withDetail("timestamp", (Object)LocalDateTime.now()).build();
        }
        if (IoooVerticleServicesHolder.inactiveVerticleServices().rowKeySet().contains(clazz)) {
            DeploymentOptions deploymentOptions = (DeploymentOptions)this.applicationContext.getBean(deploymentConfig);
            CompletableFuture healthFuture = new CompletableFuture();
            this.vertx.deployVerticle(clazz, deploymentOptions, res -> {
                if (res.succeeded()) {
                    Class<IoooVerticleServicesHolder> clazz2 = IoooVerticleServicesHolder.class;
                    synchronized (IoooVerticleServicesHolder.class) {
                        IoooVerticleServicesHolder.inactiveVerticleServices().rowKeySet().remove(clazz);
                        try {
                            IoooVerticleServicesHolder.activeVerticleServices().put((Object)clazz, res.result(), (Object)((AbstractVerticle)BeanUtils.instantiateClass(Class.forName(clazz))));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        logger.info("deployed verticle [{}] with deploymentOption [{}],id [{}].", new Object[]{clazz, deploymentConfig, res.result()});
                        ArrayList active = Lists.newArrayList();
                        ArrayList inactive = Lists.newArrayList();
                        IoooVerticleServicesHolder.activeVerticleServices().cellSet().forEach(cell -> {
                            HashMap detail = Maps.newHashMap();
                            detail.put("name", cell.getRowKey());
                            detail.put("id", cell.getColumnKey());
                            active.add(detail);
                        });
                        IoooVerticleServicesHolder.inactiveVerticleServices().cellSet().forEach(cell -> {
                            HashMap detail = Maps.newHashMap();
                            detail.put("name", cell.getRowKey());
                            detail.put("id", cell.getColumnKey());
                            inactive.add(detail);
                        });
                        healthFuture.complete(Health.up().withDetail("verticles", (Object)active).withDetail("inactive verticles", (Object)inactive).withDetail("timestamp", (Object)LocalDateTime.now()).build());
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                }
                healthFuture.complete(Health.down().withException(res.cause()).withDetail("timestamp", (Object)LocalDateTime.now()).build());
                logger.error("", res.cause());
            });
            try {
                return (Health)healthFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return Health.up().build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

