/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.configuration;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import tech.iooo.boot.spring.annotation.VerticleService;
import tech.iooo.boot.spring.configuration.IoooVerticleServicesHolder;
import tech.iooo.boot.spring.configuration.IoooVertxProperties;

@Configuration
public class IoooVertxApplicationBooster
implements SmartLifecycle,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(IoooVertxApplicationBooster.class);
    @Autowired
    private Vertx vertx;
    @Autowired
    private IoooVertxProperties ioooVertxProperties;
    private boolean running;
    private ApplicationContext applicationContext;

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
        this.vertx.close();
        this.running = false;
    }

    public void start() {
        this.applicationContext.getBeansWithAnnotation(VerticleService.class).forEach((name, bean) -> {
            AbstractVerticle verticle = (AbstractVerticle)bean;
            IoooVerticleServicesHolder.activeVerticleServices().put((Object)bean.getClass().getName(), (Object)"", (Object)verticle);
        });
        IoooVerticleServicesHolder.activeVerticleServices().values().forEach(verticle -> {
            String optionName;
            DeploymentOptions deploymentOptions;
            Class<?> verticleClass = verticle.getClass();
            VerticleService verticleService = verticle.getClass().getAnnotation(VerticleService.class);
            if (this.ioooVertxProperties.getVerticle().isFailFast()) {
                deploymentOptions = (DeploymentOptions)this.applicationContext.getBean(verticleService.deploymentOption(), DeploymentOptions.class);
                optionName = verticleService.deploymentOption();
            } else if (this.applicationContext.containsBean(verticleService.deploymentOption())) {
                deploymentOptions = (DeploymentOptions)this.applicationContext.getBean(verticleService.deploymentOption(), DeploymentOptions.class);
                optionName = verticleService.deploymentOption();
            } else {
                logger.warn("failed to get deploymentOption [{}] during the deployment of verticle [{}],use default deployment options instead.", (Object)verticleService.deploymentOption(), (Object)verticleClass.getSimpleName());
                deploymentOptions = (DeploymentOptions)this.applicationContext.getBean("defaultDeploymentOptions", DeploymentOptions.class);
                optionName = "defaultDeploymentOptions";
            }
            this.vertx.deployVerticle("iooo:" + verticleClass.getName(), deploymentOptions, res -> {
                if (res.succeeded()) {
                    logger.info("deployed verticle [{}] with deploymentOption [{}],id [{}].", new Object[]{verticleClass.getSimpleName(), optionName, res.result()});
                    IoooVerticleServicesHolder.activeVerticleServices().row((Object)verticleClass.getName()).remove("");
                    IoooVerticleServicesHolder.activeVerticleServices().row((Object)verticleClass.getName()).put(res.result(), verticle);
                } else {
                    logger.error("error with deploy verticle " + verticleClass.getName(), res.cause());
                }
            });
        });
        this.running = true;
    }

    public void stop() {
        this.stop(() -> IoooVerticleServicesHolder.activeVerticleServices().columnKeySet().forEach(verticle -> this.vertx.undeploy(verticle)));
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

