/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.configuration;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.iooo.boot.spring.configuration.SpringVerticleFactory;

@Configuration
public class VertxConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public Vertx vertx() {
        VertxOptions vertxOptions = new VertxOptions();
        SpringVerticleFactory springVerticleFactory = (SpringVerticleFactory)this.applicationContext.getBean(SpringVerticleFactory.class);
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        vertx.registerVerticleFactory((VerticleFactory)springVerticleFactory);
        return vertx;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventBus eventBus(Vertx vertx) {
        return vertx.eventBus();
    }

    @Bean
    @ConditionalOnMissingBean
    public FileSystem fileSystem(Vertx vertx) {
        return vertx.fileSystem();
    }

    @Bean
    @ConditionalOnMissingBean
    public SharedData sharedData(Vertx vertx) {
        return vertx.sharedData();
    }

    @Bean(value={"defaultDeploymentOptions"})
    public DeploymentOptions deploymentOptions() {
        return new DeploymentOptions();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

