/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.configuration;

import com.google.common.collect.Lists;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;
import tech.iooo.boot.spring.annotation.VerticleService;

@Component
public class VertxApplicationLifecycle
implements SmartLifecycle,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(VertxApplicationLifecycle.class);
    @Autowired
    private Vertx vertx;
    private boolean running;
    private ApplicationContext applicationContext;
    private List<String> deployedVerticles = Lists.newArrayList();

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
        this.running = false;
    }

    public void start() {
        Map verticleServices = this.applicationContext.getBeansWithAnnotation(VerticleService.class);
        verticleServices.values().forEach(verticle -> {
            String verticleName = verticle.getClass().getName();
            VerticleService verticleService = verticle.getClass().getAnnotation(VerticleService.class);
            DeploymentOptions deploymentOptions = (DeploymentOptions)this.applicationContext.getBean(verticleService.deploymentOption(), DeploymentOptions.class);
            this.vertx.deployVerticle("iooo:" + verticleName, deploymentOptions, res -> {
                if (res.succeeded()) {
                    logger.info("deployed verticle [{}] with id [{}]", (Object)verticleName, res.result());
                    this.deployedVerticles.add((String)res.result());
                } else {
                    logger.error("error with deploy verticle " + verticleName, res.cause());
                }
            });
        });
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

