/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.spring.endpoint;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.vertx.core.Vertx;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import tech.iooo.boot.spring.configuration.IoooVerticleServicesHolder;

@Endpoint(id="verticles")
public class IoooListVerticleEndpoint {
    @Autowired
    private Vertx vertx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadOperation
    public Health getCustom() {
        if (Objects.isNull(this.vertx)) {
            return Health.down().withDetail("message", (Object)"vertx inactive").status(Status.DOWN).build();
        }
        ArrayList active = Lists.newArrayList();
        ArrayList inactive = Lists.newArrayList();
        Class<IoooVerticleServicesHolder> clazz = IoooVerticleServicesHolder.class;
        synchronized (IoooVerticleServicesHolder.class) {
            IoooVerticleServicesHolder.activeVerticleServices().cellSet().forEach(cell -> {
                HashMap detail = Maps.newHashMap();
                detail.put("name", cell.getRowKey());
                detail.put("id", cell.getColumnKey());
                active.add(detail);
            });
            IoooVerticleServicesHolder.inactiveVerticleServices().cellSet().forEach(cell -> {
                HashMap detail = Maps.newHashMap();
                detail.put("name", cell.getRowKey());
                detail.put("id", cell.getColumnKey());
                inactive.add(detail);
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Health.up().withDetail("verticles", (Object)active).withDetail("inactive verticles", (Object)inactive).withDetail("timestamp", (Object)LocalDateTime.now()).build();
        }
    }
}

