/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.cache;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Pool;
import tech.iooo.boot.cache.CacheKit;
import tech.iooo.boot.cache.CacheType;
import tech.iooo.boot.cache.ClusterRedisConfig;
import tech.iooo.boot.cache.Config;
import tech.iooo.boot.cache.JedisCacheable;
import tech.iooo.boot.cache.JedisClusterCacheable;
import tech.iooo.boot.cache.JedisSentinelKit;
import tech.iooo.boot.cache.RedisConfig;
import tech.iooo.boot.core.Lifecycle;
import tech.iooo.boot.core.utils.Assert;

public class JedisSentinelLifecycle
implements Lifecycle {
    private final CacheType cacheType;
    private Config config;
    private boolean running;
    private JedisPool pool;

    public JedisSentinelLifecycle(CacheType cacheType, Config initConfig) {
        this.cacheType = cacheType;
        switch (cacheType) {
            case JedisCluster: {
                Assert.isTrue((boolean)(initConfig instanceof ClusterRedisConfig), (String)"config type error");
                this.config = initConfig;
                break;
            }
            case Jedis: {
                Assert.isTrue((boolean)(initConfig instanceof RedisConfig), (String)"config type error");
                this.config = initConfig;
            }
        }
    }

    public void start() {
        switch (this.cacheType) {
            case Jedis: {
                RedisConfig redisConfig = (RedisConfig)this.config;
                this.pool = new JedisPool((GenericObjectPoolConfig)redisConfig.getJedisPoolConfig(), redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimeout(), redisConfig.getPassword());
                JedisSentinelKit.init((Pool<Jedis>)this.pool);
                CacheKit.init(new JedisCacheable());
                break;
            }
            case JedisCluster: {
                JedisClusterCacheable jedisClusterCacheable = new JedisClusterCacheable();
                jedisClusterCacheable.init((ClusterRedisConfig)this.config);
                CacheKit.init(jedisClusterCacheable);
                break;
            }
        }
        this.running = true;
    }

    public void stop() {
        try {
            this.pool.destroy();
            JedisSentinelKit.init(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

