/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.util.Pool;
import redis.clients.util.SafeEncoder;
import tech.iooo.boot.cache.JedisAction;
import tech.iooo.boot.cache.JedisAtom;
import tech.iooo.boot.cache.utils.KryoRedisSerializer;
import tech.iooo.boot.core.logging.Logger;
import tech.iooo.boot.core.logging.LoggerFactory;

public class JedisSentinelKit {
    private static final Logger logger = LoggerFactory.getLogger(JedisSentinelKit.class);
    private static final String SUCCESS = "OK";
    private static Pool<Jedis> pool;

    public static void init(Pool<Jedis> pool) {
        JedisSentinelKit.pool = pool;
    }

    public static List<Object> tx(JedisAtom jedisAtom) {
        Jedis jedis = (Jedis)pool.getResource();
        Transaction trans = jedis.multi();
        jedisAtom.action(trans);
        return trans.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(JedisAction<T> jedisAction) {
        T result = null;
        Jedis jedis = (Jedis)pool.getResource();
        try {
            result = jedisAction.action(jedis);
        }
        catch (Exception e) {
            logger.error("[JedisAction.action(Jedis)]", (Throwable)e);
            if (null != jedis) {
                pool.returnBrokenResource((Object)jedis);
            }
        }
        finally {
            if (null != jedis) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    public static <T> T get(String key) {
        return (T)JedisSentinelKit.call(jedis -> {
            String result = null;
            byte[] retVal = jedis.get(SafeEncoder.encode((String)key));
            if (null != retVal) {
                try {
                    result = (String)KryoRedisSerializer.deserialize(retVal);
                }
                catch (Exception e) {
                    result = SafeEncoder.encode((byte[])retVal);
                }
            }
            return result;
        });
    }

    public static Long ttl(String key) {
        return JedisSentinelKit.call(jedis -> jedis.ttl(SafeEncoder.encode((String)key)));
    }

    public static Long expire(String key, int seconds) {
        return JedisSentinelKit.call(jedis -> jedis.expire(SafeEncoder.encode((String)key), seconds));
    }

    public static boolean set(String key, Object value) {
        return JedisSentinelKit.call(jedis -> {
            String retVal = value instanceof String ? jedis.set(key, (String)value) : jedis.set(SafeEncoder.encode((String)key), KryoRedisSerializer.serialize(value));
            return SUCCESS.equalsIgnoreCase(retVal);
        });
    }

    public static boolean set(String key, Object value, int seconds) {
        return JedisSentinelKit.call(jedis -> {
            byte[] bytes = value instanceof String ? SafeEncoder.encode((String)((String)value)) : KryoRedisSerializer.serialize(value);
            String retVal = jedis.setex(SafeEncoder.encode((String)key), seconds, bytes);
            return SUCCESS.equalsIgnoreCase(retVal);
        });
    }

    public static List mquery(String ... keys) {
        return JedisSentinelKit.call(jedis -> {
            ArrayList result = Lists.newArrayListWithCapacity((int)keys.length);
            for (int index = 0; index < keys.length; ++index) {
                result.add(null);
            }
            byte[][] encodeKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                encodeKeys[i] = SafeEncoder.encode((String)keys[i]);
            }
            List retVals = jedis.mget((byte[][])encodeKeys);
            if (null != retVals) {
                int index = 0;
                for (byte[] val : retVals) {
                    if (null != val) {
                        result.set(index, KryoRedisSerializer.deserialize(val));
                    }
                    ++index;
                }
            }
            return result;
        });
    }

    public static List<String> mqueryStr(String ... keys) {
        return JedisSentinelKit.call(jedis -> jedis.mget(keys));
    }

    public static boolean msaveOrUpdate(Map<String, Object> values) {
        return JedisSentinelKit.call(jedis -> {
            byte[][] encodeValues = new byte[values.size() * 2][];
            int index = 0;
            for (Map.Entry entry : values.entrySet()) {
                encodeValues[index++] = ((String)entry.getKey()).getBytes();
                encodeValues[index++] = KryoRedisSerializer.serialize(entry.getValue());
            }
            String retVal = jedis.mset((byte[][])encodeValues);
            return SUCCESS.equalsIgnoreCase(retVal);
        });
    }

    public static boolean msaveOrUpdateStr(Map<String, String> values) {
        return JedisSentinelKit.call(jedis -> {
            Iterator iter = values.entrySet().iterator();
            int index = 0;
            String[] encodeValues = new String[values.size() * 2];
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                encodeValues[index++] = (String)entry.getKey();
                encodeValues[index++] = (String)entry.getValue();
            }
            return SUCCESS.equalsIgnoreCase(jedis.mset(encodeValues));
        });
    }

    public static Set<String> keys(String pattern) {
        return JedisSentinelKit.call(jedis -> jedis.keys(pattern));
    }

    public static long del(String ... keys) {
        return JedisSentinelKit.call(jedis -> {
            byte[][] encodeKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                encodeKeys[i] = SafeEncoder.encode((String)keys[i]);
            }
            return jedis.del((byte[][])encodeKeys);
        });
    }

    public static long listAdd(String key, Object value) {
        return JedisSentinelKit.call(jedis -> jedis.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{KryoRedisSerializer.serialize(value)}));
    }

    public static long listAddFirst(String key, Object value) {
        return JedisSentinelKit.call(jedis -> jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{KryoRedisSerializer.serialize(value)}));
    }

    public static String type(String key) {
        return JedisSentinelKit.call(jedis -> jedis.type(SafeEncoder.encode((String)key)));
    }

    public static List queryList(String key, int start, int end) {
        return JedisSentinelKit.call(jedis -> {
            ArrayList result = Lists.newArrayList();
            List retVals = jedis.lrange(SafeEncoder.encode((String)key), (long)start, (long)end);
            if (retVals != null) {
                for (byte[] val : retVals) {
                    if (null == val) continue;
                    result.add(KryoRedisSerializer.deserialize(val));
                }
            }
            return result;
        });
    }

    public static long listSize(String key) {
        return JedisSentinelKit.call(jedis -> jedis.llen(SafeEncoder.encode((String)key)));
    }

    public static boolean listTrim(String key, int start, int end) {
        return JedisSentinelKit.call(jedis -> SUCCESS.equalsIgnoreCase(jedis.ltrim(SafeEncoder.encode((String)key), (long)start, (long)end)));
    }

    public static long incrementAndGet(String key) {
        return JedisSentinelKit.call(jedis -> jedis.incr(key));
    }

    public static long decrementAndGet(String key) {
        return JedisSentinelKit.call(jedis -> jedis.decr(key));
    }

    public static long queryLong(String key) {
        return JedisSentinelKit.call(jedis -> Long.valueOf(jedis.get(key)));
    }

    public static boolean hmset(String key, Map<String, String> values) {
        return JedisSentinelKit.call(jedis -> SUCCESS.equals(jedis.hmset(key, values)));
    }

    public static List<String> hvals(String key) {
        return JedisSentinelKit.call(jedis -> jedis.hvals(key));
    }

    public static boolean exists(String key) {
        return JedisSentinelKit.call(jedis -> jedis.exists(key));
    }

    public static List<String> hmget(String key, String ... fields) {
        return JedisSentinelKit.call(jedis -> jedis.hmget(key, fields));
    }

    public static Double zincrby(String key, double score, String member) {
        return JedisSentinelKit.call(jedis -> jedis.zincrby(key, score, member));
    }

    public static Double zscore(String key, String score) {
        return JedisSentinelKit.call(jedis -> jedis.zscore(key, score));
    }

    public static Long zadd(String key, double score, String member) {
        return JedisSentinelKit.call(jedis -> jedis.zadd(key, score, member));
    }

    public static Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return JedisSentinelKit.call(jedis -> jedis.zrangeWithScores(key, start, end));
    }

    public static String watch(String ... keys) {
        return JedisSentinelKit.call(jedis -> jedis.watch(keys));
    }

    public static Long lpush(String key, Object value) {
        return JedisSentinelKit.call(jedis -> {
            Long retVal = value instanceof String ? jedis.lpush(key, new String[]{(String)value}) : jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{KryoRedisSerializer.serialize(value)});
            return retVal;
        });
    }

    public static <T> T rpop(String key) {
        return (T)JedisSentinelKit.call(jedis -> {
            String result = null;
            byte[] retVal = jedis.rpop(SafeEncoder.encode((String)key));
            if (null != retVal) {
                try {
                    result = (String)KryoRedisSerializer.deserialize(retVal);
                }
                catch (Exception e) {
                    result = SafeEncoder.encode((byte[])retVal);
                }
            }
            return result;
        });
    }

    public static List lrange(String key, long start, long end) {
        return JedisSentinelKit.call(jedis -> {
            ArrayList list = Lists.newArrayList();
            byte[] result = jedis.lpop(SafeEncoder.encode((String)key));
            if (result == null) {
                return null;
            }
            try {
                list.add(KryoRedisSerializer.deserialize(result));
            }
            catch (Exception e) {
                list.add(SafeEncoder.encode((byte[])result));
            }
            return list;
        });
    }

    public static <T> T rpoplpush(String srckey, String dstkey) {
        return (T)JedisSentinelKit.call(jedis -> {
            String result = null;
            byte[] retVal = jedis.rpoplpush(SafeEncoder.encode((String)srckey), SafeEncoder.encode((String)dstkey));
            if (null != retVal) {
                try {
                    result = (String)KryoRedisSerializer.deserialize(retVal);
                }
                catch (Exception e) {
                    result = SafeEncoder.encode((byte[])retVal);
                }
            }
            return result;
        });
    }

    public static Long lrem(String key, Object value) {
        return JedisSentinelKit.lrem(key, 1L, value);
    }

    public static Long lrem(String key, long count, Object value) {
        return JedisSentinelKit.call(jedis -> {
            Long retVal = value instanceof String ? jedis.lrem(key, count, (String)value) : jedis.lrem(SafeEncoder.encode((String)key), count, KryoRedisSerializer.serialize(value));
            return retVal;
        });
    }
}

