/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.cache;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.util.SafeEncoder;
import tech.iooo.boot.cache.Cacheable;
import tech.iooo.boot.cache.ClusterRedisConfig;
import tech.iooo.boot.cache.utils.KryoRedisSerializer;

public class JedisClusterCacheable<T>
implements Cacheable<T> {
    private JedisCluster jedisCluster;

    public void init(ClusterRedisConfig clusterRedisConfig) {
        this.jedisCluster = new JedisCluster(clusterRedisConfig.getCluster(), clusterRedisConfig.getTimeOut(), clusterRedisConfig.getMaxAttempts(), (GenericObjectPoolConfig)clusterRedisConfig.getJedisPoolConfig());
    }

    @Override
    public T get(String key) {
        String result = null;
        byte[] retVal = this.jedisCluster.get(SafeEncoder.encode((String)key));
        if (null != retVal) {
            try {
                result = (String)KryoRedisSerializer.deserialize(retVal);
            }
            catch (Exception e) {
                result = SafeEncoder.encode((byte[])retVal);
            }
        }
        return (T)result;
    }

    @Override
    public Set<String> keys(String pattern) {
        HashSet keys = Sets.newHashSet();
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis jedis = jp.getResource();
            keys.addAll(jedis.keys(pattern));
            jedis.close();
        }
        return keys;
    }

    @Override
    public boolean set(String key, T value) {
        if (value instanceof String) {
            String retVal = this.jedisCluster.set(key, (String)value);
        } else {
            String retVal = this.jedisCluster.set(SafeEncoder.encode((String)key), KryoRedisSerializer.serialize(value));
        }
        return true;
    }

    @Override
    public boolean set(String key, T value, int timeout) {
        if (value instanceof String) {
            String retVal = this.jedisCluster.setex(key, timeout, (String)value);
        } else {
            String retVal = this.jedisCluster.setex(SafeEncoder.encode((String)key), timeout, KryoRedisSerializer.serialize(value));
        }
        return true;
    }

    @Override
    public long del(String key) {
        return this.jedisCluster.del(SafeEncoder.encode((String)key));
    }

    @Override
    public Long ttl(String key) {
        return this.jedisCluster.ttl(SafeEncoder.encode((String)key));
    }

    @Override
    public boolean hasKey(String key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.jedisCluster.expire(SafeEncoder.encode((String)key), seconds);
    }

    @Override
    public void delAll(String pattern) {
        this.keys(pattern).forEach(this::del);
    }
}

