/*
 * Decompiled with CFR 0.152.
 */
package tech.iooo.boot.cache;

import java.util.Collections;
import java.util.Set;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisPoolConfig;
import tech.iooo.boot.cache.Config;

public class ClusterRedisConfig
implements Config {
    private static final long serialVersionUID = -6024139246693242553L;
    private Set<HostAndPort> cluster = Collections.singleton(new HostAndPort("localhost", 6379));
    private String password;
    private int timeOut = 120;
    private int soTimeout = 120;
    private int maxAttempts = 6;
    private int maxTotal = 16;
    private int maxIdle = 8;
    private JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();

    public ClusterRedisConfig() {
        this.jedisPoolConfig.setMaxIdle(this.maxIdle);
        this.jedisPoolConfig.setMaxTotal(this.maxTotal);
    }

    public Set<HostAndPort> getCluster() {
        return this.cluster;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public void setCluster(Set<HostAndPort> cluster) {
        this.cluster = cluster;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setJedisPoolConfig(JedisPoolConfig jedisPoolConfig) {
        this.jedisPoolConfig = jedisPoolConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterRedisConfig)) {
            return false;
        }
        ClusterRedisConfig other = (ClusterRedisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<HostAndPort> this$cluster = this.getCluster();
        Set<HostAndPort> other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getTimeOut() != other.getTimeOut()) {
            return false;
        }
        if (this.getSoTimeout() != other.getSoTimeout()) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        JedisPoolConfig this$jedisPoolConfig = this.getJedisPoolConfig();
        JedisPoolConfig other$jedisPoolConfig = other.getJedisPoolConfig();
        return !(this$jedisPoolConfig == null ? other$jedisPoolConfig != null : !this$jedisPoolConfig.equals(other$jedisPoolConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterRedisConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<HostAndPort> $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getTimeOut();
        result = result * 59 + this.getSoTimeout();
        result = result * 59 + this.getMaxAttempts();
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getMaxIdle();
        JedisPoolConfig $jedisPoolConfig = this.getJedisPoolConfig();
        result = result * 59 + ($jedisPoolConfig == null ? 43 : $jedisPoolConfig.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterRedisConfig(cluster=" + this.getCluster() + ", password=" + this.getPassword() + ", timeOut=" + this.getTimeOut() + ", soTimeout=" + this.getSoTimeout() + ", maxAttempts=" + this.getMaxAttempts() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", jedisPoolConfig=" + this.getJedisPoolConfig() + ")";
    }
}

