/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import org.jetbrains.annotations.Nullable;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.bitmask.VkSparseMemoryBindFlags;
import tech.icey.vk4j.datatype.VkExtent3D;
import tech.icey.vk4j.datatype.VkImageSubresource;
import tech.icey.vk4j.datatype.VkOffset3D;
import tech.icey.vk4j.handle.VkDeviceMemory;

public record VkSparseImageMemoryBind(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{VkImageSubresource.LAYOUT.withName("subresource"), VkOffset3D.LAYOUT.withName("offset"), VkExtent3D.LAYOUT.withName("extent"), ValueLayout.ADDRESS.withName("memory"), ValueLayout.JAVA_LONG.withName("memoryOffset"), ValueLayout.JAVA_INT.withName("flags")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$subresource = MemoryLayout.PathElement.groupElement("subresource");
    public static final MemoryLayout.PathElement PATH$offset = MemoryLayout.PathElement.groupElement("offset");
    public static final MemoryLayout.PathElement PATH$extent = MemoryLayout.PathElement.groupElement("extent");
    public static final MemoryLayout.PathElement PATH$memory = MemoryLayout.PathElement.groupElement("memory");
    public static final MemoryLayout.PathElement PATH$memoryOffset = MemoryLayout.PathElement.groupElement("memoryOffset");
    public static final MemoryLayout.PathElement PATH$flags = MemoryLayout.PathElement.groupElement("flags");
    public static final StructLayout LAYOUT$subresource = (StructLayout)LAYOUT.select(PATH$subresource);
    public static final StructLayout LAYOUT$offset = (StructLayout)LAYOUT.select(PATH$offset);
    public static final StructLayout LAYOUT$extent = (StructLayout)LAYOUT.select(PATH$extent);
    public static final AddressLayout LAYOUT$memory = (AddressLayout)LAYOUT.select(PATH$memory);
    public static final ValueLayout.OfLong LAYOUT$memoryOffset = (ValueLayout.OfLong)LAYOUT.select(PATH$memoryOffset);
    public static final ValueLayout.OfInt LAYOUT$flags = (ValueLayout.OfInt)LAYOUT.select(PATH$flags);
    public static final long OFFSET$subresource = LAYOUT.byteOffset(PATH$subresource);
    public static final long OFFSET$offset = LAYOUT.byteOffset(PATH$offset);
    public static final long OFFSET$extent = LAYOUT.byteOffset(PATH$extent);
    public static final long OFFSET$memory = LAYOUT.byteOffset(PATH$memory);
    public static final long OFFSET$memoryOffset = LAYOUT.byteOffset(PATH$memoryOffset);
    public static final long OFFSET$flags = LAYOUT.byteOffset(PATH$flags);
    public static final long SIZE$subresource = LAYOUT$subresource.byteSize();
    public static final long SIZE$offset = LAYOUT$offset.byteSize();
    public static final long SIZE$extent = LAYOUT$extent.byteSize();
    public static final long SIZE$memory = LAYOUT$memory.byteSize();
    public static final long SIZE$memoryOffset = LAYOUT$memoryOffset.byteSize();
    public static final long SIZE$flags = LAYOUT$flags.byteSize();

    public VkImageSubresource subresource() {
        return new VkImageSubresource(this.segment.asSlice(OFFSET$subresource, LAYOUT$subresource));
    }

    public void subresource(VkImageSubresource value) {
        MemorySegment.copy(value.segment(), 0L, this.segment, OFFSET$subresource, SIZE$subresource);
    }

    public VkOffset3D offset() {
        return new VkOffset3D(this.segment.asSlice(OFFSET$offset, LAYOUT$offset));
    }

    public void offset(VkOffset3D value) {
        MemorySegment.copy(value.segment(), 0L, this.segment, OFFSET$offset, SIZE$offset);
    }

    public VkExtent3D extent() {
        return new VkExtent3D(this.segment.asSlice(OFFSET$extent, LAYOUT$extent));
    }

    public void extent(VkExtent3D value) {
        MemorySegment.copy(value.segment(), 0L, this.segment, OFFSET$extent, SIZE$extent);
    }

    @Nullable
    public VkDeviceMemory memory() {
        MemorySegment s = this.segment.get(LAYOUT$memory, OFFSET$memory);
        if (s.address() == 0L) {
            return null;
        }
        return new VkDeviceMemory(s);
    }

    public void memory(@Nullable VkDeviceMemory value) {
        this.segment.set(LAYOUT$memory, OFFSET$memory, value != null ? value.segment() : MemorySegment.NULL);
    }

    @unsigned
    public long memoryOffset() {
        return this.segment.get(LAYOUT$memoryOffset, OFFSET$memoryOffset);
    }

    public void memoryOffset(@unsigned long value) {
        this.segment.set(LAYOUT$memoryOffset, OFFSET$memoryOffset, value);
    }

    @enumtype(value=VkSparseMemoryBindFlags.class)
    public int flags() {
        return this.segment.get(LAYOUT$flags, OFFSET$flags);
    }

    public void flags(@enumtype(value=VkSparseMemoryBindFlags.class) int value) {
        this.segment.set(LAYOUT$flags, OFFSET$flags, value);
    }

    public static VkSparseImageMemoryBind allocate(Arena arena) {
        return new VkSparseImageMemoryBind(arena.allocate(LAYOUT));
    }

    public static VkSparseImageMemoryBind[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkSparseImageMemoryBind[] ret = new VkSparseImageMemoryBind[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkSparseImageMemoryBind(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkSparseImageMemoryBind clone(Arena arena, VkSparseImageMemoryBind src) {
        VkSparseImageMemoryBind ret = VkSparseImageMemoryBind.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkSparseImageMemoryBind[] clone(Arena arena, VkSparseImageMemoryBind[] src) {
        VkSparseImageMemoryBind[] ret = VkSparseImageMemoryBind.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

