/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.vk4j.datatype.VkExtent2D;
import tech.icey.vk4j.datatype.VkOffset2D;

public record VkRect2D(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{VkOffset2D.LAYOUT.withName("offset"), VkExtent2D.LAYOUT.withName("extent")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$offset = MemoryLayout.PathElement.groupElement("offset");
    public static final MemoryLayout.PathElement PATH$extent = MemoryLayout.PathElement.groupElement("extent");
    public static final StructLayout LAYOUT$offset = (StructLayout)LAYOUT.select(PATH$offset);
    public static final StructLayout LAYOUT$extent = (StructLayout)LAYOUT.select(PATH$extent);
    public static final long OFFSET$offset = LAYOUT.byteOffset(PATH$offset);
    public static final long OFFSET$extent = LAYOUT.byteOffset(PATH$extent);
    public static final long SIZE$offset = LAYOUT$offset.byteSize();
    public static final long SIZE$extent = LAYOUT$extent.byteSize();

    public VkOffset2D offset() {
        return new VkOffset2D(this.segment.asSlice(OFFSET$offset, LAYOUT$offset));
    }

    public void offset(VkOffset2D value) {
        MemorySegment.copy(value.segment(), 0L, this.segment, OFFSET$offset, SIZE$offset);
    }

    public VkExtent2D extent() {
        return new VkExtent2D(this.segment.asSlice(OFFSET$extent, LAYOUT$extent));
    }

    public void extent(VkExtent2D value) {
        MemorySegment.copy(value.segment(), 0L, this.segment, OFFSET$extent, SIZE$extent);
    }

    public static VkRect2D allocate(Arena arena) {
        return new VkRect2D(arena.allocate(LAYOUT));
    }

    public static VkRect2D[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkRect2D[] ret = new VkRect2D[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkRect2D(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkRect2D clone(Arena arena, VkRect2D src) {
        VkRect2D ret = VkRect2D.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkRect2D[] clone(Arena arena, VkRect2D[] src) {
        VkRect2D[] ret = VkRect2D.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

