package tech.icey.vk4j.enumtype;

import tech.icey.panama.annotation.enumtype;

public final class VkDeviceFaultAddressTypeEXT {
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT = 0;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT = 1;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT = 2;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT = 3;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT = 4;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT = 5;
    public static final int VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT = 6;

    public static String explain(@enumtype(VkDeviceFaultAddressTypeEXT.class) int value) {
        return switch (value) {
            case VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT";
            case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT -> "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT";
            default -> "Unknown";
        };
    }
}
