/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.datatype.VkMemoryHeap;
import tech.icey.vk4j.datatype.VkMemoryType;

public record VkPhysicalDeviceMemoryProperties(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_INT.withName("memoryTypeCount"), MemoryLayout.sequenceLayout(32L, VkMemoryType.LAYOUT).withName("memoryTypes"), ValueLayout.JAVA_INT.withName("memoryHeapCount"), MemoryLayout.sequenceLayout(16L, VkMemoryHeap.LAYOUT).withName("memoryHeaps")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$memoryTypeCount = MemoryLayout.PathElement.groupElement("memoryTypeCount");
    public static final MemoryLayout.PathElement PATH$memoryTypes = MemoryLayout.PathElement.groupElement("memoryTypes");
    public static final MemoryLayout.PathElement PATH$memoryHeapCount = MemoryLayout.PathElement.groupElement("memoryHeapCount");
    public static final MemoryLayout.PathElement PATH$memoryHeaps = MemoryLayout.PathElement.groupElement("memoryHeaps");
    public static final ValueLayout.OfInt LAYOUT$memoryTypeCount = (ValueLayout.OfInt)LAYOUT.select(PATH$memoryTypeCount);
    public static final SequenceLayout LAYOUT$memoryTypes = (SequenceLayout)LAYOUT.select(PATH$memoryTypes);
    public static final ValueLayout.OfInt LAYOUT$memoryHeapCount = (ValueLayout.OfInt)LAYOUT.select(PATH$memoryHeapCount);
    public static final SequenceLayout LAYOUT$memoryHeaps = (SequenceLayout)LAYOUT.select(PATH$memoryHeaps);
    public static final long OFFSET$memoryTypeCount = LAYOUT.byteOffset(PATH$memoryTypeCount);
    public static final long OFFSET$memoryTypes = LAYOUT.byteOffset(PATH$memoryTypes);
    public static final long OFFSET$memoryHeapCount = LAYOUT.byteOffset(PATH$memoryHeapCount);
    public static final long OFFSET$memoryHeaps = LAYOUT.byteOffset(PATH$memoryHeaps);
    public static final long SIZE$memoryTypeCount = LAYOUT$memoryTypeCount.byteSize();
    public static final long SIZE$memoryTypes = LAYOUT$memoryTypes.byteSize();
    public static final long SIZE$memoryHeapCount = LAYOUT$memoryHeapCount.byteSize();
    public static final long SIZE$memoryHeaps = LAYOUT$memoryHeaps.byteSize();

    @unsigned
    public int memoryTypeCount() {
        return this.segment.get(LAYOUT$memoryTypeCount, OFFSET$memoryTypeCount);
    }

    public void memoryTypeCount(@unsigned int value) {
        this.segment.set(LAYOUT$memoryTypeCount, OFFSET$memoryTypeCount, value);
    }

    public MemorySegment memoryTypesRaw() {
        return this.segment.asSlice(OFFSET$memoryTypes, SIZE$memoryTypes);
    }

    public VkMemoryType[] memoryTypes() {
        MemorySegment s = this.memoryTypesRaw();
        VkMemoryType[] arr = new VkMemoryType[(int)LAYOUT$memoryTypes.elementCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new VkMemoryType(s.asSlice((long)i * VkMemoryType.SIZE, VkMemoryType.SIZE));
        }
        return arr;
    }

    public void memoryTypes(VkMemoryType[] value) {
        MemorySegment s = this.memoryTypesRaw();
        for (int i = 0; i < value.length; ++i) {
            MemorySegment.copy(value[i].segment(), 0L, s, (long)i * VkMemoryType.SIZE, VkMemoryType.SIZE);
        }
    }

    public VkMemoryType memoryTypesAt(long index) {
        MemorySegment s = this.memoryTypesRaw();
        return new VkMemoryType(s.asSlice(index * VkMemoryType.SIZE, VkMemoryType.SIZE));
    }

    public void memoryTypesAt(long index, VkMemoryType value) {
        MemorySegment s = this.memoryTypesRaw();
        MemorySegment.copy(value.segment(), 0L, s, index * VkMemoryType.SIZE, VkMemoryType.SIZE);
    }

    @unsigned
    public int memoryHeapCount() {
        return this.segment.get(LAYOUT$memoryHeapCount, OFFSET$memoryHeapCount);
    }

    public void memoryHeapCount(@unsigned int value) {
        this.segment.set(LAYOUT$memoryHeapCount, OFFSET$memoryHeapCount, value);
    }

    public MemorySegment memoryHeapsRaw() {
        return this.segment.asSlice(OFFSET$memoryHeaps, SIZE$memoryHeaps);
    }

    public VkMemoryHeap[] memoryHeaps() {
        MemorySegment s = this.memoryHeapsRaw();
        VkMemoryHeap[] arr = new VkMemoryHeap[(int)LAYOUT$memoryHeaps.elementCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new VkMemoryHeap(s.asSlice((long)i * VkMemoryHeap.SIZE, VkMemoryHeap.SIZE));
        }
        return arr;
    }

    public void memoryHeaps(VkMemoryHeap[] value) {
        MemorySegment s = this.memoryHeapsRaw();
        for (int i = 0; i < value.length; ++i) {
            MemorySegment.copy(value[i].segment(), 0L, s, (long)i * VkMemoryHeap.SIZE, VkMemoryHeap.SIZE);
        }
    }

    public VkMemoryHeap memoryHeapsAt(long index) {
        MemorySegment s = this.memoryHeapsRaw();
        return new VkMemoryHeap(s.asSlice(index * VkMemoryHeap.SIZE, VkMemoryHeap.SIZE));
    }

    public void memoryHeapsAt(long index, VkMemoryHeap value) {
        MemorySegment s = this.memoryHeapsRaw();
        MemorySegment.copy(value.segment(), 0L, s, index * VkMemoryHeap.SIZE, VkMemoryHeap.SIZE);
    }

    public static VkPhysicalDeviceMemoryProperties allocate(Arena arena) {
        return new VkPhysicalDeviceMemoryProperties(arena.allocate(LAYOUT));
    }

    public static VkPhysicalDeviceMemoryProperties[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkPhysicalDeviceMemoryProperties[] ret = new VkPhysicalDeviceMemoryProperties[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkPhysicalDeviceMemoryProperties(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkPhysicalDeviceMemoryProperties clone(Arena arena, VkPhysicalDeviceMemoryProperties src) {
        VkPhysicalDeviceMemoryProperties ret = VkPhysicalDeviceMemoryProperties.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkPhysicalDeviceMemoryProperties[] clone(Arena arena, VkPhysicalDeviceMemoryProperties[] src) {
        VkPhysicalDeviceMemoryProperties[] ret = VkPhysicalDeviceMemoryProperties.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

