/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.bitmask.VkMemoryHeapFlags;

public record VkMemoryHeap(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_LONG.withName("size"), ValueLayout.JAVA_INT.withName("flags")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$size = MemoryLayout.PathElement.groupElement("size");
    public static final MemoryLayout.PathElement PATH$flags = MemoryLayout.PathElement.groupElement("flags");
    public static final ValueLayout.OfLong LAYOUT$size = (ValueLayout.OfLong)LAYOUT.select(PATH$size);
    public static final ValueLayout.OfInt LAYOUT$flags = (ValueLayout.OfInt)LAYOUT.select(PATH$flags);
    public static final long OFFSET$size = LAYOUT.byteOffset(PATH$size);
    public static final long OFFSET$flags = LAYOUT.byteOffset(PATH$flags);
    public static final long SIZE$size = LAYOUT$size.byteSize();
    public static final long SIZE$flags = LAYOUT$flags.byteSize();

    @unsigned
    public long size() {
        return this.segment.get(LAYOUT$size, OFFSET$size);
    }

    public void size(@unsigned long value) {
        this.segment.set(LAYOUT$size, OFFSET$size, value);
    }

    @enumtype(value=VkMemoryHeapFlags.class)
    public int flags() {
        return this.segment.get(LAYOUT$flags, OFFSET$flags);
    }

    public void flags(@enumtype(value=VkMemoryHeapFlags.class) int value) {
        this.segment.set(LAYOUT$flags, OFFSET$flags, value);
    }

    public static VkMemoryHeap allocate(Arena arena) {
        return new VkMemoryHeap(arena.allocate(LAYOUT));
    }

    public static VkMemoryHeap[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkMemoryHeap[] ret = new VkMemoryHeap[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkMemoryHeap(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkMemoryHeap clone(Arena arena, VkMemoryHeap src) {
        VkMemoryHeap ret = VkMemoryHeap.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkMemoryHeap[] clone(Arena arena, VkMemoryHeap[] src) {
        VkMemoryHeap[] ret = VkMemoryHeap.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

