/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.jetbrains.annotations.Nullable;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.handle.VkBuffer;

public record VkDescriptorBufferInfo(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS.withName("buffer"), ValueLayout.JAVA_LONG.withName("offset"), ValueLayout.JAVA_LONG.withName("range")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$buffer = MemoryLayout.PathElement.groupElement("buffer");
    public static final MemoryLayout.PathElement PATH$offset = MemoryLayout.PathElement.groupElement("offset");
    public static final MemoryLayout.PathElement PATH$range = MemoryLayout.PathElement.groupElement("range");
    public static final AddressLayout LAYOUT$buffer = (AddressLayout)LAYOUT.select(PATH$buffer);
    public static final ValueLayout.OfLong LAYOUT$offset = (ValueLayout.OfLong)LAYOUT.select(PATH$offset);
    public static final ValueLayout.OfLong LAYOUT$range = (ValueLayout.OfLong)LAYOUT.select(PATH$range);
    public static final long OFFSET$buffer = LAYOUT.byteOffset(PATH$buffer);
    public static final long OFFSET$offset = LAYOUT.byteOffset(PATH$offset);
    public static final long OFFSET$range = LAYOUT.byteOffset(PATH$range);
    public static final long SIZE$buffer = LAYOUT$buffer.byteSize();
    public static final long SIZE$offset = LAYOUT$offset.byteSize();
    public static final long SIZE$range = LAYOUT$range.byteSize();

    @Nullable
    public VkBuffer buffer() {
        MemorySegment s = this.segment.get(LAYOUT$buffer, OFFSET$buffer);
        if (s.address() == 0L) {
            return null;
        }
        return new VkBuffer(s);
    }

    public void buffer(@Nullable VkBuffer value) {
        this.segment.set(LAYOUT$buffer, OFFSET$buffer, value != null ? value.segment() : MemorySegment.NULL);
    }

    @unsigned
    public long offset() {
        return this.segment.get(LAYOUT$offset, OFFSET$offset);
    }

    public void offset(@unsigned long value) {
        this.segment.set(LAYOUT$offset, OFFSET$offset, value);
    }

    @unsigned
    public long range() {
        return this.segment.get(LAYOUT$range, OFFSET$range);
    }

    public void range(@unsigned long value) {
        this.segment.set(LAYOUT$range, OFFSET$range, value);
    }

    public static VkDescriptorBufferInfo allocate(Arena arena) {
        return new VkDescriptorBufferInfo(arena.allocate(LAYOUT));
    }

    public static VkDescriptorBufferInfo[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkDescriptorBufferInfo[] ret = new VkDescriptorBufferInfo[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkDescriptorBufferInfo(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkDescriptorBufferInfo clone(Arena arena, VkDescriptorBufferInfo src) {
        VkDescriptorBufferInfo ret = VkDescriptorBufferInfo.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkDescriptorBufferInfo[] clone(Arena arena, VkDescriptorBufferInfo[] src) {
        VkDescriptorBufferInfo[] ret = VkDescriptorBufferInfo.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

