/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import tech.icey.panama.Loader;
import tech.icey.panama.buffer.ByteBuffer;
import tech.icey.vk4j.command.DeviceCommands;
import tech.icey.vk4j.command.EntryCommands;
import tech.icey.vk4j.command.InstanceCommands;
import tech.icey.vk4j.command.StaticCommands;
import tech.icey.vk4j.handle.VkDevice;
import tech.icey.vk4j.handle.VkInstance;

public final class VulkanLoader {
    public static void loadVulkanLibrary() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            System.loadLibrary("vulkan-1");
        } else {
            System.loadLibrary("vulkan");
        }
    }

    public static StaticCommands loadStaticCommands() {
        return new StaticCommands(Loader::loadFunction);
    }

    public static EntryCommands loadEntryCommands() {
        return new EntryCommands(Loader::loadFunction);
    }

    public static InstanceCommands loadInstanceCommands(VkInstance instance, StaticCommands staticCommands) {
        return new InstanceCommands(name -> {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment memorySegment = staticCommands.vkGetInstanceProcAddr(instance, ByteBuffer.allocateString((Arena)arena, (String)name));
                return memorySegment;
            }
        });
    }

    public static DeviceCommands loadDeviceCommands(VkInstance instance, VkDevice device, StaticCommands staticCommands) {
        return new DeviceCommands(name -> {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment memorySegment = staticCommands.vkGetDeviceProcAddr(device, ByteBuffer.allocateString((Arena)arena, (String)name));
                return memorySegment;
            }
        }, name -> {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment memorySegment = staticCommands.vkGetInstanceProcAddr(instance, ByteBuffer.allocateString((Arena)arena, (String)name));
                return memorySegment;
            }
        });
    }
}

