/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.pointer;
import tech.icey.panama.buffer.ByteBuffer;
import tech.icey.panama.buffer.FloatBuffer;
import tech.icey.vk4j.bitmask.VkDebugUtilsMessageSeverityFlagsEXT;
import tech.icey.vk4j.bitmask.VkDebugUtilsMessageTypeFlagsEXT;
import tech.icey.vk4j.datatype.VkDebugUtilsLabelEXT;
import tech.icey.vk4j.datatype.VkDebugUtilsMessengerCallbackDataEXT;
import tech.icey.vk4j.datatype.VkDebugUtilsObjectNameInfoEXT;
import tech.icey.vk4j.enumtype.VkObjectType;

public final class DebugCallback {
    public static final MemorySegment pDebugCallback;

    private static int debugCallback(@enumtype(value=VkDebugUtilsMessageSeverityFlagsEXT.class) int messageSeverity, @enumtype(value=VkDebugUtilsMessageTypeFlagsEXT.class) int messageType, @pointer(target=VkDebugUtilsMessengerCallbackDataEXT.class) MemorySegment pCallbackData, @pointer(comment="void*") MemorySegment ignoredPUserData) {
        int i;
        pCallbackData = pCallbackData.reinterpret(VkDebugUtilsMessengerCallbackDataEXT.LAYOUT.byteSize());
        VkDebugUtilsMessengerCallbackDataEXT callbackData = new VkDebugUtilsMessengerCallbackDataEXT(pCallbackData);
        Object prefix = (messageSeverity & 1) != 0 ? "VERBOSE : " : ((messageSeverity & 0x10) != 0 ? "INFO : " : ((messageSeverity & 0x100) != 0 ? "WARNING : " : ((messageSeverity & 0x1000) != 0 ? "ERROR : " : "UNKNOWN")));
        if ((messageType & 1) != 0) {
            prefix = (String)prefix + "GENERAL";
        } else {
            if ((messageType & 2) != 0) {
                prefix = (String)prefix + "VALIDATION";
            }
            if ((messageType & 4) != 0) {
                if ((messageType & 2) != 0) {
                    prefix = (String)prefix + "|";
                }
                prefix = (String)prefix + "PERFORMANCE";
            }
        }
        ByteBuffer messageIdName = callbackData.pMessageIdName();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(String.format("%s - Message Id Number: %d | Message Id Name: %s\n\t%s\n", prefix, callbackData.messageIdNumber(), messageIdName != null ? messageIdName.readString() : "(null)", Objects.requireNonNull(callbackData.pMessage()).readString()));
        if (callbackData.objectCount() > 0) {
            messageBuilder.append(String.format("\tObjects - %s\n", Integer.toUnsignedString(callbackData.objectCount())));
            VkDebugUtilsObjectNameInfoEXT[] objects = Objects.requireNonNull(callbackData.pObjects(callbackData.objectCount()));
            for (i = 0; i < callbackData.objectCount(); ++i) {
                VkDebugUtilsObjectNameInfoEXT object = objects[i];
                messageBuilder.append(String.format("\t\tObject[%d] - %s", i, VkObjectType.explain(object.objectType())));
                messageBuilder.append(String.format(", handle = 0x%s", Long.toUnsignedString(object.objectHandle(), 16)));
                ByteBuffer objectName = object.pObjectName();
                if (objectName != null) {
                    messageBuilder.append(String.format(", name = %s", objectName.readString()));
                }
                messageBuilder.append("\n");
            }
        }
        if (callbackData.cmdBufLabelCount() > 0) {
            messageBuilder.append(String.format("\tCommand Buffer Labels - %s\n", Integer.toUnsignedString(callbackData.cmdBufLabelCount())));
            VkDebugUtilsLabelEXT[] labels = Objects.requireNonNull(callbackData.pCmdBufLabels(callbackData.cmdBufLabelCount()));
            for (i = 0; i < callbackData.cmdBufLabelCount(); ++i) {
                VkDebugUtilsLabelEXT label = labels[i];
                messageBuilder.append(String.format("\t\tLabel[%d] - %s", i, Objects.requireNonNull(label.pLabelName()).readString()));
                FloatBuffer color = label.color();
                messageBuilder.append(String.format(" { %.2f, %.2f, %.2f, %.2f }\n", Float.valueOf(color.read(0L)), Float.valueOf(color.read(1L)), Float.valueOf(color.read(2L)), Float.valueOf(color.read(3L))));
            }
        }
        System.err.print(messageBuilder);
        return 0;
    }

    static {
        try {
            FunctionDescriptor descriptor = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS.withTargetLayout(VkDebugUtilsMessengerCallbackDataEXT.LAYOUT), ValueLayout.ADDRESS);
            MethodHandle handle = MethodHandles.lookup().findStatic(DebugCallback.class, "debugCallback", descriptor.toMethodType());
            pDebugCallback = Linker.nativeLinker().upcallStub(handle, descriptor, Arena.global(), new Linker.Option[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

