package tech.icey.vk4j.enumtype;

import tech.icey.panama.annotation.enumtype;

public final class VkPrimitiveTopology {
    public static final int VK_PRIMITIVE_TOPOLOGY_POINT_LIST = 0;
    public static final int VK_PRIMITIVE_TOPOLOGY_LINE_LIST = 1;
    public static final int VK_PRIMITIVE_TOPOLOGY_LINE_STRIP = 2;
    public static final int VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST = 3;
    public static final int VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP = 4;
    public static final int VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN = 5;
    public static final int VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY = 6;
    public static final int VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY = 7;
    public static final int VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY = 8;
    public static final int VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY = 9;
    public static final int VK_PRIMITIVE_TOPOLOGY_PATCH_LIST = 10;

    public static String explain(@enumtype(VkPrimitiveTopology.class) int value) {
        return switch (value) {
            case VK_PRIMITIVE_TOPOLOGY_POINT_LIST -> "VK_PRIMITIVE_TOPOLOGY_POINT_LIST";
            case VK_PRIMITIVE_TOPOLOGY_LINE_LIST -> "VK_PRIMITIVE_TOPOLOGY_LINE_LIST";
            case VK_PRIMITIVE_TOPOLOGY_LINE_STRIP -> "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP";
            case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST -> "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST";
            case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP -> "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP";
            case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN -> "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN";
            case VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY -> "VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY";
            case VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY -> "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY";
            case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY -> "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY";
            case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY -> "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY";
            case VK_PRIMITIVE_TOPOLOGY_PATCH_LIST -> "VK_PRIMITIVE_TOPOLOGY_PATCH_LIST";
            default -> "Unknown";
        };
    }
}
