package tech.icey.vk4j.datatype;

import java.lang.foreign.*;
import static java.lang.foreign.ValueLayout.*;

import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.*;
import tech.icey.panama.buffer.*;
import tech.icey.vk4j.bitmask.*;
import tech.icey.vk4j.datatype.*;
import tech.icey.vk4j.enumtype.*;
import tech.icey.vk4j.handle.*;
import static tech.icey.vk4j.Constants.*;
import static tech.icey.vk4j.enumtype.VkStructureType.*;

/// {@snippet lang=c :
/// typedef struct VkSemaphoreTypeCreateInfo {
///     VkStructureType sType;
///     const void* pNext;
///     VkSemaphoreType semaphoreType;
///     uint64_t initialValue;
/// } VkSemaphoreTypeCreateInfo;}
///
/// @see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkSemaphoreTypeCreateInfo.html">VkSemaphoreTypeCreateInfo</a>
public record VkSemaphoreTypeCreateInfo(MemorySegment segment) implements IPointer {
    public VkSemaphoreTypeCreateInfo(MemorySegment segment) {
        this.segment = segment;
        this.sType(VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO);
    }

    public @enumtype(VkStructureType.class) int sType() {
        return segment.get(LAYOUT$sType, OFFSET$sType);
    }

    public void sType(@enumtype(VkStructureType.class) int value) {
        segment.set(LAYOUT$sType, OFFSET$sType, value);
    }

    public @pointer(comment="void*") MemorySegment pNext() {
        return segment.get(LAYOUT$pNext, OFFSET$pNext);
    }

    public void pNext(@pointer(comment="void*") MemorySegment value) {
        segment.set(LAYOUT$pNext, OFFSET$pNext, value);
    }

    public void pNext(@nullable IPointer pointer) {
        pNext(pointer == null ? MemorySegment.NULL : pointer.segment());
    }

    public @enumtype(VkSemaphoreType.class) int semaphoreType() {
        return segment.get(LAYOUT$semaphoreType, OFFSET$semaphoreType);
    }

    public void semaphoreType(@enumtype(VkSemaphoreType.class) int value) {
        segment.set(LAYOUT$semaphoreType, OFFSET$semaphoreType, value);
    }

    public @unsigned long initialValue() {
        return segment.get(LAYOUT$initialValue, OFFSET$initialValue);
    }

    public void initialValue(@unsigned long value) {
        segment.set(LAYOUT$initialValue, OFFSET$initialValue, value);
    }

    public static VkSemaphoreTypeCreateInfo allocate(Arena arena) {
        return new VkSemaphoreTypeCreateInfo(arena.allocate(LAYOUT));
    }

    public static VkSemaphoreTypeCreateInfo[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkSemaphoreTypeCreateInfo[] ret = new VkSemaphoreTypeCreateInfo[count];
        for (int i = 0; i < count; i++) {
            ret[i] = new VkSemaphoreTypeCreateInfo(segment.asSlice(i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkSemaphoreTypeCreateInfo clone(Arena arena, VkSemaphoreTypeCreateInfo src) {
        VkSemaphoreTypeCreateInfo ret = allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkSemaphoreTypeCreateInfo[] clone(Arena arena, VkSemaphoreTypeCreateInfo[] src) {
        VkSemaphoreTypeCreateInfo[] ret = allocate(arena, src.length);
        for (int i = 0; i < src.length; i++) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }

    public static final MemoryLayout LAYOUT = NativeLayout.structLayout(
        ValueLayout.JAVA_INT.withName("sType"),
        ValueLayout.ADDRESS.withName("pNext"),
        ValueLayout.JAVA_INT.withName("semaphoreType"),
        ValueLayout.JAVA_LONG.withName("initialValue")
    );
    public static final long SIZE = LAYOUT.byteSize();

    public static final PathElement PATH$sType = PathElement.groupElement("sType");
    public static final PathElement PATH$pNext = PathElement.groupElement("pNext");
    public static final PathElement PATH$semaphoreType = PathElement.groupElement("semaphoreType");
    public static final PathElement PATH$initialValue = PathElement.groupElement("initialValue");

    public static final OfInt LAYOUT$sType = (OfInt) LAYOUT.select(PATH$sType);
    public static final AddressLayout LAYOUT$pNext = (AddressLayout) LAYOUT.select(PATH$pNext);
    public static final OfInt LAYOUT$semaphoreType = (OfInt) LAYOUT.select(PATH$semaphoreType);
    public static final OfLong LAYOUT$initialValue = (OfLong) LAYOUT.select(PATH$initialValue);

    public static final long OFFSET$sType = LAYOUT.byteOffset(PATH$sType);
    public static final long OFFSET$pNext = LAYOUT.byteOffset(PATH$pNext);
    public static final long OFFSET$semaphoreType = LAYOUT.byteOffset(PATH$semaphoreType);
    public static final long OFFSET$initialValue = LAYOUT.byteOffset(PATH$initialValue);

    public static final long SIZE$sType = LAYOUT$sType.byteSize();
    public static final long SIZE$pNext = LAYOUT$pNext.byteSize();
    public static final long SIZE$semaphoreType = LAYOUT$semaphoreType.byteSize();
    public static final long SIZE$initialValue = LAYOUT$initialValue.byteSize();
}
