package tech.icey.vk4j;

import tech.icey.panama.annotation.*;

public final class Constants {
    public static final @unsigned long VK_MAX_PHYSICAL_DEVICE_NAME_SIZE = 256;
    public static final @unsigned long VK_UUID_SIZE = 16;
    public static final @unsigned long VK_LUID_SIZE = 8;
    public static final @unsigned long VK_MAX_EXTENSION_NAME_SIZE = 256;
    public static final @unsigned long VK_MAX_DESCRIPTION_SIZE = 256;
    public static final @unsigned long VK_MAX_MEMORY_TYPES = 32;
    public static final @unsigned long VK_MAX_MEMORY_HEAPS = 16;
    public static final float VK_LOD_CLAMP_NONE = 1000.0F;
    public static final @unsigned int VK_REMAINING_MIP_LEVELS = (~0);
    public static final @unsigned int VK_REMAINING_ARRAY_LAYERS = (~0);
    public static final @unsigned int VK_REMAINING_3D_SLICES_EXT = (~0);
    public static final @unsigned long VK_WHOLE_SIZE = (~0);
    public static final @unsigned int VK_ATTACHMENT_UNUSED = (~0);
    public static final @unsigned int VK_TRUE = 1;
    public static final @unsigned int VK_FALSE = 0;
    public static final @unsigned int VK_QUEUE_FAMILY_IGNORED = (~0);
    public static final @unsigned int VK_QUEUE_FAMILY_EXTERNAL = (~1);
    public static final @unsigned int VK_QUEUE_FAMILY_FOREIGN_EXT = (~2);
    public static final @unsigned int VK_SUBPASS_EXTERNAL = (~0);
    public static final @unsigned long VK_MAX_DEVICE_GROUP_SIZE = 32;
    public static final @unsigned long VK_MAX_DRIVER_NAME_SIZE = 256;
    public static final @unsigned long VK_MAX_DRIVER_INFO_SIZE = 256;
    public static final @unsigned int VK_SHADER_UNUSED_KHR = (~0);
    public static final @unsigned long VK_MAX_GLOBAL_PRIORITY_SIZE_KHR = 16;
    public static final @unsigned long VK_MAX_SHADER_MODULE_IDENTIFIER_SIZE_EXT = 32;
    public static final @unsigned long VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR = 32;
    public static final @unsigned long VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR = 7;
    public static final @unsigned int VK_SHADER_INDEX_UNUSED_AMDX = (~0);

    public static final String VK_KHR_SURFACE_EXTENSION_NAME = "VK_KHR_surface";
    public static final String VK_KHR_SWAPCHAIN_EXTENSION_NAME = "VK_KHR_swapchain";
    public static final String VK_KHR_DISPLAY_EXTENSION_NAME = "VK_KHR_display";
    public static final String VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME = "VK_KHR_display_swapchain";
    public static final String VK_KHR_XLIB_SURFACE_EXTENSION_NAME = "VK_KHR_xlib_surface";
    public static final String VK_KHR_XCB_SURFACE_EXTENSION_NAME = "VK_KHR_xcb_surface";
    public static final String VK_KHR_WAYLAND_SURFACE_EXTENSION_NAME = "VK_KHR_wayland_surface";
    public static final String VK_KHR_MIR_SURFACE_EXTENSION_NAME = "VK_KHR_mir_surface";
    public static final String VK_KHR_ANDROID_SURFACE_EXTENSION_NAME = "VK_KHR_android_surface";
    public static final String VK_KHR_WIN32_SURFACE_EXTENSION_NAME = "VK_KHR_win32_surface";
    public static final String VK_ANDROID_NATIVE_BUFFER_EXTENSION_NAME = "VK_ANDROID_native_buffer";
    public static final String VK_EXT_DEBUG_REPORT_EXTENSION_NAME = "VK_EXT_debug_report";
    public static final String VK_NV_GLSL_SHADER_EXTENSION_NAME = "VK_NV_glsl_shader";
    public static final String VK_EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION_NAME = "VK_EXT_depth_range_unrestricted";
    public static final String VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME = "VK_KHR_sampler_mirror_clamp_to_edge";
    public static final String VK_IMG_FILTER_CUBIC_EXTENSION_NAME = "VK_IMG_filter_cubic";
    public static final String VK_AMD_EXTENSION_17_EXTENSION_NAME = "VK_AMD_extension_17";
    public static final String VK_AMD_EXTENSION_18_EXTENSION_NAME = "VK_AMD_extension_18";
    public static final String VK_AMD_RASTERIZATION_ORDER_EXTENSION_NAME = "VK_AMD_rasterization_order";
    public static final String VK_AMD_EXTENSION_20_EXTENSION_NAME = "VK_AMD_extension_20";
    public static final String VK_AMD_SHADER_TRINARY_MINMAX_EXTENSION_NAME = "VK_AMD_shader_trinary_minmax";
    public static final String VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION_NAME = "VK_AMD_shader_explicit_vertex_parameter";
    public static final String VK_EXT_DEBUG_MARKER_EXTENSION_NAME = "VK_EXT_debug_marker";
    public static final String VK_KHR_VIDEO_QUEUE_EXTENSION_NAME = "VK_KHR_video_queue";
    public static final String VK_KHR_VIDEO_DECODE_QUEUE_EXTENSION_NAME = "VK_KHR_video_decode_queue";
    public static final String VK_AMD_GCN_SHADER_EXTENSION_NAME = "VK_AMD_gcn_shader";
    public static final String VK_NV_DEDICATED_ALLOCATION_EXTENSION_NAME = "VK_NV_dedicated_allocation";
    public static final String VK_EXT_EXTENSION_28_EXTENSION_NAME = "VK_EXT_extension_28";
    public static final String VK_EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME = "VK_EXT_transform_feedback";
    public static final String VK_NVX_BINARY_IMPORT_EXTENSION_NAME = "VK_NVX_binary_import";
    public static final String VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME = "VK_NVX_image_view_handle";
    public static final String VK_AMD_EXTENSION_32_EXTENSION_NAME = "VK_AMD_extension_32";
    public static final String VK_AMD_EXTENSION_33_EXTENSION_NAME = "VK_AMD_extension_33";
    public static final String VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME = "VK_AMD_draw_indirect_count";
    public static final String VK_AMD_EXTENSION_35_EXTENSION_NAME = "VK_AMD_extension_35";
    public static final String VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION_NAME = "VK_AMD_negative_viewport_height";
    public static final String VK_AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME = "VK_AMD_gpu_shader_half_float";
    public static final String VK_AMD_SHADER_BALLOT_EXTENSION_NAME = "VK_AMD_shader_ballot";
    public static final String VK_KHR_VIDEO_ENCODE_H264_EXTENSION_NAME = "VK_KHR_video_encode_h264";
    public static final String VK_KHR_VIDEO_ENCODE_H265_EXTENSION_NAME = "VK_KHR_video_encode_h265";
    public static final String VK_KHR_VIDEO_DECODE_H264_EXTENSION_NAME = "VK_KHR_video_decode_h264";
    public static final String VK_AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION_NAME = "VK_AMD_texture_gather_bias_lod";
    public static final String VK_AMD_SHADER_INFO_EXTENSION_NAME = "VK_AMD_shader_info";
    public static final String VK_AMD_EXTENSION_44_EXTENSION_NAME = "VK_AMD_extension_44";
    public static final String VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME = "VK_KHR_dynamic_rendering";
    public static final String VK_AMD_EXTENSION_46_EXTENSION_NAME = "VK_AMD_extension_46";
    public static final String VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION_NAME = "VK_AMD_shader_image_load_store_lod";
    public static final String VK_NVX_EXTENSION_48_EXTENSION_NAME = "VK_NVX_extension_48";
    public static final String VK_GOOGLE_EXTENSION_49_EXTENSION_NAME = "VK_GOOGLE_extension_49";
    public static final String VK_GGP_STREAM_DESCRIPTOR_SURFACE_EXTENSION_NAME = "VK_GGP_stream_descriptor_surface";
    public static final String VK_NV_CORNER_SAMPLED_IMAGE_EXTENSION_NAME = "VK_NV_corner_sampled_image";
    public static final String VK_NV_PRIVATE_VENDOR_INFO_EXTENSION_NAME = "VK_NV_private_vendor_info";
    public static final String VK_NV_EXTENSION_53_EXTENSION_NAME = "VK_NV_extension_53";
    public static final String VK_KHR_MULTIVIEW_EXTENSION_NAME = "VK_KHR_multiview";
    public static final String VK_IMG_FORMAT_PVRTC_EXTENSION_NAME = "VK_IMG_format_pvrtc";
    public static final String VK_NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME = "VK_NV_external_memory_capabilities";
    public static final String VK_NV_EXTERNAL_MEMORY_EXTENSION_NAME = "VK_NV_external_memory";
    public static final String VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME = "VK_NV_external_memory_win32";
    public static final String VK_NV_WIN32_KEYED_MUTEX_EXTENSION_NAME = "VK_NV_win32_keyed_mutex";
    public static final String VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME = "VK_KHR_get_physical_device_properties2";
    public static final String VK_KHR_DEVICE_GROUP_EXTENSION_NAME = "VK_KHR_device_group";
    public static final String VK_EXT_VALIDATION_FLAGS_EXTENSION_NAME = "VK_EXT_validation_flags";
    public static final String VK_NN_VI_SURFACE_EXTENSION_NAME = "VK_NN_vi_surface";
    public static final String VK_KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME = "VK_KHR_shader_draw_parameters";
    public static final String VK_EXT_SHADER_SUBGROUP_BALLOT_EXTENSION_NAME = "VK_EXT_shader_subgroup_ballot";
    public static final String VK_EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME = "VK_EXT_shader_subgroup_vote";
    public static final String VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME = "VK_EXT_texture_compression_astc_hdr";
    public static final String VK_EXT_ASTC_DECODE_MODE_EXTENSION_NAME = "VK_EXT_astc_decode_mode";
    public static final String VK_EXT_PIPELINE_ROBUSTNESS_EXTENSION_NAME = "VK_EXT_pipeline_robustness";
    public static final String VK_KHR_MAINTENANCE_1_EXTENSION_NAME = "VK_KHR_maintenance1";
    public static final String VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME = "VK_KHR_device_group_creation";
    public static final String VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME = "VK_KHR_external_memory_capabilities";
    public static final String VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME = "VK_KHR_external_memory";
    public static final String VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME = "VK_KHR_external_memory_win32";
    public static final String VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME = "VK_KHR_external_memory_fd";
    public static final String VK_KHR_WIN32_KEYED_MUTEX_EXTENSION_NAME = "VK_KHR_win32_keyed_mutex";
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME = "VK_KHR_external_semaphore_capabilities";
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME = "VK_KHR_external_semaphore";
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME = "VK_KHR_external_semaphore_win32";
    public static final String VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME = "VK_KHR_external_semaphore_fd";
    public static final String VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME = "VK_KHR_push_descriptor";
    public static final String VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME = "VK_EXT_conditional_rendering";
    public static final String VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME = "VK_KHR_shader_float16_int8";
    public static final String VK_KHR_16BIT_STORAGE_EXTENSION_NAME = "VK_KHR_16bit_storage";
    public static final String VK_KHR_INCREMENTAL_PRESENT_EXTENSION_NAME = "VK_KHR_incremental_present";
    public static final String VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME = "VK_KHR_descriptor_update_template";
    public static final String VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME = "VK_NVX_device_generated_commands";
    public static final String VK_NV_CLIP_SPACE_W_SCALING_EXTENSION_NAME = "VK_NV_clip_space_w_scaling";
    public static final String VK_EXT_DIRECT_MODE_DISPLAY_EXTENSION_NAME = "VK_EXT_direct_mode_display";
    public static final String VK_EXT_ACQUIRE_XLIB_DISPLAY_EXTENSION_NAME = "VK_EXT_acquire_xlib_display";
    public static final String VK_EXT_DISPLAY_SURFACE_COUNTER_EXTENSION_NAME = "VK_EXT_display_surface_counter";
    public static final String VK_EXT_DISPLAY_CONTROL_EXTENSION_NAME = "VK_EXT_display_control";
    public static final String VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME = "VK_GOOGLE_display_timing";
    public static final String VK_RESERVED_DO_NOT_USE_94_EXTENSION_NAME = "VK_RESERVED_do_not_use_94";
    public static final String VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION_NAME = "VK_NV_sample_mask_override_coverage";
    public static final String VK_NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION_NAME = "VK_NV_geometry_shader_passthrough";
    public static final String VK_NV_VIEWPORT_ARRAY_2_EXTENSION_NAME = "VK_NV_viewport_array2";
    public static final String VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION_NAME = "VK_NVX_multiview_per_view_attributes";
    public static final String VK_NV_VIEWPORT_SWIZZLE_EXTENSION_NAME = "VK_NV_viewport_swizzle";
    public static final String VK_EXT_DISCARD_RECTANGLES_EXTENSION_NAME = "VK_EXT_discard_rectangles";
    public static final String VK_NV_EXTENSION_101_EXTENSION_NAME = "VK_NV_extension_101";
    public static final String VK_EXT_CONSERVATIVE_RASTERIZATION_EXTENSION_NAME = "VK_EXT_conservative_rasterization";
    public static final String VK_EXT_DEPTH_CLIP_ENABLE_EXTENSION_NAME = "VK_EXT_depth_clip_enable";
    public static final String VK_NV_EXTENSION_104_EXTENSION_NAME = "VK_NV_extension_104";
    public static final String VK_EXT_SWAPCHAIN_COLOR_SPACE_EXTENSION_NAME = "VK_EXT_swapchain_colorspace";
    public static final String VK_EXT_HDR_METADATA_EXTENSION_NAME = "VK_EXT_hdr_metadata";
    public static final String VK_IMG_EXTENSION_107_EXTENSION_NAME = "VK_IMG_extension_107";
    public static final String VK_IMG_EXTENSION_108_EXTENSION_NAME = "VK_IMG_extension_108";
    public static final String VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME = "VK_KHR_imageless_framebuffer";
    public static final String VK_KHR_CREATE_RENDERPASS_2_EXTENSION_NAME = "VK_KHR_create_renderpass2";
    public static final String VK_IMG_RELAXED_LINE_RASTERIZATION_EXTENSION_NAME = "VK_IMG_relaxed_line_rasterization";
    public static final String VK_KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION_NAME = "VK_KHR_shared_presentable_image";
    public static final String VK_KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME = "VK_KHR_external_fence_capabilities";
    public static final String VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME = "VK_KHR_external_fence";
    public static final String VK_KHR_EXTERNAL_FENCE_WIN32_EXTENSION_NAME = "VK_KHR_external_fence_win32";
    public static final String VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME = "VK_KHR_external_fence_fd";
    public static final String VK_KHR_PERFORMANCE_QUERY_EXTENSION_NAME = "VK_KHR_performance_query";
    public static final String VK_KHR_MAINTENANCE_2_EXTENSION_NAME = "VK_KHR_maintenance2";
    public static final String VK_KHR_EXTENSION_119_EXTENSION_NAME = "VK_KHR_extension_119";
    public static final String VK_KHR_GET_SURFACE_CAPABILITIES_2_EXTENSION_NAME = "VK_KHR_get_surface_capabilities2";
    public static final String VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME = "VK_KHR_variable_pointers";
    public static final String VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME = "VK_KHR_get_display_properties2";
    public static final String VK_MVK_IOS_SURFACE_EXTENSION_NAME = "VK_MVK_ios_surface";
    public static final String VK_MVK_MACOS_SURFACE_EXTENSION_NAME = "VK_MVK_macos_surface";
    public static final String VK_MVK_MOLTENVK_EXTENSION_NAME = "VK_MVK_moltenvk";
    public static final String VK_EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION_NAME = "VK_EXT_external_memory_dma_buf";
    public static final String VK_EXT_QUEUE_FAMILY_FOREIGN_EXTENSION_NAME = "VK_EXT_queue_family_foreign";
    public static final String VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME = "VK_KHR_dedicated_allocation";
    public static final String VK_EXT_DEBUG_UTILS_EXTENSION_NAME = "VK_EXT_debug_utils";
    public static final String VK_ANDROID_EXTERNAL_MEMORY_ANDROID_HARDWARE_BUFFER_EXTENSION_NAME = "VK_ANDROID_external_memory_android_hardware_buffer";
    public static final String VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME = "VK_EXT_sampler_filter_minmax";
    public static final String VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME = "VK_KHR_storage_buffer_storage_class";
    public static final String VK_AMD_GPU_SHADER_INT16_EXTENSION_NAME = "VK_AMD_gpu_shader_int16";
    public static final String VK_AMD_EXTENSION_134_EXTENSION_NAME = "VK_AMD_extension_134";
    public static final String VK_AMDX_SHADER_ENQUEUE_EXTENSION_NAME = "VK_AMDX_shader_enqueue";
    public static final String VK_KHR_EXTENSION_136_EXTENSION_NAME = "VK_KHR_extension_136";
    public static final String VK_AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION_NAME = "VK_AMD_mixed_attachment_samples";
    public static final String VK_AMD_SHADER_FRAGMENT_MASK_EXTENSION_NAME = "VK_AMD_shader_fragment_mask";
    public static final String VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME = "VK_EXT_inline_uniform_block";
    public static final String VK_AMD_EXTENSION_140_EXTENSION_NAME = "VK_AMD_extension_140";
    public static final String VK_EXT_SHADER_STENCIL_EXPORT_EXTENSION_NAME = "VK_EXT_shader_stencil_export";
    public static final String VK_AMD_EXTENSION_142_EXTENSION_NAME = "VK_AMD_extension_142";
    public static final String VK_AMD_EXTENSION_143_EXTENSION_NAME = "VK_AMD_extension_143";
    public static final String VK_EXT_SAMPLE_LOCATIONS_EXTENSION_NAME = "VK_EXT_sample_locations";
    public static final String VK_KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME = "VK_KHR_relaxed_block_layout";
    public static final String VK_RESERVED_DO_NOT_USE_146_EXTENSION_NAME = "VK_RESERVED_do_not_use_146";
    public static final String VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME = "VK_KHR_get_memory_requirements2";
    public static final String VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME = "VK_KHR_image_format_list";
    public static final String VK_EXT_BLEND_OPERATION_ADVANCED_EXTENSION_NAME = "VK_EXT_blend_operation_advanced";
    public static final String VK_NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION_NAME = "VK_NV_fragment_coverage_to_color";
    public static final String VK_KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME = "VK_KHR_acceleration_structure";
    public static final String VK_KHR_RAY_TRACING_PIPELINE_EXTENSION_NAME = "VK_KHR_ray_tracing_pipeline";
    public static final String VK_KHR_RAY_QUERY_EXTENSION_NAME = "VK_KHR_ray_query";
    public static final String VK_NV_EXTENSION_152_EXTENSION_NAME = "VK_NV_extension_152";
    public static final String VK_NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION_NAME = "VK_NV_framebuffer_mixed_samples";
    public static final String VK_NV_FILL_RECTANGLE_EXTENSION_NAME = "VK_NV_fill_rectangle";
    public static final String VK_NV_SHADER_SM_BUILTINS_EXTENSION_NAME = "VK_NV_shader_sm_builtins";
    public static final String VK_EXT_POST_DEPTH_COVERAGE_EXTENSION_NAME = "VK_EXT_post_depth_coverage";
    public static final String VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME = "VK_KHR_sampler_ycbcr_conversion";
    public static final String VK_KHR_BIND_MEMORY_2_EXTENSION_NAME = "VK_KHR_bind_memory2";
    public static final String VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION_NAME = "VK_EXT_image_drm_format_modifier";
    public static final String VK_EXT_EXTENSION_160_EXTENSION_NAME = "VK_EXT_extension_160";
    public static final String VK_EXT_VALIDATION_CACHE_EXTENSION_NAME = "VK_EXT_validation_cache";
    public static final String VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME = "VK_EXT_descriptor_indexing";
    public static final String VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION_NAME = "VK_EXT_shader_viewport_index_layer";
    public static final String VK_KHR_PORTABILITY_SUBSET_EXTENSION_NAME = "VK_KHR_portability_subset";
    public static final String VK_NV_SHADING_RATE_IMAGE_EXTENSION_NAME = "VK_NV_shading_rate_image";
    public static final String VK_NV_RAY_TRACING_EXTENSION_NAME = "VK_NV_ray_tracing";
    public static final String VK_NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION_NAME = "VK_NV_representative_fragment_test";
    public static final String VK_NV_EXTENSION_168_EXTENSION_NAME = "VK_NV_extension_168";
    public static final String VK_KHR_MAINTENANCE_3_EXTENSION_NAME = "VK_KHR_maintenance3";
    public static final String VK_KHR_DRAW_INDIRECT_COUNT_EXTENSION_NAME = "VK_KHR_draw_indirect_count";
    public static final String VK_EXT_FILTER_CUBIC_EXTENSION_NAME = "VK_EXT_filter_cubic";
    public static final String VK_QCOM_RENDER_PASS_SHADER_RESOLVE_EXTENSION_NAME = "VK_QCOM_render_pass_shader_resolve";
    public static final String VK_QCOM_EXTENSION_173_EXTENSION_NAME = "VK_QCOM_extension_173";
    public static final String VK_QCOM_EXTENSION_174_EXTENSION_NAME = "VK_QCOM_extension_174";
    public static final String VK_EXT_GLOBAL_PRIORITY_EXTENSION_NAME = "VK_EXT_global_priority";
    public static final String VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME = "VK_KHR_shader_subgroup_extended_types";
    public static final String VK_EXT_EXTENSION_177_EXTENSION_NAME = "VK_EXT_extension_177";
    public static final String VK_KHR_8BIT_STORAGE_EXTENSION_NAME = "VK_KHR_8bit_storage";
    public static final String VK_EXT_EXTERNAL_MEMORY_HOST_EXTENSION_NAME = "VK_EXT_external_memory_host";
    public static final String VK_AMD_BUFFER_MARKER_EXTENSION_NAME = "VK_AMD_buffer_marker";
    public static final String VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME = "VK_KHR_shader_atomic_int64";
    public static final String VK_KHR_SHADER_CLOCK_EXTENSION_NAME = "VK_KHR_shader_clock";
    public static final String VK_AMD_EXTENSION_183_EXTENSION_NAME = "VK_AMD_extension_183";
    public static final String VK_AMD_PIPELINE_COMPILER_CONTROL_EXTENSION_NAME = "VK_AMD_pipeline_compiler_control";
    public static final String VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME = "VK_EXT_calibrated_timestamps";
    public static final String VK_AMD_SHADER_CORE_PROPERTIES_EXTENSION_NAME = "VK_AMD_shader_core_properties";
    public static final String VK_AMD_EXTENSION_187_EXTENSION_NAME = "VK_AMD_extension_187";
    public static final String VK_KHR_VIDEO_DECODE_H265_EXTENSION_NAME = "VK_KHR_video_decode_h265";
    public static final String VK_KHR_GLOBAL_PRIORITY_EXTENSION_NAME = "VK_KHR_global_priority";
    public static final String VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION_NAME = "VK_AMD_memory_overallocation_behavior";
    public static final String VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME = "VK_EXT_vertex_attribute_divisor";
    public static final String VK_GGP_FRAME_TOKEN_EXTENSION_NAME = "VK_GGP_frame_token";
    public static final String VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME = "VK_EXT_pipeline_creation_feedback";
    public static final String VK_GOOGLE_EXTENSION_194_EXTENSION_NAME = "VK_GOOGLE_extension_194";
    public static final String VK_GOOGLE_EXTENSION_195_EXTENSION_NAME = "VK_GOOGLE_extension_195";
    public static final String VK_GOOGLE_EXTENSION_196_EXTENSION_NAME = "VK_GOOGLE_extension_196";
    public static final String VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME = "VK_KHR_driver_properties";
    public static final String VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME = "VK_KHR_shader_float_controls";
    public static final String VK_NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION_NAME = "VK_NV_shader_subgroup_partitioned";
    public static final String VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME = "VK_KHR_depth_stencil_resolve";
    public static final String VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION_NAME = "VK_KHR_swapchain_mutable_format";
    public static final String VK_NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME = "VK_NV_compute_shader_derivatives";
    public static final String VK_NV_MESH_SHADER_EXTENSION_NAME = "VK_NV_mesh_shader";
    public static final String VK_NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME = "VK_NV_fragment_shader_barycentric";
    public static final String VK_NV_SHADER_IMAGE_FOOTPRINT_EXTENSION_NAME = "VK_NV_shader_image_footprint";
    public static final String VK_NV_SCISSOR_EXCLUSIVE_EXTENSION_NAME = "VK_NV_scissor_exclusive";
    public static final String VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME = "VK_NV_device_diagnostic_checkpoints";
    public static final String VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME = "VK_KHR_timeline_semaphore";
    public static final String VK_KHR_EXTENSION_209_EXTENSION_NAME = "VK_KHR_extension_209";
    public static final String VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_EXTENSION_NAME = "VK_INTEL_shader_integer_functions2";
    public static final String VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME = "VK_INTEL_performance_query";
    public static final String VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME = "VK_KHR_vulkan_memory_model";
    public static final String VK_EXT_PCI_BUS_INFO_EXTENSION_NAME = "VK_EXT_pci_bus_info";
    public static final String VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME = "VK_AMD_display_native_hdr";
    public static final String VK_FUCHSIA_IMAGEPIPE_SURFACE_EXTENSION_NAME = "VK_FUCHSIA_imagepipe_surface";
    public static final String VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME = "VK_KHR_shader_terminate_invocation";
    public static final String VK_GOOGLE_EXTENSION_217_EXTENSION_NAME = "VK_GOOGLE_extension_217";
    public static final String VK_EXT_METAL_SURFACE_EXTENSION_NAME = "VK_EXT_metal_surface";
    public static final String VK_EXT_FRAGMENT_DENSITY_MAP_EXTENSION_NAME = "VK_EXT_fragment_density_map";
    public static final String VK_EXT_EXTENSION_220_EXTENSION_NAME = "VK_EXT_extension_220";
    public static final String VK_KHR_EXTENSION_221_EXTENSION_NAME = "VK_KHR_extension_221";
    public static final String VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME = "VK_EXT_scalar_block_layout";
    public static final String VK_EXT_EXTENSION_223_EXTENSION_NAME = "VK_EXT_extension_223";
    public static final String VK_GOOGLE_HLSL_FUNCTIONALITY_1_EXTENSION_NAME = "VK_GOOGLE_hlsl_functionality1";
    public static final String VK_GOOGLE_DECORATE_STRING_EXTENSION_NAME = "VK_GOOGLE_decorate_string";
    public static final String VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME = "VK_EXT_subgroup_size_control";
    public static final String VK_KHR_FRAGMENT_SHADING_RATE_EXTENSION_NAME = "VK_KHR_fragment_shading_rate";
    public static final String VK_AMD_SHADER_CORE_PROPERTIES_2_EXTENSION_NAME = "VK_AMD_shader_core_properties2";
    public static final String VK_AMD_EXTENSION_229_EXTENSION_NAME = "VK_AMD_extension_229";
    public static final String VK_AMD_DEVICE_COHERENT_MEMORY_EXTENSION_NAME = "VK_AMD_device_coherent_memory";
    public static final String VK_AMD_EXTENSION_231_EXTENSION_NAME = "VK_AMD_extension_231";
    public static final String VK_AMD_EXTENSION_232_EXTENSION_NAME = "VK_AMD_extension_232";
    public static final String VK_KHR_DYNAMIC_RENDERING_LOCAL_READ_EXTENSION_NAME = "VK_KHR_dynamic_rendering_local_read";
    public static final String VK_AMD_EXTENSION_234_EXTENSION_NAME = "VK_AMD_extension_234";
    public static final String VK_EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION_NAME = "VK_EXT_shader_image_atomic_int64";
    public static final String VK_KHR_SHADER_QUAD_CONTROL_EXTENSION_NAME = "VK_KHR_shader_quad_control";
    public static final String VK_KHR_SPIRV_1_4_EXTENSION_NAME = "VK_KHR_spirv_1_4";
    public static final String VK_EXT_MEMORY_BUDGET_EXTENSION_NAME = "VK_EXT_memory_budget";
    public static final String VK_EXT_MEMORY_PRIORITY_EXTENSION_NAME = "VK_EXT_memory_priority";
    public static final String VK_KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION_NAME = "VK_KHR_surface_protected_capabilities";
    public static final String VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION_NAME = "VK_NV_dedicated_allocation_image_aliasing";
    public static final String VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME = "VK_KHR_separate_depth_stencil_layouts";
    public static final String VK_INTEL_EXTENSION_243_EXTENSION_NAME = "VK_INTEL_extension_243";
    public static final String VK_MESA_EXTENSION_244_EXTENSION_NAME = "VK_MESA_extension_244";
    public static final String VK_EXT_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME = "VK_EXT_buffer_device_address";
    public static final String VK_EXT_TOOLING_INFO_EXTENSION_NAME = "VK_EXT_tooling_info";
    public static final String VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME = "VK_EXT_separate_stencil_usage";
    public static final String VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME = "VK_EXT_validation_features";
    public static final String VK_KHR_PRESENT_WAIT_EXTENSION_NAME = "VK_KHR_present_wait";
    public static final String VK_NV_COOPERATIVE_MATRIX_EXTENSION_NAME = "VK_NV_cooperative_matrix";
    public static final String VK_NV_COVERAGE_REDUCTION_MODE_EXTENSION_NAME = "VK_NV_coverage_reduction_mode";
    public static final String VK_EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION_NAME = "VK_EXT_fragment_shader_interlock";
    public static final String VK_EXT_YCBCR_IMAGE_ARRAYS_EXTENSION_NAME = "VK_EXT_ycbcr_image_arrays";
    public static final String VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME = "VK_KHR_uniform_buffer_standard_layout";
    public static final String VK_EXT_PROVOKING_VERTEX_EXTENSION_NAME = "VK_EXT_provoking_vertex";
    public static final String VK_EXT_FULL_SCREEN_EXCLUSIVE_EXTENSION_NAME = "VK_EXT_full_screen_exclusive";
    public static final String VK_EXT_HEADLESS_SURFACE_EXTENSION_NAME = "VK_EXT_headless_surface";
    public static final String VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME = "VK_KHR_buffer_device_address";
    public static final String VK_EXT_EXTENSION_259_EXTENSION_NAME = "VK_EXT_extension_259";
    public static final String VK_EXT_LINE_RASTERIZATION_EXTENSION_NAME = "VK_EXT_line_rasterization";
    public static final String VK_EXT_SHADER_ATOMIC_FLOAT_EXTENSION_NAME = "VK_EXT_shader_atomic_float";
    public static final String VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME = "VK_EXT_host_query_reset";
    public static final String VK_GGP_EXTENSION_263_EXTENSION_NAME = "VK_GGP_extension_263";
    public static final String VK_BRCM_EXTENSION_264_EXTENSION_NAME = "VK_BRCM_extension_264";
    public static final String VK_BRCM_EXTENSION_265_EXTENSION_NAME = "VK_BRCM_extension_265";
    public static final String VK_EXT_INDEX_TYPE_UINT8_EXTENSION_NAME = "VK_EXT_index_type_uint8";
    public static final String VK_EXT_EXTENSION_267_EXTENSION_NAME = "VK_EXT_extension_267";
    public static final String VK_EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME = "VK_EXT_extended_dynamic_state";
    public static final String VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME = "VK_KHR_deferred_host_operations";
    public static final String VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME = "VK_KHR_pipeline_executable_properties";
    public static final String VK_EXT_HOST_IMAGE_COPY_EXTENSION_NAME = "VK_EXT_host_image_copy";
    public static final String VK_KHR_MAP_MEMORY_2_EXTENSION_NAME = "VK_KHR_map_memory2";
    public static final String VK_EXT_MAP_MEMORY_PLACED_EXTENSION_NAME = "VK_EXT_map_memory_placed";
    public static final String VK_EXT_SHADER_ATOMIC_FLOAT_2_EXTENSION_NAME = "VK_EXT_shader_atomic_float2";
    public static final String VK_EXT_SURFACE_MAINTENANCE_1_EXTENSION_NAME = "VK_EXT_surface_maintenance1";
    public static final String VK_EXT_SWAPCHAIN_MAINTENANCE_1_EXTENSION_NAME = "VK_EXT_swapchain_maintenance1";
    public static final String VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME = "VK_EXT_shader_demote_to_helper_invocation";
    public static final String VK_NV_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME = "VK_NV_device_generated_commands";
    public static final String VK_NV_INHERITED_VIEWPORT_SCISSOR_EXTENSION_NAME = "VK_NV_inherited_viewport_scissor";
    public static final String VK_KHR_EXTENSION_280_EXTENSION_NAME = "VK_KHR_extension_280";
    public static final String VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME = "VK_KHR_shader_integer_dot_product";
    public static final String VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME = "VK_EXT_texel_buffer_alignment";
    public static final String VK_QCOM_RENDER_PASS_TRANSFORM_EXTENSION_NAME = "VK_QCOM_render_pass_transform";
    public static final String VK_EXT_DEPTH_BIAS_CONTROL_EXTENSION_NAME = "VK_EXT_depth_bias_control";
    public static final String VK_EXT_DEVICE_MEMORY_REPORT_EXTENSION_NAME = "VK_EXT_device_memory_report";
    public static final String VK_EXT_ACQUIRE_DRM_DISPLAY_EXTENSION_NAME = "VK_EXT_acquire_drm_display";
    public static final String VK_EXT_ROBUSTNESS_2_EXTENSION_NAME = "VK_EXT_robustness2";
    public static final String VK_EXT_CUSTOM_BORDER_COLOR_EXTENSION_NAME = "VK_EXT_custom_border_color";
    public static final String VK_EXT_EXTENSION_289_EXTENSION_NAME = "VK_EXT_extension_289";
    public static final String VK_GOOGLE_USER_TYPE_EXTENSION_NAME = "VK_GOOGLE_user_type";
    public static final String VK_KHR_PIPELINE_LIBRARY_EXTENSION_NAME = "VK_KHR_pipeline_library";
    public static final String VK_NV_EXTENSION_292_EXTENSION_NAME = "VK_NV_extension_292";
    public static final String VK_NV_PRESENT_BARRIER_EXTENSION_NAME = "VK_NV_present_barrier";
    public static final String VK_KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION_NAME = "VK_KHR_shader_non_semantic_info";
    public static final String VK_KHR_PRESENT_ID_EXTENSION_NAME = "VK_KHR_present_id";
    public static final String VK_EXT_PRIVATE_DATA_EXTENSION_NAME = "VK_EXT_private_data";
    public static final String VK_KHR_EXTENSION_297_EXTENSION_NAME = "VK_KHR_extension_297";
    public static final String VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME = "VK_EXT_pipeline_creation_cache_control";
    public static final String VK_KHR_EXTENSION_299_EXTENSION_NAME = "VK_KHR_extension_299";
    public static final String VK_KHR_VIDEO_ENCODE_QUEUE_EXTENSION_NAME = "VK_KHR_video_encode_queue";
    public static final String VK_NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION_NAME = "VK_NV_device_diagnostics_config";
    public static final String VK_QCOM_RENDER_PASS_STORE_OPS_EXTENSION_NAME = "VK_QCOM_render_pass_store_ops";
    public static final String VK_QCOM_EXTENSION_303_EXTENSION_NAME = "VK_QCOM_extension_303";
    public static final String VK_QCOM_EXTENSION_304_EXTENSION_NAME = "VK_QCOM_extension_304";
    public static final String VK_QCOM_EXTENSION_305_EXTENSION_NAME = "VK_QCOM_extension_305";
    public static final String VK_QCOM_EXTENSION_306_EXTENSION_NAME = "VK_QCOM_extension_306";
    public static final String VK_QCOM_EXTENSION_307_EXTENSION_NAME = "VK_QCOM_extension_307";
    public static final String VK_NV_CUDA_KERNEL_LAUNCH_EXTENSION_NAME = "VK_NV_cuda_kernel_launch";
    public static final String VK_KHR_OBJECT_REFRESH_EXTENSION_NAME = "VK_KHR_object_refresh";
    public static final String VK_QCOM_EXTENSION_310_EXTENSION_NAME = "VK_QCOM_extension_310";
    public static final String VK_NV_LOW_LATENCY_EXTENSION_NAME = "VK_NV_low_latency";
    public static final String VK_EXT_METAL_OBJECTS_EXTENSION_NAME = "VK_EXT_metal_objects";
    public static final String VK_EXT_EXTENSION_313_EXTENSION_NAME = "VK_EXT_extension_313";
    public static final String VK_AMD_EXTENSION_314_EXTENSION_NAME = "VK_AMD_extension_314";
    public static final String VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME = "VK_KHR_synchronization2";
    public static final String VK_AMD_EXTENSION_316_EXTENSION_NAME = "VK_AMD_extension_316";
    public static final String VK_EXT_DESCRIPTOR_BUFFER_EXTENSION_NAME = "VK_EXT_descriptor_buffer";
    public static final String VK_AMD_EXTENSION_318_EXTENSION_NAME = "VK_AMD_extension_318";
    public static final String VK_AMD_EXTENSION_319_EXTENSION_NAME = "VK_AMD_extension_319";
    public static final String VK_AMD_EXTENSION_320_EXTENSION_NAME = "VK_AMD_extension_320";
    public static final String VK_EXT_GRAPHICS_PIPELINE_LIBRARY_EXTENSION_NAME = "VK_EXT_graphics_pipeline_library";
    public static final String VK_AMD_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_EXTENSION_NAME = "VK_AMD_shader_early_and_late_fragment_tests";
    public static final String VK_KHR_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME = "VK_KHR_fragment_shader_barycentric";
    public static final String VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_EXTENSION_NAME = "VK_KHR_shader_subgroup_uniform_control_flow";
    public static final String VK_KHR_EXTENSION_325_EXTENSION_NAME = "VK_KHR_extension_325";
    public static final String VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME = "VK_KHR_zero_initialize_workgroup_memory";
    public static final String VK_NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION_NAME = "VK_NV_fragment_shading_rate_enums";
    public static final String VK_NV_RAY_TRACING_MOTION_BLUR_EXTENSION_NAME = "VK_NV_ray_tracing_motion_blur";
    public static final String VK_EXT_MESH_SHADER_EXTENSION_NAME = "VK_EXT_mesh_shader";
    public static final String VK_NV_EXTENSION_330_EXTENSION_NAME = "VK_NV_extension_330";
    public static final String VK_EXT_YCBCR_2PLANE_444_FORMATS_EXTENSION_NAME = "VK_EXT_ycbcr_2plane_444_formats";
    public static final String VK_NV_EXTENSION_332_EXTENSION_NAME = "VK_NV_extension_332";
    public static final String VK_EXT_FRAGMENT_DENSITY_MAP_2_EXTENSION_NAME = "VK_EXT_fragment_density_map2";
    public static final String VK_QCOM_ROTATED_COPY_COMMANDS_EXTENSION_NAME = "VK_QCOM_rotated_copy_commands";
    public static final String VK_KHR_EXTENSION_335_EXTENSION_NAME = "VK_KHR_extension_335";
    public static final String VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME = "VK_EXT_image_robustness";
    public static final String VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION_NAME = "VK_KHR_workgroup_memory_explicit_layout";
    public static final String VK_KHR_COPY_COMMANDS_2_EXTENSION_NAME = "VK_KHR_copy_commands2";
    public static final String VK_EXT_IMAGE_COMPRESSION_CONTROL_EXTENSION_NAME = "VK_EXT_image_compression_control";
    public static final String VK_EXT_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_EXTENSION_NAME = "VK_EXT_attachment_feedback_loop_layout";
    public static final String VK_EXT_4444_FORMATS_EXTENSION_NAME = "VK_EXT_4444_formats";
    public static final String VK_EXT_DEVICE_FAULT_EXTENSION_NAME = "VK_EXT_device_fault";
    public static final String VK_ARM_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_EXTENSION_NAME = "VK_ARM_rasterization_order_attachment_access";
    public static final String VK_ARM_EXTENSION_344_EXTENSION_NAME = "VK_ARM_extension_344";
    public static final String VK_EXT_RGBA10X6_FORMATS_EXTENSION_NAME = "VK_EXT_rgba10x6_formats";
    public static final String VK_NV_ACQUIRE_WINRT_DISPLAY_EXTENSION_NAME = "VK_NV_acquire_winrt_display";
    public static final String VK_EXT_DIRECTFB_SURFACE_EXTENSION_NAME = "VK_EXT_directfb_surface";
    public static final String VK_KHR_EXTENSION_350_EXTENSION_NAME = "VK_KHR_extension_350";
    public static final String VK_NV_EXTENSION_351_EXTENSION_NAME = "VK_NV_extension_351";
    public static final String VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME = "VK_VALVE_mutable_descriptor_type";
    public static final String VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_EXTENSION_NAME = "VK_EXT_vertex_input_dynamic_state";
    public static final String VK_EXT_PHYSICAL_DEVICE_DRM_EXTENSION_NAME = "VK_EXT_physical_device_drm";
    public static final String VK_EXT_DEVICE_ADDRESS_BINDING_REPORT_EXTENSION_NAME = "VK_EXT_device_address_binding_report";
    public static final String VK_EXT_DEPTH_CLIP_CONTROL_EXTENSION_NAME = "VK_EXT_depth_clip_control";
    public static final String VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_EXTENSION_NAME = "VK_EXT_primitive_topology_list_restart";
    public static final String VK_KHR_EXTENSION_358_EXTENSION_NAME = "VK_KHR_extension_358";
    public static final String VK_EXT_EXTENSION_359_EXTENSION_NAME = "VK_EXT_extension_359";
    public static final String VK_EXT_EXTENSION_360_EXTENSION_NAME = "VK_EXT_extension_360";
    public static final String VK_KHR_FORMAT_FEATURE_FLAGS_2_EXTENSION_NAME = "VK_KHR_format_feature_flags2";
    public static final String VK_EXT_EXTENSION_362_EXTENSION_NAME = "VK_EXT_extension_362";
    public static final String VK_EXT_EXTENSION_363_EXTENSION_NAME = "VK_EXT_extension_363";
    public static final String VK_FUCHSIA_EXTENSION_364_EXTENSION_NAME = "VK_FUCHSIA_extension_364";
    public static final String VK_FUCHSIA_EXTERNAL_MEMORY_EXTENSION_NAME = "VK_FUCHSIA_external_memory";
    public static final String VK_FUCHSIA_EXTERNAL_SEMAPHORE_EXTENSION_NAME = "VK_FUCHSIA_external_semaphore";
    public static final String VK_FUCHSIA_BUFFER_COLLECTION_EXTENSION_NAME = "VK_FUCHSIA_buffer_collection";
    public static final String VK_FUCHSIA_EXTENSION_368_EXTENSION_NAME = "VK_FUCHSIA_extension_368";
    public static final String VK_QCOM_EXTENSION_369_EXTENSION_NAME = "VK_QCOM_extension_369";
    public static final String VK_HUAWEI_SUBPASS_SHADING_EXTENSION_NAME = "VK_HUAWEI_subpass_shading";
    public static final String VK_HUAWEI_INVOCATION_MASK_EXTENSION_NAME = "VK_HUAWEI_invocation_mask";
    public static final String VK_NV_EXTERNAL_MEMORY_RDMA_EXTENSION_NAME = "VK_NV_external_memory_rdma";
    public static final String VK_EXT_PIPELINE_PROPERTIES_EXTENSION_NAME = "VK_EXT_pipeline_properties";
    public static final String VK_NV_EXTERNAL_SCI_SYNC_EXTENSION_NAME = "VK_NV_external_sci_sync";
    public static final String VK_NV_EXTERNAL_MEMORY_SCI_BUF_EXTENSION_NAME = "VK_NV_external_memory_sci_buf";
    public static final String VK_EXT_FRAME_BOUNDARY_EXTENSION_NAME = "VK_EXT_frame_boundary";
    public static final String VK_EXT_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_EXTENSION_NAME = "VK_EXT_multisampled_render_to_single_sampled";
    public static final String VK_EXT_EXTENDED_DYNAMIC_STATE_2_EXTENSION_NAME = "VK_EXT_extended_dynamic_state2";
    public static final String VK_QNX_SCREEN_SURFACE_EXTENSION_NAME = "VK_QNX_screen_surface";
    public static final String VK_KHR_EXTENSION_380_EXTENSION_NAME = "VK_KHR_extension_380";
    public static final String VK_KHR_EXTENSION_381_EXTENSION_NAME = "VK_KHR_extension_381";
    public static final String VK_EXT_COLOR_WRITE_ENABLE_EXTENSION_NAME = "VK_EXT_color_write_enable";
    public static final String VK_EXT_PRIMITIVES_GENERATED_QUERY_EXTENSION_NAME = "VK_EXT_primitives_generated_query";
    public static final String VK_EXT_EXTENSION_384_EXTENSION_NAME = "VK_EXT_extension_384";
    public static final String VK_MESA_EXTENSION_385_EXTENSION_NAME = "VK_MESA_extension_385";
    public static final String VK_GOOGLE_EXTENSION_386_EXTENSION_NAME = "VK_GOOGLE_extension_386";
    public static final String VK_KHR_RAY_TRACING_MAINTENANCE_1_EXTENSION_NAME = "VK_KHR_ray_tracing_maintenance1";
    public static final String VK_EXT_EXTENSION_388_EXTENSION_NAME = "VK_EXT_extension_388";
    public static final String VK_EXT_GLOBAL_PRIORITY_QUERY_EXTENSION_NAME = "VK_EXT_global_priority_query";
    public static final String VK_EXT_EXTENSION_390_EXTENSION_NAME = "VK_EXT_extension_390";
    public static final String VK_EXT_EXTENSION_391_EXTENSION_NAME = "VK_EXT_extension_391";
    public static final String VK_EXT_IMAGE_VIEW_MIN_LOD_EXTENSION_NAME = "VK_EXT_image_view_min_lod";
    public static final String VK_EXT_MULTI_DRAW_EXTENSION_NAME = "VK_EXT_multi_draw";
    public static final String VK_EXT_IMAGE_2D_VIEW_OF_3D_EXTENSION_NAME = "VK_EXT_image_2d_view_of_3d";
    public static final String VK_KHR_PORTABILITY_ENUMERATION_EXTENSION_NAME = "VK_KHR_portability_enumeration";
    public static final String VK_EXT_SHADER_TILE_IMAGE_EXTENSION_NAME = "VK_EXT_shader_tile_image";
    public static final String VK_EXT_OPACITY_MICROMAP_EXTENSION_NAME = "VK_EXT_opacity_micromap";
    public static final String VK_NV_DISPLACEMENT_MICROMAP_EXTENSION_NAME = "VK_NV_displacement_micromap";
    public static final String VK_JUICE_EXTENSION_399_EXTENSION_NAME = "VK_JUICE_extension_399";
    public static final String VK_JUICE_EXTENSION_400_EXTENSION_NAME = "VK_JUICE_extension_400";
    public static final String VK_EXT_LOAD_STORE_OP_NONE_EXTENSION_NAME = "VK_EXT_load_store_op_none";
    public static final String VK_FB_EXTENSION_402_EXTENSION_NAME = "VK_FB_extension_402";
    public static final String VK_FB_EXTENSION_403_EXTENSION_NAME = "VK_FB_extension_403";
    public static final String VK_FB_EXTENSION_404_EXTENSION_NAME = "VK_FB_extension_404";
    public static final String VK_HUAWEI_CLUSTER_CULLING_SHADER_EXTENSION_NAME = "VK_HUAWEI_cluster_culling_shader";
    public static final String VK_HUAWEI_EXTENSION_406_EXTENSION_NAME = "VK_HUAWEI_extension_406";
    public static final String VK_GGP_EXTENSION_407_EXTENSION_NAME = "VK_GGP_extension_407";
    public static final String VK_GGP_EXTENSION_408_EXTENSION_NAME = "VK_GGP_extension_408";
    public static final String VK_GGP_EXTENSION_409_EXTENSION_NAME = "VK_GGP_extension_409";
    public static final String VK_GGP_EXTENSION_410_EXTENSION_NAME = "VK_GGP_extension_410";
    public static final String VK_GGP_EXTENSION_411_EXTENSION_NAME = "VK_GGP_extension_411";
    public static final String VK_EXT_BORDER_COLOR_SWIZZLE_EXTENSION_NAME = "VK_EXT_border_color_swizzle";
    public static final String VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_EXTENSION_NAME = "VK_EXT_pageable_device_local_memory";
    public static final String VK_KHR_MAINTENANCE_4_EXTENSION_NAME = "VK_KHR_maintenance4";
    public static final String VK_HUAWEI_EXTENSION_415_EXTENSION_NAME = "VK_HUAWEI_extension_415";
    public static final String VK_ARM_SHADER_CORE_PROPERTIES_EXTENSION_NAME = "VK_ARM_shader_core_properties";
    public static final String VK_KHR_SHADER_SUBGROUP_ROTATE_EXTENSION_NAME = "VK_KHR_shader_subgroup_rotate";
    public static final String VK_ARM_SCHEDULING_CONTROLS_EXTENSION_NAME = "VK_ARM_scheduling_controls";
    public static final String VK_EXT_IMAGE_SLICED_VIEW_OF_3D_EXTENSION_NAME = "VK_EXT_image_sliced_view_of_3d";
    public static final String VK_EXT_EXTENSION_420_EXTENSION_NAME = "VK_EXT_extension_420";
    public static final String VK_VALVE_DESCRIPTOR_SET_HOST_MAPPING_EXTENSION_NAME = "VK_VALVE_descriptor_set_host_mapping";
    public static final String VK_EXT_DEPTH_CLAMP_ZERO_ONE_EXTENSION_NAME = "VK_EXT_depth_clamp_zero_one";
    public static final String VK_EXT_NON_SEAMLESS_CUBE_MAP_EXTENSION_NAME = "VK_EXT_non_seamless_cube_map";
    public static final String VK_ARM_EXTENSION_424_EXTENSION_NAME = "VK_ARM_extension_424";
    public static final String VK_ARM_RENDER_PASS_STRIPED_EXTENSION_NAME = "VK_ARM_render_pass_striped";
    public static final String VK_QCOM_FRAGMENT_DENSITY_MAP_OFFSET_EXTENSION_NAME = "VK_QCOM_fragment_density_map_offset";
    public static final String VK_NV_COPY_MEMORY_INDIRECT_EXTENSION_NAME = "VK_NV_copy_memory_indirect";
    public static final String VK_NV_MEMORY_DECOMPRESSION_EXTENSION_NAME = "VK_NV_memory_decompression";
    public static final String VK_NV_DEVICE_GENERATED_COMMANDS_COMPUTE_EXTENSION_NAME = "VK_NV_device_generated_commands_compute";
    public static final String VK_NV_EXTENSION_430_EXTENSION_NAME = "VK_NV_extension_430";
    public static final String VK_NV_LINEAR_COLOR_ATTACHMENT_EXTENSION_NAME = "VK_NV_linear_color_attachment";
    public static final String VK_NV_EXTENSION_432_EXTENSION_NAME = "VK_NV_extension_432";
    public static final String VK_NV_EXTENSION_433_EXTENSION_NAME = "VK_NV_extension_433";
    public static final String VK_GOOGLE_SURFACELESS_QUERY_EXTENSION_NAME = "VK_GOOGLE_surfaceless_query";
    public static final String VK_KHR_SHADER_MAXIMAL_RECONVERGENCE_EXTENSION_NAME = "VK_KHR_shader_maximal_reconvergence";
    public static final String VK_EXT_APPLICATION_PARAMETERS_EXTENSION_NAME = "VK_EXT_application_parameters";
    public static final String VK_EXT_EXTENSION_437_EXTENSION_NAME = "VK_EXT_extension_437";
    public static final String VK_EXT_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_EXTENSION_NAME = "VK_EXT_image_compression_control_swapchain";
    public static final String VK_SEC_EXTENSION_439_EXTENSION_NAME = "VK_SEC_extension_439";
    public static final String VK_QCOM_EXTENSION_440_EXTENSION_NAME = "VK_QCOM_extension_440";
    public static final String VK_QCOM_IMAGE_PROCESSING_EXTENSION_NAME = "VK_QCOM_image_processing";
    public static final String VK_COREAVI_EXTENSION_442_EXTENSION_NAME = "VK_COREAVI_extension_442";
    public static final String VK_COREAVI_EXTENSION_443_EXTENSION_NAME = "VK_COREAVI_extension_443";
    public static final String VK_COREAVI_EXTENSION_444_EXTENSION_NAME = "VK_COREAVI_extension_444";
    public static final String VK_COREAVI_EXTENSION_445_EXTENSION_NAME = "VK_COREAVI_extension_445";
    public static final String VK_COREAVI_EXTENSION_446_EXTENSION_NAME = "VK_COREAVI_extension_446";
    public static final String VK_COREAVI_EXTENSION_447_EXTENSION_NAME = "VK_COREAVI_extension_447";
    public static final String VK_SEC_EXTENSION_448_EXTENSION_NAME = "VK_SEC_extension_448";
    public static final String VK_SEC_EXTENSION_449_EXTENSION_NAME = "VK_SEC_extension_449";
    public static final String VK_SEC_EXTENSION_450_EXTENSION_NAME = "VK_SEC_extension_450";
    public static final String VK_SEC_EXTENSION_451_EXTENSION_NAME = "VK_SEC_extension_451";
    public static final String VK_EXT_NESTED_COMMAND_BUFFER_EXTENSION_NAME = "VK_EXT_nested_command_buffer";
    public static final String VK_ARM_EXTENSION_453_EXTENSION_NAME = "VK_ARM_extension_453";
    public static final String VK_EXT_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXTENSION_NAME = "VK_EXT_external_memory_acquire_unmodified";
    public static final String VK_GOOGLE_EXTENSION_455_EXTENSION_NAME = "VK_GOOGLE_extension_455";
    public static final String VK_EXT_EXTENDED_DYNAMIC_STATE_3_EXTENSION_NAME = "VK_EXT_extended_dynamic_state3";
    public static final String VK_EXT_EXTENSION_457_EXTENSION_NAME = "VK_EXT_extension_457";
    public static final String VK_EXT_EXTENSION_458_EXTENSION_NAME = "VK_EXT_extension_458";
    public static final String VK_EXT_SUBPASS_MERGE_FEEDBACK_EXTENSION_NAME = "VK_EXT_subpass_merge_feedback";
    public static final String VK_LUNARG_DIRECT_DRIVER_LOADING_EXTENSION_NAME = "VK_LUNARG_direct_driver_loading";
    public static final String VK_EXT_EXTENSION_461_EXTENSION_NAME = "VK_EXT_extension_461";
    public static final String VK_EXT_EXTENSION_462_EXTENSION_NAME = "VK_EXT_extension_462";
    public static final String VK_EXT_SHADER_MODULE_IDENTIFIER_EXTENSION_NAME = "VK_EXT_shader_module_identifier";
    public static final String VK_EXT_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_EXTENSION_NAME = "VK_EXT_rasterization_order_attachment_access";
    public static final String VK_NV_OPTICAL_FLOW_EXTENSION_NAME = "VK_NV_optical_flow";
    public static final String VK_EXT_LEGACY_DITHERING_EXTENSION_NAME = "VK_EXT_legacy_dithering";
    public static final String VK_EXT_PIPELINE_PROTECTED_ACCESS_EXTENSION_NAME = "VK_EXT_pipeline_protected_access";
    public static final String VK_EXT_EXTENSION_468_EXTENSION_NAME = "VK_EXT_extension_468";
    public static final String VK_ANDROID_EXTERNAL_FORMAT_RESOLVE_EXTENSION_NAME = "VK_ANDROID_external_format_resolve";
    public static final String VK_AMD_EXTENSION_470_EXTENSION_NAME = "VK_AMD_extension_470";
    public static final String VK_KHR_MAINTENANCE_5_EXTENSION_NAME = "VK_KHR_maintenance5";
    public static final String VK_AMD_EXTENSION_472_EXTENSION_NAME = "VK_AMD_extension_472";
    public static final String VK_AMD_EXTENSION_473_EXTENSION_NAME = "VK_AMD_extension_473";
    public static final String VK_AMD_EXTENSION_474_EXTENSION_NAME = "VK_AMD_extension_474";
    public static final String VK_AMD_EXTENSION_475_EXTENSION_NAME = "VK_AMD_extension_475";
    public static final String VK_AMD_EXTENSION_476_EXTENSION_NAME = "VK_AMD_extension_476";
    public static final String VK_AMD_ANTI_LAG_EXTENSION_NAME = "VK_AMD_anti_lag";
    public static final String VK_AMD_EXTENSION_478_EXTENSION_NAME = "VK_AMD_extension_478";
    public static final String VK_AMD_EXTENSION_479_EXTENSION_NAME = "VK_AMD_extension_479";
    public static final String VK_EXT_EXTENSION_480_EXTENSION_NAME = "VK_EXT_extension_480";
    public static final String VK_EXT_EXTENSION_481_EXTENSION_NAME = "VK_EXT_extension_481";
    public static final String VK_KHR_RAY_TRACING_POSITION_FETCH_EXTENSION_NAME = "VK_KHR_ray_tracing_position_fetch";
    public static final String VK_EXT_SHADER_OBJECT_EXTENSION_NAME = "VK_EXT_shader_object";
    public static final String VK_KHR_PIPELINE_BINARY_EXTENSION_NAME = "VK_KHR_pipeline_binary";
    public static final String VK_QCOM_TILE_PROPERTIES_EXTENSION_NAME = "VK_QCOM_tile_properties";
    public static final String VK_SEC_AMIGO_PROFILING_EXTENSION_NAME = "VK_SEC_amigo_profiling";
    public static final String VK_EXT_EXTENSION_487_EXTENSION_NAME = "VK_EXT_extension_487";
    public static final String VK_EXT_EXTENSION_488_EXTENSION_NAME = "VK_EXT_extension_488";
    public static final String VK_QCOM_MULTIVIEW_PER_VIEW_VIEWPORTS_EXTENSION_NAME = "VK_QCOM_multiview_per_view_viewports";
    public static final String VK_NV_EXTERNAL_SCI_SYNC_2_EXTENSION_NAME = "VK_NV_external_sci_sync2";
    public static final String VK_NV_RAY_TRACING_INVOCATION_REORDER_EXTENSION_NAME = "VK_NV_ray_tracing_invocation_reorder";
    public static final String VK_NV_EXTENSION_492_EXTENSION_NAME = "VK_NV_extension_492";
    public static final String VK_NV_EXTENDED_SPARSE_ADDRESS_SPACE_EXTENSION_NAME = "VK_NV_extended_sparse_address_space";
    public static final String VK_NV_EXTENSION_494_EXTENSION_NAME = "VK_NV_extension_494";
    public static final String VK_EXT_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME = "VK_EXT_mutable_descriptor_type";
    public static final String VK_EXT_LEGACY_VERTEX_ATTRIBUTES_EXTENSION_NAME = "VK_EXT_legacy_vertex_attributes";
    public static final String VK_EXT_LAYER_SETTINGS_EXTENSION_NAME = "VK_EXT_layer_settings";
    public static final String VK_ARM_SHADER_CORE_BUILTINS_EXTENSION_NAME = "VK_ARM_shader_core_builtins";
    public static final String VK_EXT_PIPELINE_LIBRARY_GROUP_HANDLES_EXTENSION_NAME = "VK_EXT_pipeline_library_group_handles";
    public static final String VK_EXT_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_EXTENSION_NAME = "VK_EXT_dynamic_rendering_unused_attachments";
    public static final String VK_EXT_EXTENSION_501_EXTENSION_NAME = "VK_EXT_extension_501";
    public static final String VK_EXT_EXTENSION_502_EXTENSION_NAME = "VK_EXT_extension_502";
    public static final String VK_EXT_EXTENSION_503_EXTENSION_NAME = "VK_EXT_extension_503";
    public static final String VK_NV_EXTENSION_504_EXTENSION_NAME = "VK_NV_extension_504";
    public static final String VK_EXT_EXTENSION_505_EXTENSION_NAME = "VK_EXT_extension_505";
    public static final String VK_NV_LOW_LATENCY_2_EXTENSION_NAME = "VK_NV_low_latency2";
    public static final String VK_KHR_COOPERATIVE_MATRIX_EXTENSION_NAME = "VK_KHR_cooperative_matrix";
    public static final String VK_EXT_EXTENSION_508_EXTENSION_NAME = "VK_EXT_extension_508";
    public static final String VK_EXT_EXTENSION_509_EXTENSION_NAME = "VK_EXT_extension_509";
    public static final String VK_MESA_EXTENSION_510_EXTENSION_NAME = "VK_MESA_extension_510";
    public static final String VK_QCOM_MULTIVIEW_PER_VIEW_RENDER_AREAS_EXTENSION_NAME = "VK_QCOM_multiview_per_view_render_areas";
    public static final String VK_KHR_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME = "VK_KHR_compute_shader_derivatives";
    public static final String VK_KHR_VIDEO_DECODE_AV1_EXTENSION_NAME = "VK_KHR_video_decode_av1";
    public static final String VK_KHR_EXTENSION_514_EXTENSION_NAME = "VK_KHR_extension_514";
    public static final String VK_KHR_EXTENSION_515_EXTENSION_NAME = "VK_KHR_extension_515";
    public static final String VK_KHR_VIDEO_MAINTENANCE_1_EXTENSION_NAME = "VK_KHR_video_maintenance1";
    public static final String VK_NV_PER_STAGE_DESCRIPTOR_SET_EXTENSION_NAME = "VK_NV_per_stage_descriptor_set";
    public static final String VK_MESA_EXTENSION_518_EXTENSION_NAME = "VK_MESA_extension_518";
    public static final String VK_QCOM_IMAGE_PROCESSING_2_EXTENSION_NAME = "VK_QCOM_image_processing2";
    public static final String VK_QCOM_FILTER_CUBIC_WEIGHTS_EXTENSION_NAME = "VK_QCOM_filter_cubic_weights";
    public static final String VK_QCOM_YCBCR_DEGAMMA_EXTENSION_NAME = "VK_QCOM_ycbcr_degamma";
    public static final String VK_QCOM_FILTER_CUBIC_CLAMP_EXTENSION_NAME = "VK_QCOM_filter_cubic_clamp";
    public static final String VK_EXT_EXTENSION_523_EXTENSION_NAME = "VK_EXT_extension_523";
    public static final String VK_EXT_EXTENSION_524_EXTENSION_NAME = "VK_EXT_extension_524";
    public static final String VK_EXT_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_EXTENSION_NAME = "VK_EXT_attachment_feedback_loop_dynamic_state";
    public static final String VK_KHR_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME = "VK_KHR_vertex_attribute_divisor";
    public static final String VK_KHR_LOAD_STORE_OP_NONE_EXTENSION_NAME = "VK_KHR_load_store_op_none";
    public static final String VK_EXT_EXTENSION_528_EXTENSION_NAME = "VK_EXT_extension_528";
    public static final String VK_KHR_SHADER_FLOAT_CONTROLS_2_EXTENSION_NAME = "VK_KHR_shader_float_controls2";
    public static final String VK_QNX_EXTERNAL_MEMORY_SCREEN_BUFFER_EXTENSION_NAME = "VK_QNX_external_memory_screen_buffer";
    public static final String VK_MSFT_LAYERED_DRIVER_EXTENSION_NAME = "VK_MSFT_layered_driver";
    public static final String VK_KHR_EXTENSION_532_EXTENSION_NAME = "VK_KHR_extension_532";
    public static final String VK_EXT_EXTENSION_533_EXTENSION_NAME = "VK_EXT_extension_533";
    public static final String VK_KHR_INDEX_TYPE_UINT8_EXTENSION_NAME = "VK_KHR_index_type_uint8";
    public static final String VK_KHR_LINE_RASTERIZATION_EXTENSION_NAME = "VK_KHR_line_rasterization";
    public static final String VK_QCOM_EXTENSION_536_EXTENSION_NAME = "VK_QCOM_extension_536";
    public static final String VK_EXT_EXTENSION_537_EXTENSION_NAME = "VK_EXT_extension_537";
    public static final String VK_EXT_EXTENSION_538_EXTENSION_NAME = "VK_EXT_extension_538";
    public static final String VK_EXT_EXTENSION_539_EXTENSION_NAME = "VK_EXT_extension_539";
    public static final String VK_EXT_EXTENSION_540_EXTENSION_NAME = "VK_EXT_extension_540";
    public static final String VK_EXT_EXTENSION_541_EXTENSION_NAME = "VK_EXT_extension_541";
    public static final String VK_EXT_EXTENSION_542_EXTENSION_NAME = "VK_EXT_extension_542";
    public static final String VK_EXT_EXTENSION_543_EXTENSION_NAME = "VK_EXT_extension_543";
    public static final String VK_KHR_CALIBRATED_TIMESTAMPS_EXTENSION_NAME = "VK_KHR_calibrated_timestamps";
    public static final String VK_KHR_SHADER_EXPECT_ASSUME_EXTENSION_NAME = "VK_KHR_shader_expect_assume";
    public static final String VK_KHR_MAINTENANCE_6_EXTENSION_NAME = "VK_KHR_maintenance6";
    public static final String VK_NV_DESCRIPTOR_POOL_OVERALLOCATION_EXTENSION_NAME = "VK_NV_descriptor_pool_overallocation";
    public static final String VK_QCOM_EXTENSION_548_EXTENSION_NAME = "VK_QCOM_extension_548";
    public static final String VK_NV_EXTENSION_549_EXTENSION_NAME = "VK_NV_extension_549";
    public static final String VK_NV_EXTENSION_550_EXTENSION_NAME = "VK_NV_extension_550";
    public static final String VK_NV_EXTENSION_551_EXTENSION_NAME = "VK_NV_extension_551";
    public static final String VK_NV_EXTENSION_552_EXTENSION_NAME = "VK_NV_extension_552";
    public static final String VK_KHR_EXTENSION_553_EXTENSION_NAME = "VK_KHR_extension_553";
    public static final String VK_KHR_EXTENSION_554_EXTENSION_NAME = "VK_KHR_extension_554";
    public static final String VK_IMG_EXTENSION_555_EXTENSION_NAME = "VK_IMG_extension_555";
    public static final String VK_NV_RAW_ACCESS_CHAINS_EXTENSION_NAME = "VK_NV_raw_access_chains";
    public static final String VK_NV_EXTENSION_557_EXTENSION_NAME = "VK_NV_extension_557";
    public static final String VK_KHR_EXTENSION_558_EXTENSION_NAME = "VK_KHR_extension_558";
    public static final String VK_KHR_SHADER_RELAXED_EXTENDED_INSTRUCTION_EXTENSION_NAME = "VK_KHR_shader_relaxed_extended_instruction";
    public static final String VK_NV_COMMAND_BUFFER_INHERITANCE_EXTENSION_NAME = "VK_NV_command_buffer_inheritance";
    public static final String VK_EXT_EXTENSION_561_EXTENSION_NAME = "VK_EXT_extension_561";
    public static final String VK_KHR_EXTENSION_562_EXTENSION_NAME = "VK_KHR_extension_562";
    public static final String VK_KHR_MAINTENANCE_7_EXTENSION_NAME = "VK_KHR_maintenance7";
    public static final String VK_NV_SHADER_ATOMIC_FLOAT16_VECTOR_EXTENSION_NAME = "VK_NV_shader_atomic_float16_vector";
    public static final String VK_EXT_SHADER_REPLICATED_COMPOSITES_EXTENSION_NAME = "VK_EXT_shader_replicated_composites";
    public static final String VK_ARM_EXTENSION_566_EXTENSION_NAME = "VK_ARM_extension_566";
    public static final String VK_ARM_EXTENSION_567_EXTENSION_NAME = "VK_ARM_extension_567";
    public static final String VK_ARM_EXTENSION_568_EXTENSION_NAME = "VK_ARM_extension_568";
    public static final String VK_NV_RAY_TRACING_VALIDATION_EXTENSION_NAME = "VK_NV_ray_tracing_validation";
    public static final String VK_NV_EXTENSION_570_EXTENSION_NAME = "VK_NV_extension_570";
    public static final String VK_NV_EXTENSION_571_EXTENSION_NAME = "VK_NV_extension_571";
    public static final String VK_NV_EXTENSION_572_EXTENSION_NAME = "VK_NV_extension_572";
    public static final String VK_EXT_EXTENSION_573_EXTENSION_NAME = "VK_EXT_extension_573";
    public static final String VK_KHR_EXTENSION_574_EXTENSION_NAME = "VK_KHR_extension_574";
    public static final String VK_KHR_EXTENSION_575_EXTENSION_NAME = "VK_KHR_extension_575";
    public static final String VK_MESA_IMAGE_ALIGNMENT_CONTROL_EXTENSION_NAME = "VK_MESA_image_alignment_control";
    public static final String VK_HUAWEI_EXTENSION_577_EXTENSION_NAME = "VK_HUAWEI_extension_577";
    public static final String VK_EXT_EXTENSION_578_EXTENSION_NAME = "VK_EXT_extension_578";
    public static final String VK_EXT_EXTENSION_579_EXTENSION_NAME = "VK_EXT_extension_579";
    public static final String VK_EXT_EXTENSION_580_EXTENSION_NAME = "VK_EXT_extension_580";
    public static final String VK_NV_EXTENSION_581_EXTENSION_NAME = "VK_NV_extension_581";
    public static final String VK_EXT_EXTENSION_582_EXTENSION_NAME = "VK_EXT_extension_582";
    public static final String VK_EXT_EXTENSION_583_EXTENSION_NAME = "VK_EXT_extension_583";
    public static final String VK_EXT_EXTENSION_584_EXTENSION_NAME = "VK_EXT_extension_584";
    public static final String VK_EXT_EXTENSION_585_EXTENSION_NAME = "VK_EXT_extension_585";
    public static final String VK_IMG_EXTENSION_586_EXTENSION_NAME = "VK_IMG_extension_586";
    public static final String VK_KHR_EXTENSION_587_EXTENSION_NAME = "VK_KHR_extension_587";
    public static final String VK_HUAWEI_EXTENSION_588_EXTENSION_NAME = "VK_HUAWEI_extension_588";
    public static final String VK_HUAWEI_EXTENSION_589_EXTENSION_NAME = "VK_HUAWEI_extension_589";
    public static final String VK_HUAWEI_EXTENSION_590_EXTENSION_NAME = "VK_HUAWEI_extension_590";
    public static final String VK_EXT_EXTENSION_591_EXTENSION_NAME = "VK_EXT_extension_591";
    public static final String VK_NV_EXTENSION_592_EXTENSION_NAME = "VK_NV_extension_592";
    public static final String VK_NV_EXTENSION_593_EXTENSION_NAME = "VK_NV_extension_593";
    public static final String VK_NV_EXTENSION_594_EXTENSION_NAME = "VK_NV_extension_594";
    public static final String VK_NV_EXTENSION_595_EXTENSION_NAME = "VK_NV_extension_595";
    public static final String VK_KHR_EXTENSION_596_EXTENSION_NAME = "VK_KHR_extension_596";
    public static final String VK_ARM_EXTENSION_597_EXTENSION_NAME = "VK_ARM_extension_597";
    public static final String VK_KHR_EXTENSION_598_EXTENSION_NAME = "VK_KHR_extension_598";
    public static final String VK_KHR_EXTENSION_599_EXTENSION_NAME = "VK_KHR_extension_599";
    public static final String VK_IMG_EXTENSION_600_EXTENSION_NAME = "VK_IMG_extension_600";
    public static final String VK_IMG_EXTENSION_601_EXTENSION_NAME = "VK_IMG_extension_601";
    public static final String VK_EXT_EXTENSION_602_EXTENSION_NAME = "VK_EXT_extension_602";
    public static final String VK_EXT_EXTENSION_603_EXTENSION_NAME = "VK_EXT_extension_603";
    public static final String VK_EXT_EXTENSION_604_EXTENSION_NAME = "VK_EXT_extension_604";
}
