/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.pointer;
import tech.icey.panama.annotation.unsafe;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.datatype.VkSparseImageMemoryBind;
import tech.icey.vk4j.handle.VkImage;

public record VkSparseImageMemoryBindInfo(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS.withName("image"), ValueLayout.JAVA_INT.withName("bindCount"), ValueLayout.ADDRESS.withTargetLayout(VkSparseImageMemoryBind.LAYOUT).withName("pBinds")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$image = MemoryLayout.PathElement.groupElement("image");
    public static final MemoryLayout.PathElement PATH$bindCount = MemoryLayout.PathElement.groupElement("bindCount");
    public static final MemoryLayout.PathElement PATH$pBinds = MemoryLayout.PathElement.groupElement("pBinds");
    public static final AddressLayout LAYOUT$image = (AddressLayout)LAYOUT.select(PATH$image);
    public static final ValueLayout.OfInt LAYOUT$bindCount = (ValueLayout.OfInt)LAYOUT.select(PATH$bindCount);
    public static final AddressLayout LAYOUT$pBinds = (AddressLayout)LAYOUT.select(PATH$pBinds);
    public static final long OFFSET$image = LAYOUT.byteOffset(PATH$image);
    public static final long OFFSET$bindCount = LAYOUT.byteOffset(PATH$bindCount);
    public static final long OFFSET$pBinds = LAYOUT.byteOffset(PATH$pBinds);
    public static final long SIZE$image = LAYOUT$image.byteSize();
    public static final long SIZE$bindCount = LAYOUT$bindCount.byteSize();
    public static final long SIZE$pBinds = LAYOUT$pBinds.byteSize();

    @nullable
    public VkImage image() {
        MemorySegment s = this.segment.get(LAYOUT$image, OFFSET$image);
        if (s.address() == 0L) {
            return null;
        }
        return new VkImage(s);
    }

    public void image(@nullable VkImage value) {
        this.segment.set(LAYOUT$image, OFFSET$image, value != null ? value.segment() : MemorySegment.NULL);
    }

    @unsigned
    public int bindCount() {
        return this.segment.get(LAYOUT$bindCount, OFFSET$bindCount);
    }

    public void bindCount(@unsigned int value) {
        this.segment.set(LAYOUT$bindCount, OFFSET$bindCount, value);
    }

    @pointer(comment="VkSparseImageMemoryBind*")
    public MemorySegment pBindsRaw() {
        return this.segment.get(LAYOUT$pBinds, OFFSET$pBinds);
    }

    public void pBindsRaw(@pointer(comment="VkSparseImageMemoryBind*") MemorySegment value) {
        this.segment.set(LAYOUT$pBinds, OFFSET$pBinds, value);
    }

    @nullable
    public VkSparseImageMemoryBind pBinds() {
        MemorySegment s = this.pBindsRaw();
        if (s.address() == 0L) {
            return null;
        }
        return new VkSparseImageMemoryBind(s);
    }

    @unsafe
    @nullable
    public VkSparseImageMemoryBind[] pBinds(int assumedCount) {
        MemorySegment s = this.pBindsRaw().reinterpret((long)assumedCount * VkSparseImageMemoryBind.SIZE);
        VkSparseImageMemoryBind[] arr = new VkSparseImageMemoryBind[assumedCount];
        for (int i = 0; i < assumedCount; ++i) {
            arr[i] = new VkSparseImageMemoryBind(s.asSlice((long)i * VkSparseImageMemoryBind.SIZE, VkSparseImageMemoryBind.SIZE));
        }
        return arr;
    }

    public void pBinds(@nullable VkSparseImageMemoryBind value) {
        this.pBindsRaw(value == null ? MemorySegment.NULL : value.segment());
    }

    public static VkSparseImageMemoryBindInfo allocate(Arena arena) {
        return new VkSparseImageMemoryBindInfo(arena.allocate(LAYOUT));
    }

    public static VkSparseImageMemoryBindInfo[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkSparseImageMemoryBindInfo[] ret = new VkSparseImageMemoryBindInfo[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkSparseImageMemoryBindInfo(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkSparseImageMemoryBindInfo clone(Arena arena, VkSparseImageMemoryBindInfo src) {
        VkSparseImageMemoryBindInfo ret = VkSparseImageMemoryBindInfo.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkSparseImageMemoryBindInfo[] clone(Arena arena, VkSparseImageMemoryBindInfo[] src) {
        VkSparseImageMemoryBindInfo[] ret = VkSparseImageMemoryBindInfo.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

