/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.pointer;
import tech.icey.panama.annotation.unsafe;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.datatype.VkSparseMemoryBind;
import tech.icey.vk4j.handle.VkBuffer;

public record VkSparseBufferMemoryBindInfo(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS.withName("buffer"), ValueLayout.JAVA_INT.withName("bindCount"), ValueLayout.ADDRESS.withTargetLayout(VkSparseMemoryBind.LAYOUT).withName("pBinds")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$buffer = MemoryLayout.PathElement.groupElement("buffer");
    public static final MemoryLayout.PathElement PATH$bindCount = MemoryLayout.PathElement.groupElement("bindCount");
    public static final MemoryLayout.PathElement PATH$pBinds = MemoryLayout.PathElement.groupElement("pBinds");
    public static final AddressLayout LAYOUT$buffer = (AddressLayout)LAYOUT.select(PATH$buffer);
    public static final ValueLayout.OfInt LAYOUT$bindCount = (ValueLayout.OfInt)LAYOUT.select(PATH$bindCount);
    public static final AddressLayout LAYOUT$pBinds = (AddressLayout)LAYOUT.select(PATH$pBinds);
    public static final long OFFSET$buffer = LAYOUT.byteOffset(PATH$buffer);
    public static final long OFFSET$bindCount = LAYOUT.byteOffset(PATH$bindCount);
    public static final long OFFSET$pBinds = LAYOUT.byteOffset(PATH$pBinds);
    public static final long SIZE$buffer = LAYOUT$buffer.byteSize();
    public static final long SIZE$bindCount = LAYOUT$bindCount.byteSize();
    public static final long SIZE$pBinds = LAYOUT$pBinds.byteSize();

    @nullable
    public VkBuffer buffer() {
        MemorySegment s = this.segment.get(LAYOUT$buffer, OFFSET$buffer);
        if (s.address() == 0L) {
            return null;
        }
        return new VkBuffer(s);
    }

    public void buffer(@nullable VkBuffer value) {
        this.segment.set(LAYOUT$buffer, OFFSET$buffer, value != null ? value.segment() : MemorySegment.NULL);
    }

    @unsigned
    public int bindCount() {
        return this.segment.get(LAYOUT$bindCount, OFFSET$bindCount);
    }

    public void bindCount(@unsigned int value) {
        this.segment.set(LAYOUT$bindCount, OFFSET$bindCount, value);
    }

    @pointer(comment="VkSparseMemoryBind*")
    public MemorySegment pBindsRaw() {
        return this.segment.get(LAYOUT$pBinds, OFFSET$pBinds);
    }

    public void pBindsRaw(@pointer(comment="VkSparseMemoryBind*") MemorySegment value) {
        this.segment.set(LAYOUT$pBinds, OFFSET$pBinds, value);
    }

    @nullable
    public VkSparseMemoryBind pBinds() {
        MemorySegment s = this.pBindsRaw();
        if (s.address() == 0L) {
            return null;
        }
        return new VkSparseMemoryBind(s);
    }

    @unsafe
    @nullable
    public VkSparseMemoryBind[] pBinds(int assumedCount) {
        MemorySegment s = this.pBindsRaw().reinterpret((long)assumedCount * VkSparseMemoryBind.SIZE);
        VkSparseMemoryBind[] arr = new VkSparseMemoryBind[assumedCount];
        for (int i = 0; i < assumedCount; ++i) {
            arr[i] = new VkSparseMemoryBind(s.asSlice((long)i * VkSparseMemoryBind.SIZE, VkSparseMemoryBind.SIZE));
        }
        return arr;
    }

    public void pBinds(@nullable VkSparseMemoryBind value) {
        this.pBindsRaw(value == null ? MemorySegment.NULL : value.segment());
    }

    public static VkSparseBufferMemoryBindInfo allocate(Arena arena) {
        return new VkSparseBufferMemoryBindInfo(arena.allocate(LAYOUT));
    }

    public static VkSparseBufferMemoryBindInfo[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkSparseBufferMemoryBindInfo[] ret = new VkSparseBufferMemoryBindInfo[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkSparseBufferMemoryBindInfo(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkSparseBufferMemoryBindInfo clone(Arena arena, VkSparseBufferMemoryBindInfo src) {
        VkSparseBufferMemoryBindInfo ret = VkSparseBufferMemoryBindInfo.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkSparseBufferMemoryBindInfo[] clone(Arena arena, VkSparseBufferMemoryBindInfo[] src) {
        VkSparseBufferMemoryBindInfo[] ret = VkSparseBufferMemoryBindInfo.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

