/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.unsigned;

public record VkMemoryRequirements(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_LONG.withName("size"), ValueLayout.JAVA_LONG.withName("alignment"), ValueLayout.JAVA_INT.withName("memoryTypeBits")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$size = MemoryLayout.PathElement.groupElement("size");
    public static final MemoryLayout.PathElement PATH$alignment = MemoryLayout.PathElement.groupElement("alignment");
    public static final MemoryLayout.PathElement PATH$memoryTypeBits = MemoryLayout.PathElement.groupElement("memoryTypeBits");
    public static final ValueLayout.OfLong LAYOUT$size = (ValueLayout.OfLong)LAYOUT.select(PATH$size);
    public static final ValueLayout.OfLong LAYOUT$alignment = (ValueLayout.OfLong)LAYOUT.select(PATH$alignment);
    public static final ValueLayout.OfInt LAYOUT$memoryTypeBits = (ValueLayout.OfInt)LAYOUT.select(PATH$memoryTypeBits);
    public static final long OFFSET$size = LAYOUT.byteOffset(PATH$size);
    public static final long OFFSET$alignment = LAYOUT.byteOffset(PATH$alignment);
    public static final long OFFSET$memoryTypeBits = LAYOUT.byteOffset(PATH$memoryTypeBits);
    public static final long SIZE$size = LAYOUT$size.byteSize();
    public static final long SIZE$alignment = LAYOUT$alignment.byteSize();
    public static final long SIZE$memoryTypeBits = LAYOUT$memoryTypeBits.byteSize();

    @unsigned
    public long size() {
        return this.segment.get(LAYOUT$size, OFFSET$size);
    }

    public void size(@unsigned long value) {
        this.segment.set(LAYOUT$size, OFFSET$size, value);
    }

    @unsigned
    public long alignment() {
        return this.segment.get(LAYOUT$alignment, OFFSET$alignment);
    }

    public void alignment(@unsigned long value) {
        this.segment.set(LAYOUT$alignment, OFFSET$alignment, value);
    }

    @unsigned
    public int memoryTypeBits() {
        return this.segment.get(LAYOUT$memoryTypeBits, OFFSET$memoryTypeBits);
    }

    public void memoryTypeBits(@unsigned int value) {
        this.segment.set(LAYOUT$memoryTypeBits, OFFSET$memoryTypeBits, value);
    }

    public static VkMemoryRequirements allocate(Arena arena) {
        return new VkMemoryRequirements(arena.allocate(LAYOUT));
    }

    public static VkMemoryRequirements[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkMemoryRequirements[] ret = new VkMemoryRequirements[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkMemoryRequirements(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkMemoryRequirements clone(Arena arena, VkMemoryRequirements src) {
        VkMemoryRequirements ret = VkMemoryRequirements.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkMemoryRequirements[] clone(Arena arena, VkMemoryRequirements[] src) {
        VkMemoryRequirements[] ret = VkMemoryRequirements.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

