/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.vk4j.bitmask.VkExternalMemoryFeatureFlags;
import tech.icey.vk4j.bitmask.VkExternalMemoryHandleTypeFlags;

public record VkExternalMemoryProperties(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_INT.withName("externalMemoryFeatures"), ValueLayout.JAVA_INT.withName("exportFromImportedHandleTypes"), ValueLayout.JAVA_INT.withName("compatibleHandleTypes")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$externalMemoryFeatures = MemoryLayout.PathElement.groupElement("externalMemoryFeatures");
    public static final MemoryLayout.PathElement PATH$exportFromImportedHandleTypes = MemoryLayout.PathElement.groupElement("exportFromImportedHandleTypes");
    public static final MemoryLayout.PathElement PATH$compatibleHandleTypes = MemoryLayout.PathElement.groupElement("compatibleHandleTypes");
    public static final ValueLayout.OfInt LAYOUT$externalMemoryFeatures = (ValueLayout.OfInt)LAYOUT.select(PATH$externalMemoryFeatures);
    public static final ValueLayout.OfInt LAYOUT$exportFromImportedHandleTypes = (ValueLayout.OfInt)LAYOUT.select(PATH$exportFromImportedHandleTypes);
    public static final ValueLayout.OfInt LAYOUT$compatibleHandleTypes = (ValueLayout.OfInt)LAYOUT.select(PATH$compatibleHandleTypes);
    public static final long OFFSET$externalMemoryFeatures = LAYOUT.byteOffset(PATH$externalMemoryFeatures);
    public static final long OFFSET$exportFromImportedHandleTypes = LAYOUT.byteOffset(PATH$exportFromImportedHandleTypes);
    public static final long OFFSET$compatibleHandleTypes = LAYOUT.byteOffset(PATH$compatibleHandleTypes);
    public static final long SIZE$externalMemoryFeatures = LAYOUT$externalMemoryFeatures.byteSize();
    public static final long SIZE$exportFromImportedHandleTypes = LAYOUT$exportFromImportedHandleTypes.byteSize();
    public static final long SIZE$compatibleHandleTypes = LAYOUT$compatibleHandleTypes.byteSize();

    @enumtype(value=VkExternalMemoryFeatureFlags.class)
    public int externalMemoryFeatures() {
        return this.segment.get(LAYOUT$externalMemoryFeatures, OFFSET$externalMemoryFeatures);
    }

    public void externalMemoryFeatures(@enumtype(value=VkExternalMemoryFeatureFlags.class) int value) {
        this.segment.set(LAYOUT$externalMemoryFeatures, OFFSET$externalMemoryFeatures, value);
    }

    @enumtype(value=VkExternalMemoryHandleTypeFlags.class)
    public int exportFromImportedHandleTypes() {
        return this.segment.get(LAYOUT$exportFromImportedHandleTypes, OFFSET$exportFromImportedHandleTypes);
    }

    public void exportFromImportedHandleTypes(@enumtype(value=VkExternalMemoryHandleTypeFlags.class) int value) {
        this.segment.set(LAYOUT$exportFromImportedHandleTypes, OFFSET$exportFromImportedHandleTypes, value);
    }

    @enumtype(value=VkExternalMemoryHandleTypeFlags.class)
    public int compatibleHandleTypes() {
        return this.segment.get(LAYOUT$compatibleHandleTypes, OFFSET$compatibleHandleTypes);
    }

    public void compatibleHandleTypes(@enumtype(value=VkExternalMemoryHandleTypeFlags.class) int value) {
        this.segment.set(LAYOUT$compatibleHandleTypes, OFFSET$compatibleHandleTypes, value);
    }

    public static VkExternalMemoryProperties allocate(Arena arena) {
        return new VkExternalMemoryProperties(arena.allocate(LAYOUT));
    }

    public static VkExternalMemoryProperties[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkExternalMemoryProperties[] ret = new VkExternalMemoryProperties[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkExternalMemoryProperties(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkExternalMemoryProperties clone(Arena arena, VkExternalMemoryProperties src) {
        VkExternalMemoryProperties ret = VkExternalMemoryProperties.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkExternalMemoryProperties[] clone(Arena arena, VkExternalMemoryProperties[] src) {
        VkExternalMemoryProperties[] ret = VkExternalMemoryProperties.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

