package tech.icey.vk4j.datatype;

import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.pointer;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.enumtype.VkStructureType;

import java.lang.foreign.*;

import static java.lang.foreign.ValueLayout.OfInt;
import static java.lang.foreign.ValueLayout.PathElement;
import static tech.icey.vk4j.enumtype.VkStructureType.VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV;

/// {@snippet lang=c :
/// typedef struct VkDedicatedAllocationImageCreateInfoNV {
///     VkStructureType sType;
///     const void* pNext;
///     VkBool32 dedicatedAllocation;
/// } VkDedicatedAllocationImageCreateInfoNV;}
///
/// @see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationImageCreateInfoNV.html">VkDedicatedAllocationImageCreateInfoNV</a>
public record VkDedicatedAllocationImageCreateInfoNV(MemorySegment segment) implements IPointer {
    public VkDedicatedAllocationImageCreateInfoNV(MemorySegment segment) {
        this.segment = segment;
        this.sType(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV);
    }

    public @enumtype(VkStructureType.class) int sType() {
        return segment.get(LAYOUT$sType, OFFSET$sType);
    }

    public void sType(@enumtype(VkStructureType.class) int value) {
        segment.set(LAYOUT$sType, OFFSET$sType, value);
    }

    public @pointer(comment="void*") MemorySegment pNext() {
        return segment.get(LAYOUT$pNext, OFFSET$pNext);
    }

    public void pNext(@pointer(comment="void*") MemorySegment value) {
        segment.set(LAYOUT$pNext, OFFSET$pNext, value);
    }

    public void pNext(@nullable IPointer pointer) {
        pNext(pointer == null ? MemorySegment.NULL : pointer.segment());
    }

    public @unsigned int dedicatedAllocation() {
        return segment.get(LAYOUT$dedicatedAllocation, OFFSET$dedicatedAllocation);
    }

    public void dedicatedAllocation(@unsigned int value) {
        segment.set(LAYOUT$dedicatedAllocation, OFFSET$dedicatedAllocation, value);
    }

    public static VkDedicatedAllocationImageCreateInfoNV allocate(Arena arena) {
        return new VkDedicatedAllocationImageCreateInfoNV(arena.allocate(LAYOUT));
    }

    public static VkDedicatedAllocationImageCreateInfoNV[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkDedicatedAllocationImageCreateInfoNV[] ret = new VkDedicatedAllocationImageCreateInfoNV[count];
        for (int i = 0; i < count; i++) {
            ret[i] = new VkDedicatedAllocationImageCreateInfoNV(segment.asSlice(i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkDedicatedAllocationImageCreateInfoNV clone(Arena arena, VkDedicatedAllocationImageCreateInfoNV src) {
        VkDedicatedAllocationImageCreateInfoNV ret = allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkDedicatedAllocationImageCreateInfoNV[] clone(Arena arena, VkDedicatedAllocationImageCreateInfoNV[] src) {
        VkDedicatedAllocationImageCreateInfoNV[] ret = allocate(arena, src.length);
        for (int i = 0; i < src.length; i++) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }

    public static final MemoryLayout LAYOUT = NativeLayout.structLayout(
        ValueLayout.JAVA_INT.withName("sType"),
        ValueLayout.ADDRESS.withName("pNext"),
        ValueLayout.JAVA_INT.withName("dedicatedAllocation")
    );
    public static final long SIZE = LAYOUT.byteSize();

    public static final PathElement PATH$sType = PathElement.groupElement("sType");
    public static final PathElement PATH$pNext = PathElement.groupElement("pNext");
    public static final PathElement PATH$dedicatedAllocation = PathElement.groupElement("dedicatedAllocation");

    public static final OfInt LAYOUT$sType = (OfInt) LAYOUT.select(PATH$sType);
    public static final AddressLayout LAYOUT$pNext = (AddressLayout) LAYOUT.select(PATH$pNext);
    public static final OfInt LAYOUT$dedicatedAllocation = (OfInt) LAYOUT.select(PATH$dedicatedAllocation);

    public static final long OFFSET$sType = LAYOUT.byteOffset(PATH$sType);
    public static final long OFFSET$pNext = LAYOUT.byteOffset(PATH$pNext);
    public static final long OFFSET$dedicatedAllocation = LAYOUT.byteOffset(PATH$dedicatedAllocation);

    public static final long SIZE$sType = LAYOUT$sType.byteSize();
    public static final long SIZE$pNext = LAYOUT$pNext.byteSize();
    public static final long SIZE$dedicatedAllocation = LAYOUT$dedicatedAllocation.byteSize();
}
