/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.bitmask.VkSparseMemoryBindFlags;
import tech.icey.vk4j.handle.VkDeviceMemory;

public record VkSparseMemoryBind(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_LONG.withName("resourceOffset"), ValueLayout.JAVA_LONG.withName("size"), ValueLayout.ADDRESS.withName("memory"), ValueLayout.JAVA_LONG.withName("memoryOffset"), ValueLayout.JAVA_INT.withName("flags")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$resourceOffset = MemoryLayout.PathElement.groupElement("resourceOffset");
    public static final MemoryLayout.PathElement PATH$size = MemoryLayout.PathElement.groupElement("size");
    public static final MemoryLayout.PathElement PATH$memory = MemoryLayout.PathElement.groupElement("memory");
    public static final MemoryLayout.PathElement PATH$memoryOffset = MemoryLayout.PathElement.groupElement("memoryOffset");
    public static final MemoryLayout.PathElement PATH$flags = MemoryLayout.PathElement.groupElement("flags");
    public static final ValueLayout.OfLong LAYOUT$resourceOffset = (ValueLayout.OfLong)LAYOUT.select(PATH$resourceOffset);
    public static final ValueLayout.OfLong LAYOUT$size = (ValueLayout.OfLong)LAYOUT.select(PATH$size);
    public static final AddressLayout LAYOUT$memory = (AddressLayout)LAYOUT.select(PATH$memory);
    public static final ValueLayout.OfLong LAYOUT$memoryOffset = (ValueLayout.OfLong)LAYOUT.select(PATH$memoryOffset);
    public static final ValueLayout.OfInt LAYOUT$flags = (ValueLayout.OfInt)LAYOUT.select(PATH$flags);
    public static final long OFFSET$resourceOffset = LAYOUT.byteOffset(PATH$resourceOffset);
    public static final long OFFSET$size = LAYOUT.byteOffset(PATH$size);
    public static final long OFFSET$memory = LAYOUT.byteOffset(PATH$memory);
    public static final long OFFSET$memoryOffset = LAYOUT.byteOffset(PATH$memoryOffset);
    public static final long OFFSET$flags = LAYOUT.byteOffset(PATH$flags);
    public static final long SIZE$resourceOffset = LAYOUT$resourceOffset.byteSize();
    public static final long SIZE$size = LAYOUT$size.byteSize();
    public static final long SIZE$memory = LAYOUT$memory.byteSize();
    public static final long SIZE$memoryOffset = LAYOUT$memoryOffset.byteSize();
    public static final long SIZE$flags = LAYOUT$flags.byteSize();

    @unsigned
    public long resourceOffset() {
        return this.segment.get(LAYOUT$resourceOffset, OFFSET$resourceOffset);
    }

    public void resourceOffset(@unsigned long value) {
        this.segment.set(LAYOUT$resourceOffset, OFFSET$resourceOffset, value);
    }

    @unsigned
    public long size() {
        return this.segment.get(LAYOUT$size, OFFSET$size);
    }

    public void size(@unsigned long value) {
        this.segment.set(LAYOUT$size, OFFSET$size, value);
    }

    @nullable
    public VkDeviceMemory memory() {
        MemorySegment s = this.segment.get(LAYOUT$memory, OFFSET$memory);
        if (s.address() == 0L) {
            return null;
        }
        return new VkDeviceMemory(s);
    }

    public void memory(@nullable VkDeviceMemory value) {
        this.segment.set(LAYOUT$memory, OFFSET$memory, value != null ? value.segment() : MemorySegment.NULL);
    }

    @unsigned
    public long memoryOffset() {
        return this.segment.get(LAYOUT$memoryOffset, OFFSET$memoryOffset);
    }

    public void memoryOffset(@unsigned long value) {
        this.segment.set(LAYOUT$memoryOffset, OFFSET$memoryOffset, value);
    }

    @enumtype(value=VkSparseMemoryBindFlags.class)
    public int flags() {
        return this.segment.get(LAYOUT$flags, OFFSET$flags);
    }

    public void flags(@enumtype(value=VkSparseMemoryBindFlags.class) int value) {
        this.segment.set(LAYOUT$flags, OFFSET$flags, value);
    }

    public static VkSparseMemoryBind allocate(Arena arena) {
        return new VkSparseMemoryBind(arena.allocate(LAYOUT));
    }

    public static VkSparseMemoryBind[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkSparseMemoryBind[] ret = new VkSparseMemoryBind[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkSparseMemoryBind(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkSparseMemoryBind clone(Arena arena, VkSparseMemoryBind src) {
        VkSparseMemoryBind ret = VkSparseMemoryBind.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkSparseMemoryBind[] clone(Arena arena, VkSparseMemoryBind[] src) {
        VkSparseMemoryBind[] ret = VkSparseMemoryBind.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

