/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.vk4j.datatype;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.unsigned;
import tech.icey.vk4j.enumtype.VkDescriptorType;

public record VkDescriptorPoolSize(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_INT.withName("type"), ValueLayout.JAVA_INT.withName("descriptorCount")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$type = MemoryLayout.PathElement.groupElement("type");
    public static final MemoryLayout.PathElement PATH$descriptorCount = MemoryLayout.PathElement.groupElement("descriptorCount");
    public static final ValueLayout.OfInt LAYOUT$type = (ValueLayout.OfInt)LAYOUT.select(PATH$type);
    public static final ValueLayout.OfInt LAYOUT$descriptorCount = (ValueLayout.OfInt)LAYOUT.select(PATH$descriptorCount);
    public static final long OFFSET$type = LAYOUT.byteOffset(PATH$type);
    public static final long OFFSET$descriptorCount = LAYOUT.byteOffset(PATH$descriptorCount);
    public static final long SIZE$type = LAYOUT$type.byteSize();
    public static final long SIZE$descriptorCount = LAYOUT$descriptorCount.byteSize();

    @enumtype(value=VkDescriptorType.class)
    public int type() {
        return this.segment.get(LAYOUT$type, OFFSET$type);
    }

    public void type(@enumtype(value=VkDescriptorType.class) int value) {
        this.segment.set(LAYOUT$type, OFFSET$type, value);
    }

    @unsigned
    public int descriptorCount() {
        return this.segment.get(LAYOUT$descriptorCount, OFFSET$descriptorCount);
    }

    public void descriptorCount(@unsigned int value) {
        this.segment.set(LAYOUT$descriptorCount, OFFSET$descriptorCount, value);
    }

    public static VkDescriptorPoolSize allocate(Arena arena) {
        return new VkDescriptorPoolSize(arena.allocate(LAYOUT));
    }

    public static VkDescriptorPoolSize[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkDescriptorPoolSize[] ret = new VkDescriptorPoolSize[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new VkDescriptorPoolSize(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkDescriptorPoolSize clone(Arena arena, VkDescriptorPoolSize src) {
        VkDescriptorPoolSize ret = VkDescriptorPoolSize.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkDescriptorPoolSize[] clone(Arena arena, VkDescriptorPoolSize[] src) {
        VkDescriptorPoolSize[] ret = VkDescriptorPoolSize.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

