package tech.icey.vk4j.enumtype;

import tech.icey.panama.annotation.enumtype;

public final class VkObjectType {
    public static final int VK_OBJECT_TYPE_UNKNOWN = 0;
    public static final int VK_OBJECT_TYPE_INSTANCE = 1;
    public static final int VK_OBJECT_TYPE_PHYSICAL_DEVICE = 2;
    public static final int VK_OBJECT_TYPE_DEVICE = 3;
    public static final int VK_OBJECT_TYPE_QUEUE = 4;
    public static final int VK_OBJECT_TYPE_SEMAPHORE = 5;
    public static final int VK_OBJECT_TYPE_COMMAND_BUFFER = 6;
    public static final int VK_OBJECT_TYPE_FENCE = 7;
    public static final int VK_OBJECT_TYPE_DEVICE_MEMORY = 8;
    public static final int VK_OBJECT_TYPE_BUFFER = 9;
    public static final int VK_OBJECT_TYPE_IMAGE = 10;
    public static final int VK_OBJECT_TYPE_EVENT = 11;
    public static final int VK_OBJECT_TYPE_QUERY_POOL = 12;
    public static final int VK_OBJECT_TYPE_BUFFER_VIEW = 13;
    public static final int VK_OBJECT_TYPE_IMAGE_VIEW = 14;
    public static final int VK_OBJECT_TYPE_SHADER_MODULE = 15;
    public static final int VK_OBJECT_TYPE_PIPELINE_CACHE = 16;
    public static final int VK_OBJECT_TYPE_PIPELINE_LAYOUT = 17;
    public static final int VK_OBJECT_TYPE_RENDER_PASS = 18;
    public static final int VK_OBJECT_TYPE_PIPELINE = 19;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT = 20;
    public static final int VK_OBJECT_TYPE_SAMPLER = 21;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_POOL = 22;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_SET = 23;
    public static final int VK_OBJECT_TYPE_FRAMEBUFFER = 24;
    public static final int VK_OBJECT_TYPE_COMMAND_POOL = 25;
    public static final int VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION = 1000156000;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE = 1000085000;
    public static final int VK_OBJECT_TYPE_PRIVATE_DATA_SLOT = 1000295000;
    public static final int VK_OBJECT_TYPE_SURFACE_KHR = 1000000000;
    public static final int VK_OBJECT_TYPE_SWAPCHAIN_KHR = 1000001000;
    public static final int VK_OBJECT_TYPE_DISPLAY_KHR = 1000002000;
    public static final int VK_OBJECT_TYPE_DISPLAY_MODE_KHR = 1000002001;
    public static final int VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT = 1000011000;
    public static final int VK_OBJECT_TYPE_VIDEO_SESSION_KHR = 1000023000;
    public static final int VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR = 1000023001;
    public static final int VK_OBJECT_TYPE_CU_MODULE_NVX = 1000029000;
    public static final int VK_OBJECT_TYPE_CU_FUNCTION_NVX = 1000029001;
    public static final int VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT = 1000128000;
    public static final int VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR = 1000150000;
    public static final int VK_OBJECT_TYPE_VALIDATION_CACHE_EXT = 1000160000;
    public static final int VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV = 1000165000;
    public static final int VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL = 1000210000;
    public static final int VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR = 1000268000;
    public static final int VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV = 1000277000;
    public static final int VK_OBJECT_TYPE_CUDA_MODULE_NV = 1000307000;
    public static final int VK_OBJECT_TYPE_CUDA_FUNCTION_NV = 1000307001;
    public static final int VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA = 1000366000;
    public static final int VK_OBJECT_TYPE_MICROMAP_EXT = 1000396000;
    public static final int VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV = 1000464000;
    public static final int VK_OBJECT_TYPE_SHADER_EXT = 1000482000;
    public static final int VK_OBJECT_TYPE_PIPELINE_BINARY_KHR = 1000483000;
    public static final int VK_OBJECT_TYPE_SEMAPHORE_SCI_SYNC_POOL_NV = 1000489000;

    public static String explain(@enumtype(VkObjectType.class) int value) {
        return switch (value) {
            case VK_OBJECT_TYPE_UNKNOWN -> "VK_OBJECT_TYPE_UNKNOWN";
            case VK_OBJECT_TYPE_INSTANCE -> "VK_OBJECT_TYPE_INSTANCE";
            case VK_OBJECT_TYPE_PHYSICAL_DEVICE -> "VK_OBJECT_TYPE_PHYSICAL_DEVICE";
            case VK_OBJECT_TYPE_DEVICE -> "VK_OBJECT_TYPE_DEVICE";
            case VK_OBJECT_TYPE_QUEUE -> "VK_OBJECT_TYPE_QUEUE";
            case VK_OBJECT_TYPE_SEMAPHORE -> "VK_OBJECT_TYPE_SEMAPHORE";
            case VK_OBJECT_TYPE_COMMAND_BUFFER -> "VK_OBJECT_TYPE_COMMAND_BUFFER";
            case VK_OBJECT_TYPE_FENCE -> "VK_OBJECT_TYPE_FENCE";
            case VK_OBJECT_TYPE_DEVICE_MEMORY -> "VK_OBJECT_TYPE_DEVICE_MEMORY";
            case VK_OBJECT_TYPE_BUFFER -> "VK_OBJECT_TYPE_BUFFER";
            case VK_OBJECT_TYPE_IMAGE -> "VK_OBJECT_TYPE_IMAGE";
            case VK_OBJECT_TYPE_EVENT -> "VK_OBJECT_TYPE_EVENT";
            case VK_OBJECT_TYPE_QUERY_POOL -> "VK_OBJECT_TYPE_QUERY_POOL";
            case VK_OBJECT_TYPE_BUFFER_VIEW -> "VK_OBJECT_TYPE_BUFFER_VIEW";
            case VK_OBJECT_TYPE_IMAGE_VIEW -> "VK_OBJECT_TYPE_IMAGE_VIEW";
            case VK_OBJECT_TYPE_SHADER_MODULE -> "VK_OBJECT_TYPE_SHADER_MODULE";
            case VK_OBJECT_TYPE_PIPELINE_CACHE -> "VK_OBJECT_TYPE_PIPELINE_CACHE";
            case VK_OBJECT_TYPE_PIPELINE_LAYOUT -> "VK_OBJECT_TYPE_PIPELINE_LAYOUT";
            case VK_OBJECT_TYPE_RENDER_PASS -> "VK_OBJECT_TYPE_RENDER_PASS";
            case VK_OBJECT_TYPE_PIPELINE -> "VK_OBJECT_TYPE_PIPELINE";
            case VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT -> "VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT";
            case VK_OBJECT_TYPE_SAMPLER -> "VK_OBJECT_TYPE_SAMPLER";
            case VK_OBJECT_TYPE_DESCRIPTOR_POOL -> "VK_OBJECT_TYPE_DESCRIPTOR_POOL";
            case VK_OBJECT_TYPE_DESCRIPTOR_SET -> "VK_OBJECT_TYPE_DESCRIPTOR_SET";
            case VK_OBJECT_TYPE_FRAMEBUFFER -> "VK_OBJECT_TYPE_FRAMEBUFFER";
            case VK_OBJECT_TYPE_COMMAND_POOL -> "VK_OBJECT_TYPE_COMMAND_POOL";
            case VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION -> "VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION";
            case VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE -> "VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE";
            case VK_OBJECT_TYPE_PRIVATE_DATA_SLOT -> "VK_OBJECT_TYPE_PRIVATE_DATA_SLOT";
            case VK_OBJECT_TYPE_SURFACE_KHR -> "VK_OBJECT_TYPE_SURFACE_KHR";
            case VK_OBJECT_TYPE_SWAPCHAIN_KHR -> "VK_OBJECT_TYPE_SWAPCHAIN_KHR";
            case VK_OBJECT_TYPE_DISPLAY_KHR -> "VK_OBJECT_TYPE_DISPLAY_KHR";
            case VK_OBJECT_TYPE_DISPLAY_MODE_KHR -> "VK_OBJECT_TYPE_DISPLAY_MODE_KHR";
            case VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT -> "VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT";
            case VK_OBJECT_TYPE_VIDEO_SESSION_KHR -> "VK_OBJECT_TYPE_VIDEO_SESSION_KHR";
            case VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR -> "VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR";
            case VK_OBJECT_TYPE_CU_MODULE_NVX -> "VK_OBJECT_TYPE_CU_MODULE_NVX";
            case VK_OBJECT_TYPE_CU_FUNCTION_NVX -> "VK_OBJECT_TYPE_CU_FUNCTION_NVX";
            case VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT -> "VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT";
            case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR -> "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR";
            case VK_OBJECT_TYPE_VALIDATION_CACHE_EXT -> "VK_OBJECT_TYPE_VALIDATION_CACHE_EXT";
            case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV -> "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV";
            case VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL -> "VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL";
            case VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR -> "VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR";
            case VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV -> "VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV";
            case VK_OBJECT_TYPE_CUDA_MODULE_NV -> "VK_OBJECT_TYPE_CUDA_MODULE_NV";
            case VK_OBJECT_TYPE_CUDA_FUNCTION_NV -> "VK_OBJECT_TYPE_CUDA_FUNCTION_NV";
            case VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA -> "VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA";
            case VK_OBJECT_TYPE_MICROMAP_EXT -> "VK_OBJECT_TYPE_MICROMAP_EXT";
            case VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV -> "VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV";
            case VK_OBJECT_TYPE_SHADER_EXT -> "VK_OBJECT_TYPE_SHADER_EXT";
            case VK_OBJECT_TYPE_PIPELINE_BINARY_KHR -> "VK_OBJECT_TYPE_PIPELINE_BINARY_KHR";
            case VK_OBJECT_TYPE_SEMAPHORE_SCI_SYNC_POOL_NV -> "VK_OBJECT_TYPE_SEMAPHORE_SCI_SYNC_POOL_NV";
            default -> "Unknown";
        };
    }
}
