package tech.icey.vk4j.datatype;

import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.pointer;
import tech.icey.vk4j.enumtype.VkStructureType;
import tech.icey.vk4j.handle.VkValidationCacheEXT;

import java.lang.foreign.*;

import static java.lang.foreign.ValueLayout.OfInt;
import static java.lang.foreign.ValueLayout.PathElement;
import static tech.icey.vk4j.enumtype.VkStructureType.VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT;

/// {@snippet lang=c :
/// typedef struct VkShaderModuleValidationCacheCreateInfoEXT {
///     VkStructureType sType;
///     const void* pNext;
///     VkValidationCacheEXT validationCache;
/// } VkShaderModuleValidationCacheCreateInfoEXT;}
///
/// @see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkShaderModuleValidationCacheCreateInfoEXT.html">VkShaderModuleValidationCacheCreateInfoEXT</a>
public record VkShaderModuleValidationCacheCreateInfoEXT(MemorySegment segment) implements IPointer {
    public VkShaderModuleValidationCacheCreateInfoEXT(MemorySegment segment) {
        this.segment = segment;
        this.sType(VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT);
    }

    public @enumtype(VkStructureType.class) int sType() {
        return segment.get(LAYOUT$sType, OFFSET$sType);
    }

    public void sType(@enumtype(VkStructureType.class) int value) {
        segment.set(LAYOUT$sType, OFFSET$sType, value);
    }

    public @pointer(comment="void*") MemorySegment pNext() {
        return segment.get(LAYOUT$pNext, OFFSET$pNext);
    }

    public void pNext(@pointer(comment="void*") MemorySegment value) {
        segment.set(LAYOUT$pNext, OFFSET$pNext, value);
    }

    public void pNext(IPointer pointer) {
        pNext(pointer.segment());
    }

    public @nullable VkValidationCacheEXT validationCache() {
        MemorySegment s = segment.get(LAYOUT$validationCache, OFFSET$validationCache);
        if (s.address() == 0) {
            return null;
        }
        return new VkValidationCacheEXT(s);
    }

    public void validationCache(@nullable VkValidationCacheEXT value) {
        segment.set(
            LAYOUT$validationCache,
            OFFSET$validationCache,
            value != null ? value.segment() : MemorySegment.NULL
        );
    }

    public static VkShaderModuleValidationCacheCreateInfoEXT allocate(Arena arena) {
        return new VkShaderModuleValidationCacheCreateInfoEXT(arena.allocate(LAYOUT));
    }

    public static VkShaderModuleValidationCacheCreateInfoEXT[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkShaderModuleValidationCacheCreateInfoEXT[] ret = new VkShaderModuleValidationCacheCreateInfoEXT[count];
        for (int i = 0; i < count; i++) {
            ret[i] = new VkShaderModuleValidationCacheCreateInfoEXT(segment.asSlice(i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkShaderModuleValidationCacheCreateInfoEXT clone(Arena arena, VkShaderModuleValidationCacheCreateInfoEXT src) {
        VkShaderModuleValidationCacheCreateInfoEXT ret = allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkShaderModuleValidationCacheCreateInfoEXT[] clone(Arena arena, VkShaderModuleValidationCacheCreateInfoEXT[] src) {
        VkShaderModuleValidationCacheCreateInfoEXT[] ret = allocate(arena, src.length);
        for (int i = 0; i < src.length; i++) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }

    public static final MemoryLayout LAYOUT = NativeLayout.structLayout(
        ValueLayout.JAVA_INT.withName("sType"),
        ValueLayout.ADDRESS.withName("pNext"),
        ValueLayout.ADDRESS.withName("validationCache")
    );
    public static final long SIZE = LAYOUT.byteSize();

    public static final PathElement PATH$sType = PathElement.groupElement("sType");
    public static final PathElement PATH$pNext = PathElement.groupElement("pNext");
    public static final PathElement PATH$validationCache = PathElement.groupElement("validationCache");

    public static final OfInt LAYOUT$sType = (OfInt) LAYOUT.select(PATH$sType);
    public static final AddressLayout LAYOUT$pNext = (AddressLayout) LAYOUT.select(PATH$pNext);
    public static final AddressLayout LAYOUT$validationCache = (AddressLayout) LAYOUT.select(PATH$validationCache);

    public static final long OFFSET$sType = LAYOUT.byteOffset(PATH$sType);
    public static final long OFFSET$pNext = LAYOUT.byteOffset(PATH$pNext);
    public static final long OFFSET$validationCache = LAYOUT.byteOffset(PATH$validationCache);

    public static final long SIZE$sType = LAYOUT$sType.byteSize();
    public static final long SIZE$pNext = LAYOUT$pNext.byteSize();
    public static final long SIZE$validationCache = LAYOUT$validationCache.byteSize();
}
