package tech.icey.vk4j.datatype;

import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.enumtype;
import tech.icey.panama.annotation.pointer;
import tech.icey.vk4j.bitmask.VkSampleCountFlags;
import tech.icey.vk4j.enumtype.VkStructureType;

import java.lang.foreign.*;

import static java.lang.foreign.ValueLayout.OfInt;
import static java.lang.foreign.ValueLayout.PathElement;
import static tech.icey.vk4j.enumtype.VkStructureType.VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV;

/// {@snippet lang=c :
/// typedef struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
///     VkStructureType sType;
///     void* pNext;
///     VkSampleCountFlagBits maxFragmentShadingRateInvocationCount;
/// } VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV;}
///
/// @see <a href="https://registry.khronos.org/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV.html">VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV</a>
public record VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV(MemorySegment segment) implements IPointer {
    public VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV(MemorySegment segment) {
        this.segment = segment;
        this.sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV);
    }

    public @enumtype(VkStructureType.class) int sType() {
        return segment.get(LAYOUT$sType, OFFSET$sType);
    }

    public void sType(@enumtype(VkStructureType.class) int value) {
        segment.set(LAYOUT$sType, OFFSET$sType, value);
    }

    public @pointer(comment="void*") MemorySegment pNext() {
        return segment.get(LAYOUT$pNext, OFFSET$pNext);
    }

    public void pNext(@pointer(comment="void*") MemorySegment value) {
        segment.set(LAYOUT$pNext, OFFSET$pNext, value);
    }

    public void pNext(IPointer pointer) {
        pNext(pointer.segment());
    }

    public @enumtype(VkSampleCountFlags.class) int maxFragmentShadingRateInvocationCount() {
        return segment.get(LAYOUT$maxFragmentShadingRateInvocationCount, OFFSET$maxFragmentShadingRateInvocationCount);
    }

    public void maxFragmentShadingRateInvocationCount(@enumtype(VkSampleCountFlags.class) int value) {
        segment.set(LAYOUT$maxFragmentShadingRateInvocationCount, OFFSET$maxFragmentShadingRateInvocationCount, value);
    }

    public static VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV allocate(Arena arena) {
        return new VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV(arena.allocate(LAYOUT));
    }

    public static VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[] ret = new VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[count];
        for (int i = 0; i < count; i++) {
            ret[i] = new VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV(segment.asSlice(i * SIZE, SIZE));
        }
        return ret;
    }

    public static VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV clone(Arena arena, VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV src) {
        VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV ret = allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[] clone(Arena arena, VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[] src) {
        VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV[] ret = allocate(arena, src.length);
        for (int i = 0; i < src.length; i++) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }

    public static final MemoryLayout LAYOUT = NativeLayout.structLayout(
        ValueLayout.JAVA_INT.withName("sType"),
        ValueLayout.ADDRESS.withName("pNext"),
        ValueLayout.JAVA_INT.withName("maxFragmentShadingRateInvocationCount")
    );
    public static final long SIZE = LAYOUT.byteSize();

    public static final PathElement PATH$sType = PathElement.groupElement("sType");
    public static final PathElement PATH$pNext = PathElement.groupElement("pNext");
    public static final PathElement PATH$maxFragmentShadingRateInvocationCount = PathElement.groupElement("maxFragmentShadingRateInvocationCount");

    public static final OfInt LAYOUT$sType = (OfInt) LAYOUT.select(PATH$sType);
    public static final AddressLayout LAYOUT$pNext = (AddressLayout) LAYOUT.select(PATH$pNext);
    public static final OfInt LAYOUT$maxFragmentShadingRateInvocationCount = (OfInt) LAYOUT.select(PATH$maxFragmentShadingRateInvocationCount);

    public static final long OFFSET$sType = LAYOUT.byteOffset(PATH$sType);
    public static final long OFFSET$pNext = LAYOUT.byteOffset(PATH$pNext);
    public static final long OFFSET$maxFragmentShadingRateInvocationCount = LAYOUT.byteOffset(PATH$maxFragmentShadingRateInvocationCount);

    public static final long SIZE$sType = LAYOUT$sType.byteSize();
    public static final long SIZE$pNext = LAYOUT$pNext.byteSize();
    public static final long SIZE$maxFragmentShadingRateInvocationCount = LAYOUT$maxFragmentShadingRateInvocationCount.byteSize();
}
