/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.structlog4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Formatter {
    public static final String KEY_MESSAGE = "_message";
    public static final String KEY_ERROR_MESSAGE = "_errorMessage";
    public static final String KEY_STACK_TRACE = "_stackTrace";
    public static final String STR_TAB = "\t";
    public static final String STR_R = "\r";
    public static final String STR_WRAP = "\n";
    public static final String REPLACE_TAB = "\\t";
    public static final String REPLACE_R = "\\r";
    public static final String REPLACE_WRAP = "\\n";
    public static final String SPACE = " ";

    public String format(Map<String, ?> var1);

    default public String format(String message) {
        return this.format(message, null);
    }

    default public String format(String message, Throwable t) {
        LinkedHashMap<String, String> kvMap = new LinkedHashMap<String, String>(3);
        kvMap.put(KEY_MESSAGE, message);
        if (null != t) {
            kvMap.put(KEY_ERROR_MESSAGE, this.getErrorMessage(t));
            kvMap.put(KEY_STACK_TRACE, this.getStackTrace(t));
        }
        return this.format(kvMap);
    }

    default public String format(Object[] messages) {
        return this.format(this.getMessage(messages));
    }

    default public String format(Object[] messages, Throwable t) {
        return this.format(this.getMessage(messages), t);
    }

    default public String getMessage(Object[] messages) {
        if (null == messages || 0 == messages.length) {
            return "";
        }
        if (1 == messages.length) {
            return String.valueOf(messages[0]);
        }
        return String.format(String.valueOf(messages[0]).replace("{}", "%s"), Arrays.copyOfRange(messages, 1, messages.length));
    }

    default public String formatString(String originalStr) {
        if (null == originalStr) {
            return null;
        }
        return originalStr.replace(STR_TAB, REPLACE_TAB).replace(STR_R, REPLACE_R).replace(STR_WRAP, REPLACE_WRAP);
    }

    default public String getErrorMessage(Throwable t) {
        if (t.getCause() == null) {
            return t.getMessage();
        }
        return this.getErrorMessage(t.getCause());
    }

    default public String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return this.formatString(sw.getBuffer().toString());
    }
}

